/*
 * Decompiled with CFR 0.152.
 */
package org.glassmaker.spring.web;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.mirror.Mirror;
import com.google.api.services.mirror.model.Attachment;
import com.google.api.services.mirror.model.Contact;
import com.google.api.services.mirror.model.ContactsListResponse;
import com.google.api.services.mirror.model.Subscription;
import com.google.api.services.mirror.model.SubscriptionsListResponse;
import com.google.api.services.mirror.model.TimelineItem;
import com.google.api.services.mirror.model.TimelineListResponse;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassmaker.spring.web.TemplateMerger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="mirrorTemplate")
public class MirrorTemplate {
    private static final Log logger = LogFactory.getLog(MirrorTemplate.class);
    @Autowired
    private TemplateMerger templateMerger;

    public Mirror getMirror() {
        return new Mirror.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.getCredential()).setApplicationName("Glassmaker Plugin").build();
    }

    public Contact insertContact(Contact contact) throws IOException {
        Mirror.Contacts contacts = this.getMirror().contacts();
        return (Contact)contacts.insert(contact).execute();
    }

    public void deleteContact(String contactId) throws IOException {
        Mirror.Contacts contacts = this.getMirror().contacts();
        contacts.delete(contactId).execute();
    }

    public ContactsListResponse listContacts() throws IOException {
        Mirror.Contacts contacts = this.getMirror().contacts();
        return (ContactsListResponse)contacts.list().execute();
    }

    public Contact getContact(String id) throws IOException {
        try {
            Mirror.Contacts contacts = this.getMirror().contacts();
            return (Contact)contacts.get(id).execute();
        }
        catch (GoogleJsonResponseException e) {
            logger.warn((Object)("Could not find contact with ID " + id));
            return null;
        }
    }

    public TimelineListResponse listItems(long count) throws IOException {
        Mirror.Timeline timelineItems = this.getMirror().timeline();
        Mirror.Timeline.List list = timelineItems.list();
        list.setMaxResults(Long.valueOf(count));
        return (TimelineListResponse)list.execute();
    }

    public Subscription insertSubscription(String callbackUrl, String collection) throws IOException {
        String userId = this.getUserId();
        logger.info((Object)("Attempting to subscribe verify_token " + userId + " with callback " + callbackUrl));
        callbackUrl = callbackUrl.replace("appspot.com", "Appspot.com");
        Subscription subscription = new Subscription();
        subscription.setCollection(collection);
        subscription.setCallbackUrl(callbackUrl);
        subscription.setUserToken(userId);
        return (Subscription)this.getMirror().subscriptions().insert(subscription).execute();
    }

    public void deleteSubscription(String id) throws IOException {
        this.getMirror().subscriptions().delete(id).execute();
    }

    public SubscriptionsListResponse listSubscriptions(Credential credential) throws IOException {
        Mirror.Subscriptions subscriptions = this.getMirror().subscriptions();
        return (SubscriptionsListResponse)subscriptions.list().execute();
    }

    public TimelineItem insertTimelineItem(TimelineItem item) throws IOException {
        return (TimelineItem)this.getMirror().timeline().insert(item).execute();
    }

    public void insertTimelineItem(TimelineItem item, String attachmentContentType, byte[] attachmentData) throws IOException {
        Mirror.Timeline timeline = this.getMirror().timeline();
        timeline.insert(item, (AbstractInputStreamContent)new ByteArrayContent(attachmentContentType, attachmentData)).execute();
    }

    public void insertTimelineItem(TimelineItem item, String attachmentContentType, InputStream attachmentInputStream) throws IOException {
        this.insertTimelineItem(item, attachmentContentType, ByteStreams.toByteArray((InputStream)attachmentInputStream));
    }

    public InputStream getAttachmentInputStream(String timelineItemId, String attachmentId) throws IOException {
        Mirror mirrorService = this.getMirror();
        Mirror.Timeline.Attachments attachments = mirrorService.timeline().attachments();
        Attachment attachmentMetadata = (Attachment)attachments.get(timelineItemId, attachmentId).execute();
        HttpResponse resp = mirrorService.getRequestFactory().buildGetRequest(new GenericUrl(attachmentMetadata.getContentUrl())).execute();
        return resp.getContent();
    }

    public String getAttachmentContentType(String timelineItemId, String attachmentId) throws IOException {
        Mirror.Timeline.Attachments attachments = this.getMirror().timeline().attachments();
        Attachment attachmentMetadata = (Attachment)attachments.get(timelineItemId, attachmentId).execute();
        return attachmentMetadata.getContentType();
    }

    public void deleteTimelineItem(String timelineItemId) throws IOException {
        this.getMirror().timeline().delete(timelineItemId).execute();
    }

    private Credential getCredential() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
        String accessToken = (String)token.getDetails();
        GoogleCredential credential = new GoogleCredential().setAccessToken(accessToken);
        return credential;
    }

    private String getUserId() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
        String userId = (String)token.getPrincipal();
        return userId;
    }

    public TimelineItem render(ModelAndView mav) throws Exception {
        TimelineItem timelineItem = new TimelineItem();
        String article = this.templateMerger.merge(mav.getViewName(), (Map<String, ?>)mav.getModelMap());
        timelineItem.setHtml(article);
        return timelineItem;
    }
}

