/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ColorRole {
    PRIMARY,
    ON_PRIMARY,
    PRIMARY_CONTAINER,
    ON_PRIMARY_CONTAINER,
    PRIMARY_FIXED,
    PRIMARY_FIXED_DIM,
    ON_PRIMARY_FIXED,
    ON_PRIMARY_FIXED_VARIANT,
    SECONDARY,
    ON_SECONDARY,
    SECONDARY_CONTAINER,
    ON_SECONDARY_CONTAINER,
    SECONDARY_FIXED,
    SECONDARY_FIXED_DIM,
    ON_SECONDARY_FIXED,
    ON_SECONDARY_FIXED_VARIANT,
    TERTIARY,
    ON_TERTIARY,
    TERTIARY_CONTAINER,
    ON_TERTIARY_CONTAINER,
    TERTIARY_FIXED,
    TERTIARY_FIXED_DIM,
    ON_TERTIARY_FIXED,
    ON_TERTIARY_FIXED_VARIANT,
    ERROR,
    ON_ERROR,
    ERROR_CONTAINER,
    ON_ERROR_CONTAINER,
    SURFACE,
    ON_SURFACE,
    SURFACE_DIM,
    SURFACE_BRIGHT,
    SURFACE_CONTAINER_LOWEST,
    SURFACE_CONTAINER_LOW,
    SURFACE_CONTAINER,
    SURFACE_CONTAINER_HIGH,
    SURFACE_CONTAINER_HIGHEST,
    SURFACE_VARIANT,
    ON_SURFACE_VARIANT,
    BACKGROUND,
    ON_BACKGROUND,
    OUTLINE,
    OUTLINE_VARIANT,
    SHADOW,
    SCRIM,
    INVERSE_SURFACE,
    INVERSE_ON_SURFACE,
    INVERSE_PRIMARY,
    SURFACE_TINT;

    static final String DEFAULT_VARIABLE_NAME_PREFIX = "-monet";
    public static final List<ColorRole> ALL;
    private static final Map<String, ColorRole> searchTable;
    final String displayName;
    final String variableNameBase;
    final String defaultVariableName;

    private ColorRole() {
        CharSequence[] parts = this.name().split("_");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).charAt(0) + ((String)parts[i]).substring(1).toLowerCase(Locale.ROOT);
        }
        this.displayName = String.join((CharSequence)" ", parts);
        this.variableNameBase = this.name().toLowerCase(Locale.ROOT).replace("_", "-");
        this.defaultVariableName = "-monet-" + this.variableNameBase;
    }

    private static String normalizeName(String name) {
        if (name.indexOf(95) >= 0) {
            name = name.replace("_", "");
        } else if (name.indexOf(45) >= 0) {
            name = name.replace("-", "");
        }
        return name.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static ColorRole of(@NotNull String role) {
        return searchTable.get(ColorRole.normalizeName(role));
    }

    int getArgb(DynamicScheme scheme) {
        switch (this.ordinal()) {
            case 0: {
                return scheme.getPrimary();
            }
            case 1: {
                return scheme.getOnPrimary();
            }
            case 2: {
                return scheme.getPrimaryContainer();
            }
            case 3: {
                return scheme.getOnPrimaryContainer();
            }
            case 4: {
                return scheme.getPrimaryFixed();
            }
            case 5: {
                return scheme.getPrimaryFixedDim();
            }
            case 6: {
                return scheme.getOnPrimaryFixed();
            }
            case 7: {
                return scheme.getOnPrimaryFixedVariant();
            }
            case 8: {
                return scheme.getSecondary();
            }
            case 9: {
                return scheme.getOnSecondary();
            }
            case 10: {
                return scheme.getSecondaryContainer();
            }
            case 11: {
                return scheme.getOnSecondaryContainer();
            }
            case 12: {
                return scheme.getSecondaryFixed();
            }
            case 13: {
                return scheme.getSecondaryFixedDim();
            }
            case 14: {
                return scheme.getOnSecondaryFixed();
            }
            case 15: {
                return scheme.getOnSecondaryFixedVariant();
            }
            case 16: {
                return scheme.getTertiary();
            }
            case 17: {
                return scheme.getOnTertiary();
            }
            case 18: {
                return scheme.getTertiaryContainer();
            }
            case 19: {
                return scheme.getOnTertiaryContainer();
            }
            case 20: {
                return scheme.getTertiaryFixed();
            }
            case 21: {
                return scheme.getTertiaryFixedDim();
            }
            case 22: {
                return scheme.getOnTertiaryFixed();
            }
            case 23: {
                return scheme.getOnTertiaryFixedVariant();
            }
            case 24: {
                return scheme.getError();
            }
            case 25: {
                return scheme.getOnError();
            }
            case 26: {
                return scheme.getErrorContainer();
            }
            case 27: {
                return scheme.getOnErrorContainer();
            }
            case 28: {
                return scheme.getSurface();
            }
            case 29: {
                return scheme.getOnSurface();
            }
            case 30: {
                return scheme.getSurfaceDim();
            }
            case 31: {
                return scheme.getSurfaceBright();
            }
            case 32: {
                return scheme.getSurfaceContainerLowest();
            }
            case 33: {
                return scheme.getSurfaceContainerLow();
            }
            case 34: {
                return scheme.getSurfaceContainer();
            }
            case 35: {
                return scheme.getSurfaceContainerHigh();
            }
            case 36: {
                return scheme.getSurfaceContainerHighest();
            }
            case 37: {
                return scheme.getSurfaceVariant();
            }
            case 38: {
                return scheme.getOnSurfaceVariant();
            }
            case 39: {
                return scheme.getBackground();
            }
            case 40: {
                return scheme.getOnBackground();
            }
            case 41: {
                return scheme.getOutline();
            }
            case 42: {
                return scheme.getOutlineVariant();
            }
            case 43: {
                return scheme.getShadow();
            }
            case 44: {
                return scheme.getScrim();
            }
            case 45: {
                return scheme.getInverseSurface();
            }
            case 46: {
                return scheme.getInverseOnSurface();
            }
            case 47: {
                return scheme.getInversePrimary();
            }
            case 48: {
                return scheme.getSurfaceTint();
            }
        }
        throw new AssertionError((Object)("Unknown color role: " + (Object)((Object)this)));
    }

    public String getVariableName(String prefix) {
        return prefix + "-" + this.variableNameBase;
    }

    public String getVariableName() {
        return this.defaultVariableName;
    }

    public String toString() {
        return this.displayName;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(ColorRole.values()));
        searchTable = new HashMap<String, ColorRole>();
        for (ColorRole role : ALL) {
            if (searchTable.put(ColorRole.normalizeName(role.name()), role) != null) {
                throw new AssertionError((Object)("Duplicate role: " + (Object)((Object)role)));
            }
        }
    }
}

