/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorRole;
import org.glavo.monetfx.ColorSchemeBuilder;
import org.glavo.monetfx.ColorStyle;
import org.glavo.monetfx.Contrast;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.glavo.monetfx.internal.hct.Hct;
import org.glavo.monetfx.internal.quantize.QuantizerCelebi;
import org.glavo.monetfx.internal.score.Score;
import org.glavo.monetfx.internal.utils.ColorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorScheme {
    static final Color FALLBACK_COLOR = Color.web((String)"#4285f4");
    static final int MAX_DIMENSION = 112;
    private final DynamicScheme scheme;
    @NotNull
    private final Color primaryColorSeed;
    @Nullable
    private final Color secondaryColorSeed;
    @Nullable
    private final Color tertiaryColorSeed;
    @Nullable
    private final Color neutralColorSeed;
    @Nullable
    private final Color neutralVariantColorSeed;
    @Nullable
    private final Color errorColorSeed;
    private final Color[] colors = new Color[ColorRole.ALL.size()];

    static int[] imageToScaled(Image image) {
        if (image.isBackgroundLoading()) {
            throw new IllegalArgumentException("The image data is not ready yet");
        }
        if (image.isError()) {
            throw new IllegalArgumentException("The image was not loaded successfully", image.getException());
        }
        int sourceWidth = (int)image.getWidth();
        int sourceHeight = (int)image.getHeight();
        if (sourceWidth <= 0 || sourceHeight <= 0) {
            throw new IllegalArgumentException("Image dimensions must be greater than zero.");
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalArgumentException("Unable to read pixels of image");
        }
        if (sourceWidth <= 112 && sourceHeight <= 112) {
            int[] result = new int[sourceWidth * sourceHeight];
            pixelReader.getPixels(0, 0, sourceWidth, sourceHeight, PixelFormat.getIntArgbInstance(), result, 0, sourceWidth);
            return result;
        }
        int targetWidth = Math.min(sourceWidth, 112);
        int targetHeight = Math.min(sourceHeight, 112);
        double xScale = (double)sourceWidth / (double)targetWidth;
        double yScale = (double)sourceHeight / (double)targetHeight;
        int[] result = new int[targetWidth * targetHeight];
        for (int y = 0; y < targetHeight; ++y) {
            int resultOffset = y * targetWidth;
            for (int x = 0; x < targetWidth; ++x) {
                result[resultOffset + x] = pixelReader.getArgb((int)((double)x * xScale), (int)((double)y * yScale));
            }
        }
        return result;
    }

    static Color extractColor(Image image, Color fallbackColor) {
        int[] imageData = ColorScheme.imageToScaled(image);
        Map<Integer, Integer> quantizeResult = QuantizerCelebi.quantize(imageData, 128);
        List<Integer> scoredResults = Score.score(quantizeResult, 1, ColorUtils.argbFromFx(fallbackColor));
        return ColorUtils.fxFromArgb(scoredResults.get(0));
    }

    @NotNull
    public static ColorScheme fromImage(@NotNull Image image) {
        return ColorScheme.fromSeed(ColorScheme.extractColor(image, FALLBACK_COLOR));
    }

    public static ColorScheme fromSeed(@NotNull Color seedColor) {
        Hct seedColorHct = Hct.fromInt(ColorUtils.argbFromFx(seedColor));
        double contrastLevel = Contrast.STANDARD.getValue();
        DynamicScheme scheme = new DynamicScheme(seedColorHct, ColorStyle.TONAL_SPOT, false, Contrast.STANDARD.getValue(), ColorStyle.TONAL_SPOT.getPrimaryPalette(seedColorHct, false, contrastLevel), ColorStyle.TONAL_SPOT.getSecondaryPalette(seedColorHct, false, contrastLevel), ColorStyle.TONAL_SPOT.getTertiaryPalette(seedColorHct, false, contrastLevel), ColorStyle.TONAL_SPOT.getNeutralPalette(seedColorHct, false, contrastLevel), ColorStyle.TONAL_SPOT.getNeutralVariantPalette(seedColorHct, false, contrastLevel), DynamicScheme.DEFAULT_ERROR_PALETTE);
        return new ColorScheme(scheme, seedColor, null, null, null, null, null);
    }

    public static ColorSchemeBuilder newBuilder() {
        return new ColorSchemeBuilder();
    }

    ColorScheme(DynamicScheme scheme, Color primaryColorSeed, Color secondaryColorSeed, Color tertiaryColorSeed, Color neutralColorSeed, Color neutralVariantColorSeed, Color errorColorSeed) {
        this.scheme = scheme;
        this.primaryColorSeed = primaryColorSeed;
        this.secondaryColorSeed = secondaryColorSeed;
        this.tertiaryColorSeed = tertiaryColorSeed;
        this.neutralColorSeed = neutralColorSeed;
        this.neutralVariantColorSeed = neutralVariantColorSeed;
        this.errorColorSeed = errorColorSeed;
    }

    @NotNull
    public Brightness getBrightness() {
        return this.scheme.isDark ? Brightness.DARK : Brightness.LIGHT;
    }

    public double getContrastLevel() {
        return this.scheme.contrastLevel;
    }

    @NotNull
    public ColorStyle getColorStyle() {
        return this.scheme.variant;
    }

    @NotNull
    public Color getPrimaryColorSeed() {
        return this.primaryColorSeed;
    }

    @Nullable
    public Color getSecondaryColorSeed() {
        return this.secondaryColorSeed;
    }

    @Nullable
    public Color getTertiaryColorSeed() {
        return this.tertiaryColorSeed;
    }

    @Nullable
    public Color getNeutralColorSeed() {
        return this.neutralColorSeed;
    }

    @Nullable
    public Color getNeutralVariantColorSeed() {
        return this.neutralVariantColorSeed;
    }

    @Nullable
    public Color getErrorColorSeed() {
        return this.errorColorSeed;
    }

    public Color getColor(@NotNull ColorRole role) {
        Color color = this.colors[role.ordinal()];
        if (color == null) {
            this.colors[role.ordinal()] = color = ColorUtils.fxFromArgb(role.getArgb(this.scheme));
        }
        return color;
    }

    public Color getPrimary() {
        return this.getColor(ColorRole.PRIMARY);
    }

    public Color getOnPrimary() {
        return this.getColor(ColorRole.ON_PRIMARY);
    }

    public Color getPrimaryContainer() {
        return this.getColor(ColorRole.PRIMARY_CONTAINER);
    }

    public Color getOnPrimaryContainer() {
        return this.getColor(ColorRole.ON_PRIMARY_CONTAINER);
    }

    public Color getPrimaryFixed() {
        return this.getColor(ColorRole.PRIMARY_FIXED);
    }

    public Color getPrimaryFixedDim() {
        return this.getColor(ColorRole.PRIMARY_FIXED_DIM);
    }

    public Color getOnPrimaryFixed() {
        return this.getColor(ColorRole.ON_PRIMARY_FIXED);
    }

    public Color getOnPrimaryFixedVariant() {
        return this.getColor(ColorRole.ON_PRIMARY_FIXED_VARIANT);
    }

    public Color getSecondary() {
        return this.getColor(ColorRole.SECONDARY);
    }

    public Color getOnSecondary() {
        return this.getColor(ColorRole.ON_SECONDARY);
    }

    public Color getSecondaryContainer() {
        return this.getColor(ColorRole.SECONDARY_CONTAINER);
    }

    public Color getOnSecondaryContainer() {
        return this.getColor(ColorRole.ON_SECONDARY_CONTAINER);
    }

    public Color getSecondaryFixed() {
        return this.getColor(ColorRole.SECONDARY_FIXED);
    }

    public Color getSecondaryFixedDim() {
        return this.getColor(ColorRole.SECONDARY_FIXED_DIM);
    }

    public Color getOnSecondaryFixed() {
        return this.getColor(ColorRole.ON_SECONDARY_FIXED);
    }

    public Color getOnSecondaryFixedVariant() {
        return this.getColor(ColorRole.ON_SECONDARY_FIXED_VARIANT);
    }

    public Color getTertiary() {
        return this.getColor(ColorRole.TERTIARY);
    }

    public Color getOnTertiary() {
        return this.getColor(ColorRole.ON_TERTIARY);
    }

    public Color getTertiaryContainer() {
        return this.getColor(ColorRole.TERTIARY_CONTAINER);
    }

    public Color getOnTertiaryContainer() {
        return this.getColor(ColorRole.ON_TERTIARY_CONTAINER);
    }

    public Color getTertiaryFixed() {
        return this.getColor(ColorRole.TERTIARY_FIXED);
    }

    public Color getTertiaryFixedDim() {
        return this.getColor(ColorRole.TERTIARY_FIXED_DIM);
    }

    public Color getOnTertiaryFixed() {
        return this.getColor(ColorRole.ON_TERTIARY_FIXED);
    }

    public Color getOnTertiaryFixedVariant() {
        return this.getColor(ColorRole.ON_TERTIARY_FIXED_VARIANT);
    }

    public Color getError() {
        return this.getColor(ColorRole.ERROR);
    }

    public Color getOnError() {
        return this.getColor(ColorRole.ON_ERROR);
    }

    public Color getErrorContainer() {
        return this.getColor(ColorRole.ERROR_CONTAINER);
    }

    public Color getOnErrorContainer() {
        return this.getColor(ColorRole.ON_ERROR_CONTAINER);
    }

    public Color getSurface() {
        return this.getColor(ColorRole.SURFACE);
    }

    public Color getOnSurface() {
        return this.getColor(ColorRole.ON_SURFACE);
    }

    public Color getSurfaceDim() {
        return this.getColor(ColorRole.SURFACE_DIM);
    }

    public Color getSurfaceBright() {
        return this.getColor(ColorRole.SURFACE_BRIGHT);
    }

    public Color getSurfaceContainerLowest() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_LOWEST);
    }

    public Color getSurfaceContainerLow() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_LOW);
    }

    public Color getSurfaceContainer() {
        return this.getColor(ColorRole.SURFACE_CONTAINER);
    }

    public Color getSurfaceContainerHigh() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_HIGH);
    }

    public Color getSurfaceContainerHighest() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_HIGHEST);
    }

    public Color getSurfaceVariant() {
        return this.getColor(ColorRole.SURFACE_VARIANT);
    }

    public Color getOnSurfaceVariant() {
        return this.getColor(ColorRole.ON_SURFACE_VARIANT);
    }

    public Color getBackground() {
        return this.getColor(ColorRole.BACKGROUND);
    }

    public Color getOnBackground() {
        return this.getColor(ColorRole.ON_BACKGROUND);
    }

    public Color getOutline() {
        return this.getColor(ColorRole.OUTLINE);
    }

    public Color getOutlineVariant() {
        return this.getColor(ColorRole.OUTLINE_VARIANT);
    }

    public Color getShadow() {
        return this.getColor(ColorRole.SHADOW);
    }

    public Color getScrim() {
        return this.getColor(ColorRole.SCRIM);
    }

    public Color getInverseSurface() {
        return this.getColor(ColorRole.INVERSE_SURFACE);
    }

    public Color getInverseOnSurface() {
        return this.getColor(ColorRole.INVERSE_ON_SURFACE);
    }

    public Color getInversePrimary() {
        return this.getColor(ColorRole.INVERSE_PRIMARY);
    }

    public Color getSurfaceTint() {
        return this.getColor(ColorRole.SURFACE_TINT);
    }

    public String toStyleSheet() {
        return this.toStyleSheet(null, null, null);
    }

    public String toStyleSheet(@Nullable String cssClass, @Nullable String prefix, @Nullable Iterable<ColorRole> colorRoles) {
        StringBuilder builder = new StringBuilder();
        if (cssClass != null) {
            builder.append('.').append(cssClass).append(" {\n");
        } else {
            builder.append("* {\n");
        }
        if (prefix == null) {
            prefix = "-monet";
        }
        if (colorRoles == null) {
            colorRoles = ColorRole.ALL;
        }
        for (ColorRole colorRole : colorRoles) {
            Color color = this.getColor(colorRole);
            int r = (int)Math.round(color.getRed() * 255.0);
            int g = (int)Math.round(color.getGreen() * 255.0);
            int b = (int)Math.round(color.getBlue() * 255.0);
            builder.append("  ").append(prefix).append('-').append(colorRole.variableNameBase).append(": rgb(").append(r).append(", ").append(g).append(", ").append(b).append(");\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheme.isDark, this.scheme.contrastLevel, this.scheme.variant, this.primaryColorSeed, this.secondaryColorSeed, this.tertiaryColorSeed, this.neutralColorSeed, this.neutralVariantColorSeed, this.errorColorSeed});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorScheme)) {
            return false;
        }
        ColorScheme that = (ColorScheme)obj;
        return this.scheme.isDark == that.scheme.isDark && this.scheme.contrastLevel == that.scheme.contrastLevel && this.scheme.variant == that.scheme.variant && this.primaryColorSeed.equals((Object)that.primaryColorSeed) && Objects.equals(this.secondaryColorSeed, that.secondaryColorSeed) && Objects.equals(this.tertiaryColorSeed, that.tertiaryColorSeed) && Objects.equals(this.neutralColorSeed, that.neutralColorSeed) && Objects.equals(this.neutralVariantColorSeed, that.neutralVariantColorSeed) && Objects.equals(this.errorColorSeed, that.errorColorSeed);
    }

    public String toString() {
        return this.toStyleSheet();
    }
}

