/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.ColorStyle;
import org.glavo.monetfx.Contrast;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.glavo.monetfx.internal.hct.Hct;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ColorSchemeBuilder {
    private Color primaryColorSeed;
    private Color secondaryColorSeed;
    private Color tertiaryColorSeed;
    private Color neutralColorSeed;
    private Color neutralVariantColorSeed;
    private Color errorColorSeed;
    private Brightness brightness = Brightness.LIGHT;
    private ColorStyle colorStyle = ColorStyle.TONAL_SPOT;
    private Contrast contrast = Contrast.STANDARD;

    ColorSchemeBuilder() {
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setPrimaryColorSeed(Color primaryColorSeed) {
        this.primaryColorSeed = primaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setWallpaper(@NotNull Image image) {
        this.primaryColorSeed = ColorScheme.extractColor(image, ColorScheme.FALLBACK_COLOR);
        return this;
    }

    @Contract(value="_, _ -> this", pure=true)
    public ColorSchemeBuilder setWallpaper(@NotNull Image image, Color fallbackColor) {
        this.primaryColorSeed = ColorScheme.extractColor(image, fallbackColor);
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setSecondaryColorSeed(Color secondaryColorSeed) {
        this.secondaryColorSeed = secondaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setTertiaryColorSeed(Color tertiaryColorSeed) {
        this.tertiaryColorSeed = tertiaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setNeutralColorSeed(Color neutralColorSeed) {
        this.neutralColorSeed = neutralColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setNeutralVariantColorSeed(Color neutralVariantColorSeed) {
        this.neutralVariantColorSeed = neutralVariantColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setErrorColorSeed(Color errorColorSeed) {
        this.errorColorSeed = errorColorSeed;
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setBrightness(@NotNull Brightness brightness) {
        this.brightness = Objects.requireNonNull(brightness);
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setColorStyle(@NotNull ColorStyle colorStyle) {
        this.colorStyle = Objects.requireNonNull(colorStyle);
        return this;
    }

    @Contract(value="_ -> this", pure=true)
    public ColorSchemeBuilder setContrast(@NotNull Contrast contrast) {
        this.contrast = Objects.requireNonNull(contrast);
        return this;
    }

    public ColorScheme build() {
        Color primaryColor = this.primaryColorSeed;
        if (primaryColor == null) {
            primaryColor = ColorScheme.FALLBACK_COLOR;
        }
        boolean isDark = this.brightness == Brightness.DARK;
        double contrastLevel = this.contrast.getValue();
        Hct primaryColorHct = Hct.fromFx(primaryColor);
        return new ColorScheme(new DynamicScheme(primaryColorHct, this.colorStyle, isDark, contrastLevel, this.colorStyle.getPrimaryPalette(primaryColorHct, isDark, contrastLevel), this.secondaryColorSeed == null ? this.colorStyle.getSecondaryPalette(primaryColorHct, isDark, contrastLevel) : this.colorStyle.getPrimaryPalette(Hct.fromFx(this.secondaryColorSeed), isDark, contrastLevel), this.tertiaryColorSeed == null ? this.colorStyle.getTertiaryPalette(primaryColorHct, isDark, contrastLevel) : this.colorStyle.getPrimaryPalette(Hct.fromFx(this.tertiaryColorSeed), isDark, contrastLevel), this.neutralColorSeed == null ? this.colorStyle.getNeutralPalette(primaryColorHct, isDark, contrastLevel) : this.colorStyle.getNeutralPalette(Hct.fromFx(this.neutralColorSeed), isDark, contrastLevel), this.neutralVariantColorSeed == null ? this.colorStyle.getNeutralVariantPalette(primaryColorHct, isDark, contrastLevel) : this.colorStyle.getNeutralVariantPalette(Hct.fromFx(this.neutralVariantColorSeed), isDark, contrastLevel), this.errorColorSeed == null ? DynamicScheme.DEFAULT_ERROR_PALETTE : this.colorStyle.getPrimaryPalette(Hct.fromFx(this.errorColorSeed), isDark, contrastLevel)), primaryColor, this.secondaryColorSeed, this.tertiaryColorSeed, this.neutralColorSeed, this.neutralVariantColorSeed, this.errorColorSeed);
    }
}

