/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Locale;
import org.glavo.monetfx.internal.dislike.DislikeAnalyzer;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.glavo.monetfx.internal.hct.Hct;
import org.glavo.monetfx.internal.palettes.TonalPalette;
import org.glavo.monetfx.internal.temperature.TemperatureCache;
import org.glavo.monetfx.internal.utils.MathUtils;

public enum ColorStyle {
    TONAL_SPOT{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 36.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 60.0), 24.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 6.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 8.0);
        }
    }
    ,
    FIDELITY{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma());
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), Math.max(sourceColorHct.getChroma() - 32.0, sourceColorHct.getChroma() * 0.5));
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHct(DislikeAnalyzer.fixIfDisliked(new TemperatureCache(sourceColorHct).getComplement()));
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0 + 4.0);
        }
    }
    ,
    MONOCHROME{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }
    }
    ,
    NEUTRAL{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 12.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 8.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 2.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 2.0);
        }
    }
    ,
    VIBRANT{
        private final double[] HUES = new double[]{0.0, 41.0, 61.0, 101.0, 131.0, 181.0, 251.0, 301.0, 360.0};
        private final double[] SECONDARY_ROTATIONS = new double[]{18.0, 15.0, 10.0, 12.0, 15.0, 18.0, 15.0, 12.0, 12.0};
        private final double[] TERTIARY_ROTATIONS = new double[]{35.0, 30.0, 20.0, 25.0, 30.0, 35.0, 30.0, 25.0, 25.0};

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 200.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, this.HUES, this.SECONDARY_ROTATIONS), 24.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, this.HUES, this.TERTIARY_ROTATIONS), 32.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 10.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 12.0);
        }
    }
    ,
    EXPRESSIVE{
        private final double[] HUES = new double[]{0.0, 21.0, 51.0, 121.0, 151.0, 191.0, 271.0, 321.0, 360.0};
        private final double[] SECONDARY_ROTATIONS = new double[]{45.0, 95.0, 45.0, 20.0, 45.0, 90.0, 45.0, 45.0, 45.0};
        private final double[] TERTIARY_ROTATIONS = new double[]{120.0, 120.0, 20.0, 45.0, 20.0, 15.0, 20.0, 120.0, 120.0};

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 240.0), 40.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, this.HUES, this.SECONDARY_ROTATIONS), 24.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, this.HUES, this.TERTIARY_ROTATIONS), 32.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 15.0), 8.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 15.0), 12.0);
        }
    }
    ,
    CONTENT{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma());
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), Math.max(sourceColorHct.getChroma() - 32.0, sourceColorHct.getChroma() * 0.5));
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHct(DislikeAnalyzer.fixIfDisliked(new TemperatureCache(sourceColorHct).getAnalogousColors(3, 6).get(2)));
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0 + 4.0);
        }
    }
    ,
    RAINBOW{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 48.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 60.0), 24.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
        }
    }
    ,
    FRUIT_SALAD{

        @Override
        TonalPalette getPrimaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() - 50.0), 48.0);
        }

        @Override
        TonalPalette getSecondaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() - 50.0), 36.0);
        }

        @Override
        TonalPalette getTertiaryPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 36.0);
        }

        @Override
        TonalPalette getNeutralPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 10.0);
        }

        @Override
        TonalPalette getNeutralVariantPalette(Hct sourceColorHct, boolean isDark, double contrastLevel) {
            return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
        }
    };

    private final String displayName;

    private ColorStyle() {
        CharSequence[] parts = this.name().split("_");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).charAt(0) + ((String)parts[i]).substring(1).toLowerCase(Locale.ROOT);
        }
        this.displayName = String.join((CharSequence)" ", parts);
    }

    abstract TonalPalette getPrimaryPalette(Hct var1, boolean var2, double var3);

    abstract TonalPalette getSecondaryPalette(Hct var1, boolean var2, double var3);

    abstract TonalPalette getTertiaryPalette(Hct var1, boolean var2, double var3);

    abstract TonalPalette getNeutralPalette(Hct var1, boolean var2, double var3);

    abstract TonalPalette getNeutralVariantPalette(Hct var1, boolean var2, double var3);

    public String toString() {
        return this.displayName;
    }
}

