/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.beans.binding;

import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.beans.binding.ColorSchemeExpression;
import org.glavo.monetfx.internal.beans.BindingHelperObserver;
import org.glavo.monetfx.internal.beans.ExpressionHelper;

public abstract class ColorSchemeBinding
extends ColorSchemeExpression
implements Binding<ColorScheme> {
    private ColorScheme value;
    private boolean valid = false;
    private BindingHelperObserver observer;
    private ExpressionHelper<ColorScheme> helper = null;

    public static ColorSchemeBinding createColorSchemeBinding(final Supplier<? extends ColorScheme> func, final Observable ... dependencies) {
        return new ColorSchemeBinding(){
            {
                this.bind(dependencies);
            }

            @Override
            protected ColorScheme computeValue() {
                return (ColorScheme)func.get();
            }

            @Override
            public void dispose() {
                super.unbind(dependencies);
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Object[])dependencies));
            }
        };
    }

    protected final void bind(Observable ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            if (this.observer == null) {
                this.observer = new BindingHelperObserver(this);
            }
            for (Observable dep : dependencies) {
                dep.addListener((InvalidationListener)this.observer);
            }
        }
    }

    protected final void unbind(Observable ... dependencies) {
        if (this.observer != null) {
            for (Observable dep : dependencies) {
                dep.removeListener((InvalidationListener)this.observer);
            }
            this.observer = null;
        }
    }

    public ColorScheme get() {
        if (!this.valid) {
            this.value = this.computeValue();
            this.valid = true;
        }
        return this.value;
    }

    public void addListener(ChangeListener<? super ColorScheme> listener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, listener);
    }

    public void removeListener(ChangeListener<? super ColorScheme> listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    public void addListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    public void dispose() {
    }

    protected void onInvalidating() {
    }

    public final void invalidate() {
        if (this.valid) {
            this.valid = false;
            this.onInvalidating();
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    protected abstract ColorScheme computeValue();

    public String toString() {
        return this.valid ? "ColorSchemeBinding [value: " + this.get() + "]" : "ColorSchemeBinding [invalid]";
    }
}

