/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.beans.binding;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.paint.Color;
import org.glavo.monetfx.ColorRole;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.beans.value.ObservableColorSchemeValue;
import org.jetbrains.annotations.NotNull;

public abstract class ColorSchemeExpression
implements ObservableColorSchemeValue {
    private final WeakReference<ObjectBinding<Color>>[] bindings = new WeakReference[ColorRole.ALL.size()];

    public ColorScheme getValue() {
        return (ColorScheme)this.get();
    }

    public BooleanBinding isNull() {
        return Bindings.isNull((ObservableObjectValue)this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull((ObservableObjectValue)this);
    }

    public ObjectBinding<Color> getColor(final @NotNull ColorRole role) {
        ObjectBinding binding;
        Objects.requireNonNull(role);
        WeakReference<ObjectBinding<Color>> bindingRef = this.bindings[role.ordinal()];
        if (bindingRef != null && (binding = (ObjectBinding)bindingRef.get()) != null) {
            return binding;
        }
        binding = new ObjectBinding<Color>(this){
            final /* synthetic */ ColorSchemeExpression this$0;
            {
                this.this$0 = this$0;
                this.bind(new Observable[]{this.this$0});
            }

            public void dispose() {
                this.unbind(new Observable[]{this.this$0});
            }

            protected Color computeValue() {
                ColorScheme colorScheme = (ColorScheme)this.this$0.get();
                return colorScheme != null ? colorScheme.getColor(role) : null;
            }
        };
        this.bindings[role.ordinal()] = new WeakReference<ObjectBinding>(binding);
        return binding;
    }

    public ObjectBinding<Color> getPrimary() {
        return this.getColor(ColorRole.PRIMARY);
    }

    public ObjectBinding<Color> getOnPrimary() {
        return this.getColor(ColorRole.ON_PRIMARY);
    }

    public ObjectBinding<Color> getPrimaryContainer() {
        return this.getColor(ColorRole.PRIMARY_CONTAINER);
    }

    public ObjectBinding<Color> getOnPrimaryContainer() {
        return this.getColor(ColorRole.ON_PRIMARY_CONTAINER);
    }

    public ObjectBinding<Color> getPrimaryFixed() {
        return this.getColor(ColorRole.PRIMARY_FIXED);
    }

    public ObjectBinding<Color> getPrimaryFixedDim() {
        return this.getColor(ColorRole.PRIMARY_FIXED_DIM);
    }

    public ObjectBinding<Color> getOnPrimaryFixed() {
        return this.getColor(ColorRole.ON_PRIMARY_FIXED);
    }

    public ObjectBinding<Color> getOnPrimaryFixedVariant() {
        return this.getColor(ColorRole.ON_PRIMARY_FIXED_VARIANT);
    }

    public ObjectBinding<Color> getSecondary() {
        return this.getColor(ColorRole.SECONDARY);
    }

    public ObjectBinding<Color> getOnSecondary() {
        return this.getColor(ColorRole.ON_SECONDARY);
    }

    public ObjectBinding<Color> getSecondaryContainer() {
        return this.getColor(ColorRole.SECONDARY_CONTAINER);
    }

    public ObjectBinding<Color> getOnSecondaryContainer() {
        return this.getColor(ColorRole.ON_SECONDARY_CONTAINER);
    }

    public ObjectBinding<Color> getSecondaryFixed() {
        return this.getColor(ColorRole.SECONDARY_FIXED);
    }

    public ObjectBinding<Color> getSecondaryFixedDim() {
        return this.getColor(ColorRole.SECONDARY_FIXED_DIM);
    }

    public ObjectBinding<Color> getOnSecondaryFixed() {
        return this.getColor(ColorRole.ON_SECONDARY_FIXED);
    }

    public ObjectBinding<Color> getOnSecondaryFixedVariant() {
        return this.getColor(ColorRole.ON_SECONDARY_FIXED_VARIANT);
    }

    public ObjectBinding<Color> getTertiary() {
        return this.getColor(ColorRole.TERTIARY);
    }

    public ObjectBinding<Color> getOnTertiary() {
        return this.getColor(ColorRole.ON_TERTIARY);
    }

    public ObjectBinding<Color> getTertiaryContainer() {
        return this.getColor(ColorRole.TERTIARY_CONTAINER);
    }

    public ObjectBinding<Color> getOnTertiaryContainer() {
        return this.getColor(ColorRole.ON_TERTIARY_CONTAINER);
    }

    public ObjectBinding<Color> getTertiaryFixed() {
        return this.getColor(ColorRole.TERTIARY_FIXED);
    }

    public ObjectBinding<Color> getTertiaryFixedDim() {
        return this.getColor(ColorRole.TERTIARY_FIXED_DIM);
    }

    public ObjectBinding<Color> getOnTertiaryFixed() {
        return this.getColor(ColorRole.ON_TERTIARY_FIXED);
    }

    public ObjectBinding<Color> getOnTertiaryFixedVariant() {
        return this.getColor(ColorRole.ON_TERTIARY_FIXED_VARIANT);
    }

    public ObjectBinding<Color> getError() {
        return this.getColor(ColorRole.ERROR);
    }

    public ObjectBinding<Color> getOnError() {
        return this.getColor(ColorRole.ON_ERROR);
    }

    public ObjectBinding<Color> getErrorContainer() {
        return this.getColor(ColorRole.ERROR_CONTAINER);
    }

    public ObjectBinding<Color> getOnErrorContainer() {
        return this.getColor(ColorRole.ON_ERROR_CONTAINER);
    }

    public ObjectBinding<Color> getSurface() {
        return this.getColor(ColorRole.SURFACE);
    }

    public ObjectBinding<Color> getOnSurface() {
        return this.getColor(ColorRole.ON_SURFACE);
    }

    public ObjectBinding<Color> getSurfaceDim() {
        return this.getColor(ColorRole.SURFACE_DIM);
    }

    public ObjectBinding<Color> getSurfaceBright() {
        return this.getColor(ColorRole.SURFACE_BRIGHT);
    }

    public ObjectBinding<Color> getSurfaceContainerLowest() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_LOWEST);
    }

    public ObjectBinding<Color> getSurfaceContainerLow() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_LOW);
    }

    public ObjectBinding<Color> getSurfaceContainer() {
        return this.getColor(ColorRole.SURFACE_CONTAINER);
    }

    public ObjectBinding<Color> getSurfaceContainerHigh() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_HIGH);
    }

    public ObjectBinding<Color> getSurfaceContainerHighest() {
        return this.getColor(ColorRole.SURFACE_CONTAINER_HIGHEST);
    }

    public ObjectBinding<Color> getSurfaceVariant() {
        return this.getColor(ColorRole.SURFACE_VARIANT);
    }

    public ObjectBinding<Color> getOnSurfaceVariant() {
        return this.getColor(ColorRole.ON_SURFACE_VARIANT);
    }

    public ObjectBinding<Color> getBackground() {
        return this.getColor(ColorRole.BACKGROUND);
    }

    public ObjectBinding<Color> getOnBackground() {
        return this.getColor(ColorRole.ON_BACKGROUND);
    }

    public ObjectBinding<Color> getOutline() {
        return this.getColor(ColorRole.OUTLINE);
    }

    public ObjectBinding<Color> getOutlineVariant() {
        return this.getColor(ColorRole.OUTLINE_VARIANT);
    }

    public ObjectBinding<Color> getShadow() {
        return this.getColor(ColorRole.SHADOW);
    }

    public ObjectBinding<Color> getScrim() {
        return this.getColor(ColorRole.SCRIM);
    }

    public ObjectBinding<Color> getInverseSurface() {
        return this.getColor(ColorRole.INVERSE_SURFACE);
    }

    public ObjectBinding<Color> getInverseOnSurface() {
        return this.getColor(ColorRole.INVERSE_ON_SURFACE);
    }

    public ObjectBinding<Color> getInversePrimary() {
        return this.getColor(ColorRole.INVERSE_PRIMARY);
    }

    public ObjectBinding<Color> getSurfaceTint() {
        return this.getColor(ColorRole.SURFACE_TINT);
    }

    public StringBinding toStyleSheet() {
        return new StringBinding(){
            {
                this.bind(new Observable[]{ColorSchemeExpression.this});
            }

            public void dispose() {
                this.unbind(new Observable[]{ColorSchemeExpression.this});
            }

            protected String computeValue() {
                ColorScheme scheme = (ColorScheme)ColorSchemeExpression.this.get();
                return scheme != null ? scheme.toStyleSheet() : null;
            }
        };
    }
}

