/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.dynamiccolor;

import java.util.ArrayList;
import java.util.function.Function;
import org.glavo.monetfx.internal.contrast.Contrast;
import org.glavo.monetfx.internal.dynamiccolor.ContrastCurve;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.glavo.monetfx.internal.dynamiccolor.ToneDeltaPair;
import org.glavo.monetfx.internal.dynamiccolor.TonePolarity;
import org.glavo.monetfx.internal.hct.Hct;
import org.glavo.monetfx.internal.palettes.TonalPalette;
import org.glavo.monetfx.internal.utils.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicColor {
    public final String name;
    public final Function<DynamicScheme, TonalPalette> palette;
    public final Function<DynamicScheme, Double> tone;
    public final boolean isBackground;
    public final Function<DynamicScheme, DynamicColor> background;
    public final Function<DynamicScheme, DynamicColor> secondBackground;
    public final ContrastCurve contrastCurve;
    public final Function<DynamicScheme, ToneDeltaPair> toneDeltaPair;
    public final Function<DynamicScheme, Double> opacity;

    public DynamicColor(@NotNull String name, @NotNull Function<DynamicScheme, TonalPalette> palette, @NotNull Function<DynamicScheme, Double> tone, boolean isBackground, @Nullable Function<DynamicScheme, DynamicColor> background, @Nullable Function<DynamicScheme, DynamicColor> secondBackground, @Nullable ContrastCurve contrastCurve, @Nullable Function<DynamicScheme, ToneDeltaPair> toneDeltaPair) {
        this.name = name;
        this.palette = palette;
        this.tone = tone;
        this.isBackground = isBackground;
        this.background = background;
        this.secondBackground = secondBackground;
        this.contrastCurve = contrastCurve;
        this.toneDeltaPair = toneDeltaPair;
        this.opacity = null;
    }

    public DynamicColor(@NotNull String name, @NotNull Function<DynamicScheme, TonalPalette> palette, @NotNull Function<DynamicScheme, Double> tone, boolean isBackground, @Nullable Function<DynamicScheme, DynamicColor> background, @Nullable Function<DynamicScheme, DynamicColor> secondBackground, @Nullable ContrastCurve contrastCurve, @Nullable Function<DynamicScheme, ToneDeltaPair> toneDeltaPair, @Nullable Function<DynamicScheme, Double> opacity) {
        this.name = name;
        this.palette = palette;
        this.tone = tone;
        this.isBackground = isBackground;
        this.background = background;
        this.secondBackground = secondBackground;
        this.contrastCurve = contrastCurve;
        this.toneDeltaPair = toneDeltaPair;
        this.opacity = opacity;
    }

    @NotNull
    public static DynamicColor fromPalette(@NotNull String name, @NotNull Function<DynamicScheme, TonalPalette> palette, @NotNull Function<DynamicScheme, Double> tone) {
        return new DynamicColor(name, palette, tone, false, null, null, null, null);
    }

    @NotNull
    public static DynamicColor fromPalette(@NotNull String name, @NotNull Function<DynamicScheme, TonalPalette> palette, @NotNull Function<DynamicScheme, Double> tone, boolean isBackground) {
        return new DynamicColor(name, palette, tone, isBackground, null, null, null, null);
    }

    @NotNull
    public static DynamicColor fromArgb(@NotNull String name, int argb) {
        Hct hct = Hct.fromInt(argb);
        TonalPalette palette = TonalPalette.fromInt(argb);
        return DynamicColor.fromPalette(name, s -> palette, s -> hct.getTone());
    }

    public int getArgb(@NotNull DynamicScheme scheme) {
        int argb = this.getHct(scheme).toInt();
        if (this.opacity == null) {
            return argb;
        }
        double percentage = this.opacity.apply(scheme);
        int alpha = MathUtils.clampInt(0, 255, (int)Math.round(percentage * 255.0));
        return argb & 0xFFFFFF | alpha << 24;
    }

    @NotNull
    public Hct getHct(@NotNull DynamicScheme scheme) {
        double tone = this.getTone(scheme);
        return this.palette.apply(scheme).getHct(tone);
    }

    public double getTone(@NotNull DynamicScheme scheme) {
        boolean decreasingContrast;
        boolean bl = decreasingContrast = scheme.contrastLevel < 0.0;
        if (this.toneDeltaPair != null) {
            double fTone;
            ToneDeltaPair toneDeltaPair = this.toneDeltaPair.apply(scheme);
            DynamicColor roleA = toneDeltaPair.getRoleA();
            DynamicColor roleB = toneDeltaPair.getRoleB();
            double delta = toneDeltaPair.getDelta();
            TonePolarity polarity = toneDeltaPair.getPolarity();
            boolean stayTogether = toneDeltaPair.getStayTogether();
            DynamicColor bg = this.background.apply(scheme);
            double bgTone = bg.getTone(scheme);
            boolean aIsNearer = polarity == TonePolarity.NEARER || polarity == TonePolarity.LIGHTER && !scheme.isDark || polarity == TonePolarity.DARKER && scheme.isDark;
            DynamicColor nearer = aIsNearer ? roleA : roleB;
            DynamicColor farther = aIsNearer ? roleB : roleA;
            boolean amNearer = this.name.equals(nearer.name);
            double expansionDir = scheme.isDark ? 1.0 : -1.0;
            double nContrast = nearer.contrastCurve.get(scheme.contrastLevel);
            double fContrast = farther.contrastCurve.get(scheme.contrastLevel);
            double nInitialTone = nearer.tone.apply(scheme);
            double nTone = Contrast.ratioOfTones(bgTone, nInitialTone) >= nContrast ? nInitialTone : DynamicColor.foregroundTone(bgTone, nContrast);
            double fInitialTone = farther.tone.apply(scheme);
            double d = fTone = Contrast.ratioOfTones(bgTone, fInitialTone) >= fContrast ? fInitialTone : DynamicColor.foregroundTone(bgTone, fContrast);
            if (decreasingContrast) {
                nTone = DynamicColor.foregroundTone(bgTone, nContrast);
                fTone = DynamicColor.foregroundTone(bgTone, fContrast);
            }
            if ((fTone - nTone) * expansionDir < delta && ((fTone = MathUtils.clampDouble(0.0, 100.0, nTone + delta * expansionDir)) - nTone) * expansionDir < delta) {
                nTone = MathUtils.clampDouble(0.0, 100.0, fTone - delta * expansionDir);
            }
            if (50.0 <= nTone && nTone < 60.0) {
                if (expansionDir > 0.0) {
                    nTone = 60.0;
                    fTone = Math.max(fTone, nTone + delta * expansionDir);
                } else {
                    nTone = 49.0;
                    fTone = Math.min(fTone, nTone + delta * expansionDir);
                }
            } else if (50.0 <= fTone && fTone < 60.0) {
                if (stayTogether) {
                    if (expansionDir > 0.0) {
                        nTone = 60.0;
                        fTone = Math.max(fTone, nTone + delta * expansionDir);
                    } else {
                        nTone = 49.0;
                        fTone = Math.min(fTone, nTone + delta * expansionDir);
                    }
                } else {
                    fTone = expansionDir > 0.0 ? 60.0 : 49.0;
                }
            }
            return amNearer ? nTone : fTone;
        }
        double answer = this.tone.apply(scheme);
        if (this.background == null) {
            return answer;
        }
        double bgTone = this.background.apply(scheme).getTone(scheme);
        double desiredRatio = this.contrastCurve.get(scheme.contrastLevel);
        if (!(Contrast.ratioOfTones(bgTone, answer) >= desiredRatio)) {
            answer = DynamicColor.foregroundTone(bgTone, desiredRatio);
        }
        if (decreasingContrast) {
            answer = DynamicColor.foregroundTone(bgTone, desiredRatio);
        }
        if (this.isBackground && 50.0 <= answer && answer < 60.0) {
            answer = Contrast.ratioOfTones(49.0, bgTone) >= desiredRatio ? 49.0 : 60.0;
        }
        if (this.secondBackground != null) {
            boolean prefersLight;
            double bgTone1 = this.background.apply(scheme).getTone(scheme);
            double bgTone2 = this.secondBackground.apply(scheme).getTone(scheme);
            double upper = Math.max(bgTone1, bgTone2);
            double lower = Math.min(bgTone1, bgTone2);
            if (Contrast.ratioOfTones(upper, answer) >= desiredRatio && Contrast.ratioOfTones(lower, answer) >= desiredRatio) {
                return answer;
            }
            double lightOption = Contrast.lighter(upper, desiredRatio);
            double darkOption = Contrast.darker(lower, desiredRatio);
            ArrayList<Double> availables = new ArrayList<Double>();
            if (lightOption != -1.0) {
                availables.add(lightOption);
            }
            if (darkOption != -1.0) {
                availables.add(darkOption);
            }
            boolean bl2 = prefersLight = DynamicColor.tonePrefersLightForeground(bgTone1) || DynamicColor.tonePrefersLightForeground(bgTone2);
            if (prefersLight) {
                return lightOption == -1.0 ? 100.0 : lightOption;
            }
            if (availables.size() == 1) {
                return (Double)availables.get(0);
            }
            return darkOption == -1.0 ? 0.0 : darkOption;
        }
        return answer;
    }

    public static double foregroundTone(double bgTone, double ratio) {
        double lighterTone = Contrast.lighterUnsafe(bgTone, ratio);
        double darkerTone = Contrast.darkerUnsafe(bgTone, ratio);
        double lighterRatio = Contrast.ratioOfTones(lighterTone, bgTone);
        double darkerRatio = Contrast.ratioOfTones(darkerTone, bgTone);
        boolean preferLighter = DynamicColor.tonePrefersLightForeground(bgTone);
        if (preferLighter) {
            boolean negligibleDifference;
            boolean bl = negligibleDifference = Math.abs(lighterRatio - darkerRatio) < 0.1 && lighterRatio < ratio && darkerRatio < ratio;
            if (lighterRatio >= ratio || lighterRatio >= darkerRatio || negligibleDifference) {
                return lighterTone;
            }
            return darkerTone;
        }
        return darkerRatio >= ratio || darkerRatio >= lighterRatio ? darkerTone : lighterTone;
    }

    public static double enableLightForeground(double tone) {
        if (DynamicColor.tonePrefersLightForeground(tone) && !DynamicColor.toneAllowsLightForeground(tone)) {
            return 49.0;
        }
        return tone;
    }

    public static boolean tonePrefersLightForeground(double tone) {
        return Math.round(tone) < 60L;
    }

    public static boolean toneAllowsLightForeground(double tone) {
        return Math.round(tone) <= 49L;
    }
}

