/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.hct;

import javafx.scene.paint.Color;
import org.glavo.monetfx.internal.hct.Cam16;
import org.glavo.monetfx.internal.hct.HctSolver;
import org.glavo.monetfx.internal.hct.ViewingConditions;
import org.glavo.monetfx.internal.utils.ColorUtils;

public final class Hct {
    private final double hue;
    private final double chroma;
    private final double tone;
    private final int argb;

    public static Hct from(double hue, double chroma, double tone) {
        int argb = HctSolver.solveToInt(hue, chroma, tone);
        return new Hct(argb);
    }

    public static Hct fromInt(int argb) {
        return new Hct(argb);
    }

    public static Hct fromFx(Color color) {
        return Hct.fromInt(ColorUtils.argbFromFx(color));
    }

    private Hct(int argb) {
        this.argb = argb;
        Cam16 cam = Cam16.fromInt(argb);
        this.hue = cam.getHue();
        this.chroma = cam.getChroma();
        this.tone = ColorUtils.lstarFromArgb(argb);
    }

    public double getHue() {
        return this.hue;
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getTone() {
        return this.tone;
    }

    public int toInt() {
        return this.argb;
    }

    public Hct inViewingConditions(ViewingConditions vc) {
        Cam16 cam16 = Cam16.fromInt(this.toInt());
        double[] viewedInVc = cam16.xyzInViewingConditions(vc, null);
        Cam16 recastInVc = Cam16.fromXyzInViewingConditions(viewedInVc[0], viewedInVc[1], viewedInVc[2], ViewingConditions.DEFAULT);
        return Hct.from(recastInVc.getHue(), recastInVc.getChroma(), ColorUtils.lstarFromY(viewedInVc[1]));
    }

    public String toString() {
        return "Hct{hue=" + this.hue + ", chroma=" + this.chroma + ", tone=" + this.tone + ", argb=" + Integer.toHexString(this.argb) + '}';
    }
}

