/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.UnicodeBOMInputStream;
import org.glavo.chardet.UniversalDetector;

public final class ReaderFactory {
    private ReaderFactory() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static BufferedReader createBufferedReader(Path file, Charset defaultCharset) throws IOException {
        Charset cs = Objects.requireNonNull(defaultCharset, "defaultCharset must be not null");
        DetectedCharset detectedEncoding = UniversalDetector.detectCharset(file);
        if (detectedEncoding != null) {
            cs = detectedEncoding.getCharset();
        }
        if (!cs.name().contains("UTF")) {
            return Files.newBufferedReader(file, cs);
        }
        return new BufferedReader(new InputStreamReader((InputStream)new UnicodeBOMInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]))), cs));
    }

    public static BufferedReader createBufferedReader(Path file) throws IOException {
        return ReaderFactory.createBufferedReader(file, StandardCharsets.UTF_8);
    }

    public static BufferedReader createBufferedReader(byte[] data, Charset defaultCharset) throws IOException {
        DetectedCharset detectedEncoding;
        Charset cs = Objects.requireNonNull(defaultCharset, "defaultCharset must be not null");
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            detectedEncoding = UniversalDetector.detectCharset(is);
        }
        if (detectedEncoding != null) {
            cs = detectedEncoding.getCharset();
        }
        if (!cs.name().contains("UTF")) {
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), cs));
        }
        return new BufferedReader(new InputStreamReader(new UnicodeBOMInputStream(new ByteArrayInputStream(data))));
    }

    public static BufferedReader createBufferedReader(byte[] data) throws IOException {
        return ReaderFactory.createBufferedReader(data, StandardCharsets.UTF_8);
    }
}

