/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.List;
import java.util.Objects;
import org.glavo.classfile.Signature;
import org.glavo.classfile.impl.SignaturesImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassSignature {
    public List<Signature.TypeParam> typeParameters();

    public Signature.RefTypeSig superclassSignature();

    public List<Signature.RefTypeSig> superinterfaceSignatures();

    public String signatureString();

    public static ClassSignature of(Signature.RefTypeSig superclassSignature, Signature.RefTypeSig ... superinterfaceSignatures) {
        return ClassSignature.of(List.of(), superclassSignature, superinterfaceSignatures);
    }

    public static ClassSignature of(List<Signature.TypeParam> typeParameters, Signature.RefTypeSig superclassSignature, Signature.RefTypeSig ... superinterfaceSignatures) {
        return new SignaturesImpl.ClassSignatureImpl(Objects.requireNonNull(typeParameters), Objects.requireNonNull(superclassSignature), List.of(superinterfaceSignatures));
    }

    public static ClassSignature parseFrom(String classSignature) {
        return new SignaturesImpl().parseClassSignature(Objects.requireNonNull(classSignature));
    }
}

