/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.util.Optional;
import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodParameterInfo {
    public Optional<Utf8Entry> name();

    public int flagsMask();

    default public Set<AccessFlag> flags() {
        return AccessFlag.maskToAccessFlags(this.flagsMask(), AccessFlag.Location.METHOD_PARAMETER);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.METHOD_PARAMETER, this.flagsMask(), flag);
    }

    public static MethodParameterInfo of(Optional<Utf8Entry> name, int flags) {
        return new UnboundAttribute.UnboundMethodParameterInfo(name, flags);
    }

    public static MethodParameterInfo of(Optional<String> name, AccessFlag ... flags) {
        return MethodParameterInfo.of(name.map(TemporaryConstantPool.INSTANCE::utf8Entry), Util.flagsToBits(AccessFlag.Location.METHOD_PARAMETER, flags));
    }

    public static MethodParameterInfo ofParameter(Optional<String> name, int flags) {
        return MethodParameterInfo.of(name.map(TemporaryConstantPool.INSTANCE::utf8Entry), flags);
    }
}

