/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ClassDesc;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.attribute.ModuleExportInfo;
import org.glavo.classfile.attribute.ModuleOpenInfo;
import org.glavo.classfile.attribute.ModuleProvideInfo;
import org.glavo.classfile.attribute.ModuleRequireInfo;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.ModuleAttributeBuilderImpl;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.java.lang.constant.ModuleDesc;
import org.glavo.classfile.java.lang.constant.PackageDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleAttribute
extends Attribute<ModuleAttribute>,
ClassElement {
    public ModuleEntry moduleName();

    public int moduleFlagsMask();

    default public Set<AccessFlag> moduleFlags() {
        return AccessFlag.maskToAccessFlags(this.moduleFlagsMask(), AccessFlag.Location.MODULE);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE, this.moduleFlagsMask(), flag);
    }

    public Optional<Utf8Entry> moduleVersion();

    public List<ModuleRequireInfo> requires();

    public List<ModuleExportInfo> exports();

    public List<ModuleOpenInfo> opens();

    public List<ClassEntry> uses();

    public List<ModuleProvideInfo> provides();

    public static ModuleAttribute of(ModuleEntry moduleName, int moduleFlags, Utf8Entry moduleVersion, Collection<ModuleRequireInfo> requires, Collection<ModuleExportInfo> exports, Collection<ModuleOpenInfo> opens, Collection<ClassEntry> uses, Collection<ModuleProvideInfo> provides) {
        return new UnboundAttribute.UnboundModuleAttribute(moduleName, moduleFlags, moduleVersion, requires, exports, opens, uses, provides);
    }

    public static ModuleAttribute of(ModuleDesc moduleName, Consumer<ModuleAttributeBuilder> attrHandler) {
        ModuleAttributeBuilderImpl mb = new ModuleAttributeBuilderImpl(moduleName);
        attrHandler.accept(mb);
        return mb.build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ModuleAttributeBuilder {
        public ModuleAttributeBuilder moduleName(ModuleDesc var1);

        public ModuleAttributeBuilder moduleFlags(int var1);

        default public ModuleAttributeBuilder moduleFlags(AccessFlag ... moduleFlags) {
            return this.moduleFlags(Util.flagsToBits(AccessFlag.Location.MODULE, moduleFlags));
        }

        public ModuleAttributeBuilder moduleVersion(String var1);

        public ModuleAttributeBuilder requires(ModuleDesc var1, int var2, String var3);

        default public ModuleAttributeBuilder requires(ModuleDesc module, Collection<AccessFlag> requiresFlags, String version) {
            return this.requires(module, Util.flagsToBits(AccessFlag.Location.MODULE_REQUIRES, requiresFlags), version);
        }

        public ModuleAttributeBuilder requires(ModuleRequireInfo var1);

        public ModuleAttributeBuilder exports(PackageDesc var1, int var2, ModuleDesc ... var3);

        default public ModuleAttributeBuilder exports(PackageDesc pkge, Collection<AccessFlag> exportsFlags, ModuleDesc ... exportsToModules) {
            return this.exports(pkge, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportsFlags), exportsToModules);
        }

        public ModuleAttributeBuilder exports(ModuleExportInfo var1);

        public ModuleAttributeBuilder opens(PackageDesc var1, int var2, ModuleDesc ... var3);

        default public ModuleAttributeBuilder opens(PackageDesc pkge, Collection<AccessFlag> opensFlags, ModuleDesc ... opensToModules) {
            return this.opens(pkge, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensToModules);
        }

        public ModuleAttributeBuilder opens(ModuleOpenInfo var1);

        public ModuleAttributeBuilder uses(ClassDesc var1);

        public ModuleAttributeBuilder uses(ClassEntry var1);

        public ModuleAttributeBuilder provides(ClassDesc var1, ClassDesc ... var2);

        public ModuleAttributeBuilder provides(ModuleProvideInfo var1);

        public ModuleAttribute build();
    }
}

