/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.java.lang.constant.ModuleDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleRequireInfo {
    public ModuleEntry requires();

    public int requiresFlagsMask();

    default public Set<AccessFlag> requiresFlags() {
        return AccessFlag.maskToAccessFlags(this.requiresFlagsMask(), AccessFlag.Location.MODULE_REQUIRES);
    }

    public Optional<Utf8Entry> requiresVersion();

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE_REQUIRES, this.requiresFlagsMask(), flag);
    }

    public static ModuleRequireInfo of(ModuleEntry requires, int requiresFlags, Utf8Entry requiresVersion) {
        return new UnboundAttribute.UnboundModuleRequiresInfo(requires, requiresFlags, Optional.ofNullable(requiresVersion));
    }

    public static ModuleRequireInfo of(ModuleEntry requires, Collection<AccessFlag> requiresFlags, Utf8Entry requiresVersion) {
        return ModuleRequireInfo.of(requires, Util.flagsToBits(AccessFlag.Location.MODULE_REQUIRES, requiresFlags), requiresVersion);
    }

    public static ModuleRequireInfo of(ModuleDesc requires, int requiresFlags, String requiresVersion) {
        return new UnboundAttribute.UnboundModuleRequiresInfo(TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(requires.moduleName())), requiresFlags, Optional.ofNullable(requiresVersion).map(s -> TemporaryConstantPool.INSTANCE.utf8Entry((String)s)));
    }

    public static ModuleRequireInfo of(ModuleDesc requires, Collection<AccessFlag> requiresFlags, String requiresVersion) {
        return ModuleRequireInfo.of(requires, Util.flagsToBits(AccessFlag.Location.MODULE_REQUIRES, requiresFlags), requiresVersion);
    }
}

