/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.impl.AbstractPoolEntry;

public final class BootstrapMethodEntryImpl
implements BootstrapMethodEntry {
    final int index;
    final int hash;
    private final ConstantPool constantPool;
    private final AbstractPoolEntry.MethodHandleEntryImpl handle;
    private final List<LoadableConstantEntry> arguments;

    BootstrapMethodEntryImpl(ConstantPool constantPool, int bsmIndex, int hash, AbstractPoolEntry.MethodHandleEntryImpl handle, List<LoadableConstantEntry> arguments) {
        this.index = bsmIndex;
        this.hash = hash;
        this.constantPool = constantPool;
        this.handle = handle;
        this.arguments = List.copyOf(arguments);
    }

    @Override
    public ConstantPool constantPool() {
        return this.constantPool;
    }

    @Override
    public MethodHandleEntry bootstrapMethod() {
        return this.handle;
    }

    @Override
    public List<LoadableConstantEntry> arguments() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        BootstrapMethodEntry e;
        return obj instanceof BootstrapMethodEntry && (e = (BootstrapMethodEntry)obj).bootstrapMethod().equals(this.handle) && e.arguments().equals(this.arguments);
    }

    static int computeHashCode(AbstractPoolEntry.MethodHandleEntryImpl handle, List<? extends LoadableConstantEntry> arguments) {
        int hash = handle.hashCode();
        hash = 31 * hash + arguments.hashCode();
        return AbstractPoolEntry.phiMix(hash);
    }

    @Override
    public int bsmIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public void writeTo(BufWriter writer) {
        writer.writeIndex(this.bootstrapMethod());
        writer.writeListIndices(this.arguments());
    }
}

