/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.AttributedElement;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.TypeAnnotation;
import org.glavo.classfile.attribute.AnnotationDefaultAttribute;
import org.glavo.classfile.attribute.BootstrapMethodsAttribute;
import org.glavo.classfile.attribute.CharacterRangeInfo;
import org.glavo.classfile.attribute.CharacterRangeTableAttribute;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.attribute.CompilationIDAttribute;
import org.glavo.classfile.attribute.ConstantValueAttribute;
import org.glavo.classfile.attribute.DeprecatedAttribute;
import org.glavo.classfile.attribute.EnclosingMethodAttribute;
import org.glavo.classfile.attribute.ExceptionsAttribute;
import org.glavo.classfile.attribute.InnerClassInfo;
import org.glavo.classfile.attribute.InnerClassesAttribute;
import org.glavo.classfile.attribute.LineNumberInfo;
import org.glavo.classfile.attribute.LineNumberTableAttribute;
import org.glavo.classfile.attribute.LocalVariableInfo;
import org.glavo.classfile.attribute.LocalVariableTableAttribute;
import org.glavo.classfile.attribute.LocalVariableTypeInfo;
import org.glavo.classfile.attribute.LocalVariableTypeTableAttribute;
import org.glavo.classfile.attribute.MethodParameterInfo;
import org.glavo.classfile.attribute.MethodParametersAttribute;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.attribute.ModuleExportInfo;
import org.glavo.classfile.attribute.ModuleHashInfo;
import org.glavo.classfile.attribute.ModuleHashesAttribute;
import org.glavo.classfile.attribute.ModuleMainClassAttribute;
import org.glavo.classfile.attribute.ModuleOpenInfo;
import org.glavo.classfile.attribute.ModulePackagesAttribute;
import org.glavo.classfile.attribute.ModuleProvideInfo;
import org.glavo.classfile.attribute.ModuleRequireInfo;
import org.glavo.classfile.attribute.ModuleResolutionAttribute;
import org.glavo.classfile.attribute.ModuleTargetAttribute;
import org.glavo.classfile.attribute.NestHostAttribute;
import org.glavo.classfile.attribute.NestMembersAttribute;
import org.glavo.classfile.attribute.PermittedSubclassesAttribute;
import org.glavo.classfile.attribute.RecordAttribute;
import org.glavo.classfile.attribute.RecordComponentInfo;
import org.glavo.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.SignatureAttribute;
import org.glavo.classfile.attribute.SourceDebugExtensionAttribute;
import org.glavo.classfile.attribute.SourceFileAttribute;
import org.glavo.classfile.attribute.SourceIDAttribute;
import org.glavo.classfile.attribute.StackMapFrameInfo;
import org.glavo.classfile.attribute.StackMapTableAttribute;
import org.glavo.classfile.attribute.SyntheticAttribute;
import org.glavo.classfile.attribute.UnknownAttribute;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantValueEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.AnnotationReader;
import org.glavo.classfile.impl.BootstrapMethodEntryImpl;
import org.glavo.classfile.impl.BoundLocalVariable;
import org.glavo.classfile.impl.BoundLocalVariableType;
import org.glavo.classfile.impl.BoundRecordComponentInfo;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.DirectFieldBuilder;
import org.glavo.classfile.impl.DirectMethodBuilder;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.StackMapDecoder;
import org.glavo.classfile.jdk.CollectionUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BoundAttribute<T extends Attribute<T>>
extends AbstractElement
implements Attribute<T> {
    static final int NAME_AND_LENGTH_PREFIX = 6;
    private final AttributeMapper<T> mapper;
    final ClassReader classReader;
    final int payloadStart;

    BoundAttribute(ClassReader classReader, AttributeMapper<T> mapper, int payloadStart) {
        this.mapper = mapper;
        this.classReader = classReader;
        this.payloadStart = payloadStart;
    }

    public int payloadLen() {
        return this.classReader.readInt(this.payloadStart - 4);
    }

    @Override
    public String attributeName() {
        return this.mapper.name();
    }

    @Override
    public AttributeMapper<T> attributeMapper() {
        return this.mapper;
    }

    public byte[] contents() {
        return this.classReader.readBytes(this.payloadStart, this.payloadLen());
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectCodeBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectMethodBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectFieldBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(BufWriter buf) {
        if (!buf.canWriteDirect(this.classReader)) {
            this.attributeMapper().writeAttribute(buf, this);
        } else {
            this.classReader.copyBytesTo(buf, this.payloadStart - 6, this.payloadLen() + 6);
        }
    }

    public ConstantPool constantPool() {
        return this.classReader;
    }

    public String toString() {
        return String.format("Attribute[name=%s]", this.mapper.name());
    }

    <E> List<E> readEntryList(int p) {
        int cnt = this.classReader.readU2(p);
        Object[] entries = new Object[cnt];
        int end = (p += 2) + cnt * 2;
        int i = 0;
        while (p < end) {
            entries[i] = this.classReader.readEntry(p);
            ++i;
            p += 2;
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(entries);
    }

    public static List<Attribute<?>> readAttributes(AttributedElement enclosing, ClassReader reader, int pos, Function<Utf8Entry, AttributeMapper<?>> customAttributes) {
        int size = reader.readU2(pos);
        Object[] filled = new Object[size];
        int p = pos + 2;
        for (int i = 0; i < size; ++i) {
            final Utf8Entry name = reader.readUtf8Entry(p);
            int len = reader.readInt(p + 2);
            p += 6;
            AttributeMapper<?> mapper = Attributes.standardAttribute(name);
            if (mapper == null) {
                mapper = customAttributes.apply(name);
            }
            if (mapper != null) {
                filled[i] = mapper.readAttribute(enclosing, reader, p);
            } else if (((ClassReaderImpl)reader).options().processUnknownAttributes.booleanValue()) {
                AttributeMapper<UnknownAttribute> fakeMapper = new AttributeMapper<UnknownAttribute>(){

                    @Override
                    public String name() {
                        return name.stringValue();
                    }

                    @Override
                    public UnknownAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void writeAttribute(BufWriter buf, UnknownAttribute attr) {
                        throw new UnsupportedOperationException("Write of unknown attribute " + this.name() + " not supported");
                    }

                    @Override
                    public boolean allowMultiple() {
                        return true;
                    }
                };
                filled[i] = new BoundUnknownAttribute(reader, fakeMapper, p);
            }
            p += len;
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(filled);
    }

    public static final class BoundUnknownAttribute
    extends BoundAttribute<UnknownAttribute>
    implements UnknownAttribute {
        public BoundUnknownAttribute(ClassReader cf, AttributeMapper<UnknownAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public void writeTo(DirectClassBuilder builder) {
            this.checkWriteSupported(builder::canWriteDirect);
            super.writeTo(builder);
        }

        @Override
        public void writeTo(DirectMethodBuilder builder) {
            this.checkWriteSupported(builder::canWriteDirect);
            super.writeTo(builder);
        }

        @Override
        public void writeTo(DirectFieldBuilder builder) {
            this.checkWriteSupported(builder::canWriteDirect);
            super.writeTo(builder);
        }

        @Override
        public void writeTo(BufWriter buf) {
            this.checkWriteSupported(buf::canWriteDirect);
            super.writeTo(buf);
        }

        private void checkWriteSupported(Function<ConstantPool, Boolean> condition) {
            if (!condition.apply(this.classReader).booleanValue()) {
                throw new UnsupportedOperationException("Write of unknown attribute " + this.attributeName() + " not supported to alien constant pool");
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class BoundCodeAttribute
    extends BoundAttribute<CodeAttribute>
    implements CodeAttribute {
        protected final int codeStart;
        protected final int codeLength;
        protected final int codeEnd;
        protected final int attributePos;
        protected final int exceptionHandlerPos;
        protected final int exceptionHandlerCnt;
        protected final MethodModel enclosingMethod;

        public BoundCodeAttribute(AttributedElement enclosing, ClassReader reader, AttributeMapper<CodeAttribute> mapper, int payloadStart) {
            super(reader, mapper, payloadStart);
            this.codeLength = this.classReader.readInt(payloadStart + 4);
            this.enclosingMethod = (MethodModel)enclosing;
            this.codeStart = payloadStart + 8;
            this.exceptionHandlerPos = this.codeEnd = this.codeStart + this.codeLength;
            this.exceptionHandlerCnt = this.classReader.readU2(this.exceptionHandlerPos);
            this.attributePos = this.exceptionHandlerPos + 2 + this.exceptionHandlerCnt * 8;
        }

        @Override
        public int maxStack() {
            return this.classReader.readU2(this.payloadStart);
        }

        @Override
        public int maxLocals() {
            return this.classReader.readU2(this.payloadStart + 2);
        }

        @Override
        public int codeLength() {
            return this.codeLength;
        }

        @Override
        public byte[] codeArray() {
            return this.classReader.readBytes(this.payloadStart + 8, this.codeLength());
        }
    }

    public static final class BoundPermittedSubclassesAttribute
    extends BoundAttribute<PermittedSubclassesAttribute>
    implements PermittedSubclassesAttribute {
        private List<ClassEntry> permittedSubclasses = null;

        public BoundPermittedSubclassesAttribute(ClassReader cf, AttributeMapper<PermittedSubclassesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> permittedSubclasses() {
            if (this.permittedSubclasses == null) {
                this.permittedSubclasses = this.readEntryList(this.payloadStart);
            }
            return this.permittedSubclasses;
        }
    }

    public static final class BoundRuntimeVisibleAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleAnnotationsAttribute>
    implements RuntimeVisibleAnnotationsAttribute {
        private List<Annotation> inflated;

        public BoundRuntimeVisibleAnnotationsAttribute(ClassReader cf, int payloadStart) {
            super(cf, Attributes.RUNTIME_VISIBLE_ANNOTATIONS, payloadStart);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.inflated == null) {
                this.inflated = AnnotationReader.readAnnotations(this.classReader, this.payloadStart);
            }
            return this.inflated;
        }
    }

    public static final class BoundRuntimeInvisibleAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleAnnotationsAttribute>
    implements RuntimeInvisibleAnnotationsAttribute {
        private List<Annotation> inflated;

        public BoundRuntimeInvisibleAnnotationsAttribute(ClassReader cf, int payloadStart) {
            super(cf, Attributes.RUNTIME_INVISIBLE_ANNOTATIONS, payloadStart);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.inflated == null) {
                this.inflated = AnnotationReader.readAnnotations(this.classReader, this.payloadStart);
            }
            return this.inflated;
        }
    }

    public static final class BoundRuntimeInvisibleParameterAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleParameterAnnotationsAttribute>
    implements RuntimeInvisibleParameterAnnotationsAttribute {
        public BoundRuntimeInvisibleParameterAnnotationsAttribute(ClassReader cf, AttributeMapper<RuntimeInvisibleParameterAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return AnnotationReader.readParameterAnnotations(this.classReader, this.payloadStart);
        }
    }

    public static final class BoundRuntimeVisibleParameterAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleParameterAnnotationsAttribute>
    implements RuntimeVisibleParameterAnnotationsAttribute {
        public BoundRuntimeVisibleParameterAnnotationsAttribute(ClassReader cf, AttributeMapper<RuntimeVisibleParameterAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return AnnotationReader.readParameterAnnotations(this.classReader, this.payloadStart);
        }
    }

    public static final class BoundRuntimeInvisibleTypeAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleTypeAnnotationsAttribute>
    implements RuntimeInvisibleTypeAnnotationsAttribute {
        private final LabelContext labelContext;

        public BoundRuntimeInvisibleTypeAnnotationsAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<RuntimeInvisibleTypeAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            LabelContext lc;
            this.labelContext = enclosing instanceof LabelContext ? (lc = (LabelContext)((Object)enclosing)) : null;
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return AnnotationReader.readTypeAnnotations(this.classReader, this.payloadStart, this.labelContext);
        }
    }

    public static final class BoundRuntimeVisibleTypeAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleTypeAnnotationsAttribute>
    implements RuntimeVisibleTypeAnnotationsAttribute {
        private final LabelContext labelContext;

        public BoundRuntimeVisibleTypeAnnotationsAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<RuntimeVisibleTypeAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            LabelContext lc;
            this.labelContext = enclosing instanceof LabelContext ? (lc = (LabelContext)((Object)enclosing)) : null;
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return AnnotationReader.readTypeAnnotations(this.classReader, this.payloadStart, this.labelContext);
        }
    }

    public static final class BoundAnnotationDefaultAttr
    extends BoundAttribute<AnnotationDefaultAttribute>
    implements AnnotationDefaultAttribute {
        private AnnotationValue annotationValue;

        public BoundAnnotationDefaultAttr(ClassReader cf, AttributeMapper<AnnotationDefaultAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public AnnotationValue defaultValue() {
            if (this.annotationValue == null) {
                this.annotationValue = AnnotationReader.readElementValue(this.classReader, this.payloadStart);
            }
            return this.annotationValue;
        }
    }

    public static final class BoundEnclosingMethodAttribute
    extends BoundAttribute<EnclosingMethodAttribute>
    implements EnclosingMethodAttribute {
        public BoundEnclosingMethodAttribute(ClassReader cf, AttributeMapper<EnclosingMethodAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry enclosingClass() {
            return this.classReader.readClassEntry(this.payloadStart);
        }

        @Override
        public Optional<NameAndTypeEntry> enclosingMethod() {
            return Optional.ofNullable((NameAndTypeEntry)this.classReader.readEntryOrNull(this.payloadStart + 2));
        }
    }

    public static final class BoundInnerClassesAttribute
    extends BoundAttribute<InnerClassesAttribute>
    implements InnerClassesAttribute {
        private List<InnerClassInfo> classes;

        public BoundInnerClassesAttribute(ClassReader cf, AttributeMapper<InnerClassesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<InnerClassInfo> classes() {
            if (this.classes == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                int p = this.payloadStart + 2;
                InnerClassInfo[] elements = new InnerClassInfo[cnt];
                for (int i = 0; i < cnt; ++i) {
                    ClassEntry innerClass = this.classReader.readClassEntry(p);
                    int outerClassIndex = this.classReader.readU2(p + 2);
                    ClassEntry outerClass = outerClassIndex == 0 ? null : (ClassEntry)this.classReader.entryByIndex(outerClassIndex);
                    int innerNameIndex = this.classReader.readU2(p + 4);
                    Utf8Entry innerName = innerNameIndex == 0 ? null : (Utf8Entry)this.classReader.entryByIndex(innerNameIndex);
                    int flags = this.classReader.readU2(p + 6);
                    p += 8;
                    elements[i] = InnerClassInfo.of(innerClass, Optional.ofNullable(outerClass), Optional.ofNullable(innerName), flags);
                }
                this.classes = List.of(elements);
            }
            return this.classes;
        }
    }

    public static final class BoundBootstrapMethodsAttribute
    extends BoundAttribute<BootstrapMethodsAttribute>
    implements BootstrapMethodsAttribute {
        private List<BootstrapMethodEntry> bootstraps = null;
        private final int size;

        public BoundBootstrapMethodsAttribute(ClassReader reader, AttributeMapper<BootstrapMethodsAttribute> mapper, int pos) {
            super(reader, mapper, pos);
            this.size = this.classReader.readU2(pos);
        }

        @Override
        public int bootstrapMethodsSize() {
            return this.size;
        }

        @Override
        public List<BootstrapMethodEntry> bootstrapMethods() {
            if (this.bootstraps == null) {
                BootstrapMethodEntry[] bs = new BootstrapMethodEntry[this.size];
                int p = this.payloadStart + 2;
                for (int i = 0; i < this.size; ++i) {
                    AbstractPoolEntry.MethodHandleEntryImpl handle = (AbstractPoolEntry.MethodHandleEntryImpl)this.classReader.readMethodHandleEntry(p);
                    List<LoadableConstantEntry> args = this.readEntryList(p + 2);
                    p += 4 + args.size() * 2;
                    int hash = BootstrapMethodEntryImpl.computeHashCode(handle, args);
                    bs[i] = new BootstrapMethodEntryImpl(this.classReader, i, hash, handle, args);
                }
                this.bootstraps = List.of(bs);
            }
            return this.bootstraps;
        }
    }

    public static final class BoundNestMembersAttribute
    extends BoundAttribute<NestMembersAttribute>
    implements NestMembersAttribute {
        private List<ClassEntry> members = null;

        public BoundNestMembersAttribute(ClassReader cf, AttributeMapper<NestMembersAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> nestMembers() {
            if (this.members == null) {
                this.members = this.readEntryList(this.payloadStart);
            }
            return this.members;
        }
    }

    public static final class BoundModulePackagesAttribute
    extends BoundAttribute<ModulePackagesAttribute>
    implements ModulePackagesAttribute {
        private List<PackageEntry> packages = null;

        public BoundModulePackagesAttribute(ClassReader cf, AttributeMapper<ModulePackagesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<PackageEntry> packages() {
            if (this.packages == null) {
                this.packages = this.readEntryList(this.payloadStart);
            }
            return this.packages;
        }
    }

    public static final class BoundModuleAttribute
    extends BoundAttribute<ModuleAttribute>
    implements ModuleAttribute {
        private List<ModuleRequireInfo> requires = null;
        private List<ModuleExportInfo> exports = null;
        private List<ModuleOpenInfo> opens = null;
        private List<ClassEntry> uses = null;
        private List<ModuleProvideInfo> provides = null;

        public BoundModuleAttribute(ClassReader cf, AttributeMapper<ModuleAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ModuleEntry moduleName() {
            return this.classReader.readModuleEntry(this.payloadStart);
        }

        @Override
        public int moduleFlagsMask() {
            return this.classReader.readU2(this.payloadStart + 2);
        }

        @Override
        public Optional<Utf8Entry> moduleVersion() {
            return Optional.ofNullable(this.classReader.readUtf8EntryOrNull(this.payloadStart + 4));
        }

        @Override
        public List<ModuleRequireInfo> requires() {
            if (this.requires == null) {
                this.structure();
            }
            return this.requires;
        }

        @Override
        public List<ModuleExportInfo> exports() {
            if (this.exports == null) {
                this.structure();
            }
            return this.exports;
        }

        @Override
        public List<ModuleOpenInfo> opens() {
            if (this.opens == null) {
                this.structure();
            }
            return this.opens;
        }

        @Override
        public List<ClassEntry> uses() {
            if (this.uses == null) {
                this.structure();
            }
            return this.uses;
        }

        @Override
        public List<ModuleProvideInfo> provides() {
            if (this.provides == null) {
                this.structure();
            }
            return this.provides;
        }

        private void structure() {
            int i;
            int p = this.payloadStart + 8;
            int cnt = this.classReader.readU2(this.payloadStart + 6);
            Object[] elements = new ModuleRequireInfo[cnt];
            int end = p + cnt * 6;
            int i2 = 0;
            while (p < end) {
                elements[i2] = ModuleRequireInfo.of(this.classReader.readModuleEntry(p), this.classReader.readU2(p + 2), (Utf8Entry)this.classReader.readEntryOrNull(p + 4));
                p += 6;
                ++i2;
            }
            this.requires = List.of(elements);
            cnt = this.classReader.readU2(p);
            p += 2;
            elements = new ModuleExportInfo[cnt];
            for (i = 0; i < cnt; ++i) {
                PackageEntry pe = this.classReader.readPackageEntry(p);
                int exportFlags = this.classReader.readU2(p + 2);
                List<ModuleEntry> exportsTo = this.readEntryList(p += 4);
                p += 2 + exportsTo.size() * 2;
                elements[i] = ModuleExportInfo.of(pe, exportFlags, exportsTo);
            }
            this.exports = List.of(elements);
            cnt = this.classReader.readU2(p);
            p += 2;
            elements = new ModuleOpenInfo[cnt];
            for (i = 0; i < cnt; ++i) {
                PackageEntry po = this.classReader.readPackageEntry(p);
                int opensFlags = this.classReader.readU2(p + 2);
                List<ModuleEntry> opensTo = this.readEntryList(p += 4);
                p += 2 + opensTo.size() * 2;
                elements[i] = ModuleOpenInfo.of(po, opensFlags, opensTo);
            }
            this.opens = List.of(elements);
            this.uses = this.readEntryList(p);
            cnt = this.classReader.readU2(p += 2 + this.uses.size() * 2);
            p += 2;
            elements = new ModuleProvideInfo[cnt];
            this.provides = new ArrayList<ModuleProvideInfo>(cnt);
            for (i = 0; i < cnt; ++i) {
                ClassEntry c = this.classReader.readClassEntry(p);
                List<ClassEntry> providesWith = this.readEntryList(p += 2);
                p += 2 + providesWith.size() * 2;
                elements[i] = ModuleProvideInfo.of(c, providesWith);
            }
            this.provides = List.of(elements);
        }
    }

    public static final class BoundExceptionsAttribute
    extends BoundAttribute<ExceptionsAttribute>
    implements ExceptionsAttribute {
        private List<ClassEntry> exceptions = null;

        public BoundExceptionsAttribute(ClassReader cf, AttributeMapper<ExceptionsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> exceptions() {
            if (this.exceptions == null) {
                this.exceptions = this.readEntryList(this.payloadStart);
            }
            return this.exceptions;
        }
    }

    public static final class BoundModuleResolutionAttribute
    extends BoundAttribute<ModuleResolutionAttribute>
    implements ModuleResolutionAttribute {
        public BoundModuleResolutionAttribute(ClassReader cf, AttributeMapper<ModuleResolutionAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public int resolutionFlags() {
            return this.classReader.readU2(this.payloadStart);
        }
    }

    public static final class BoundSourceIDAttribute
    extends BoundAttribute<SourceIDAttribute>
    implements SourceIDAttribute {
        public BoundSourceIDAttribute(ClassReader cf, AttributeMapper<SourceIDAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry sourceId() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }
    }

    public static final class BoundCompilationIDAttribute
    extends BoundAttribute<CompilationIDAttribute>
    implements CompilationIDAttribute {
        public BoundCompilationIDAttribute(ClassReader cf, AttributeMapper<CompilationIDAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry compilationId() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }
    }

    public static final class BoundModuleTargetAttribute
    extends BoundAttribute<ModuleTargetAttribute>
    implements ModuleTargetAttribute {
        public BoundModuleTargetAttribute(ClassReader cf, AttributeMapper<ModuleTargetAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry targetPlatform() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }
    }

    public static final class BoundConstantValueAttribute
    extends BoundAttribute<ConstantValueAttribute>
    implements ConstantValueAttribute {
        public BoundConstantValueAttribute(ClassReader cf, AttributeMapper<ConstantValueAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ConstantValueEntry constant() {
            return (ConstantValueEntry)this.classReader.readEntry(this.payloadStart);
        }
    }

    public static final class BoundSourceDebugExtensionAttribute
    extends BoundAttribute<SourceDebugExtensionAttribute>
    implements SourceDebugExtensionAttribute {
        public BoundSourceDebugExtensionAttribute(ClassReader cf, AttributeMapper<SourceDebugExtensionAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundNestHostAttribute
    extends BoundAttribute<NestHostAttribute>
    implements NestHostAttribute {
        public BoundNestHostAttribute(ClassReader cf, AttributeMapper<NestHostAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry nestHost() {
            return this.classReader.readClassEntry(this.payloadStart);
        }
    }

    public static final class BoundModuleMainClassAttribute
    extends BoundAttribute<ModuleMainClassAttribute>
    implements ModuleMainClassAttribute {
        public BoundModuleMainClassAttribute(ClassReader cf, AttributeMapper<ModuleMainClassAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry mainClass() {
            return this.classReader.readClassEntry(this.payloadStart);
        }
    }

    public static final class BoundSourceFileAttribute
    extends BoundAttribute<SourceFileAttribute>
    implements SourceFileAttribute {
        public BoundSourceFileAttribute(ClassReader cf, AttributeMapper<SourceFileAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry sourceFile() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }
    }

    public static final class BoundSignatureAttribute
    extends BoundAttribute<SignatureAttribute>
    implements SignatureAttribute {
        public BoundSignatureAttribute(ClassReader cf, AttributeMapper<SignatureAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry signature() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }
    }

    public static final class BoundDeprecatedAttribute
    extends BoundAttribute<DeprecatedAttribute>
    implements DeprecatedAttribute {
        public BoundDeprecatedAttribute(ClassReader cf, AttributeMapper<DeprecatedAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundRecordAttribute
    extends BoundAttribute<RecordAttribute>
    implements RecordAttribute {
        private List<RecordComponentInfo> components = null;

        public BoundRecordAttribute(ClassReader cf, AttributeMapper<RecordAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<RecordComponentInfo> components() {
            if (this.components == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                RecordComponentInfo[] elements = new RecordComponentInfo[cnt];
                int p = this.payloadStart + 2;
                for (int i = 0; i < cnt; ++i) {
                    elements[i] = new BoundRecordComponentInfo(this.classReader, p);
                    p = this.classReader.skipAttributeHolder(p + 4);
                }
                this.components = List.of(elements);
            }
            return this.components;
        }
    }

    public static final class BoundModuleHashesAttribute
    extends BoundAttribute<ModuleHashesAttribute>
    implements ModuleHashesAttribute {
        private List<ModuleHashInfo> hashes = null;

        public BoundModuleHashesAttribute(ClassReader cf, AttributeMapper<ModuleHashesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry algorithm() {
            return this.classReader.readUtf8Entry(this.payloadStart);
        }

        @Override
        public List<ModuleHashInfo> hashes() {
            if (this.hashes == null) {
                int cnt = this.classReader.readU2(this.payloadStart + 2);
                ModuleHashInfo[] elements = new ModuleHashInfo[cnt];
                int p = this.payloadStart + 4;
                for (int i = 0; i < cnt; ++i) {
                    ModuleEntry module = this.classReader.readModuleEntry(p);
                    int hashLength = this.classReader.readU2(p + 2);
                    elements[i] = ModuleHashInfo.of(module, this.classReader.readBytes(p += 4, hashLength));
                    p += hashLength;
                }
                this.hashes = List.of(elements);
            }
            return this.hashes;
        }
    }

    public static final class BoundMethodParametersAttribute
    extends BoundAttribute<MethodParametersAttribute>
    implements MethodParametersAttribute {
        private List<MethodParameterInfo> parameters = null;

        public BoundMethodParametersAttribute(ClassReader cf, AttributeMapper<MethodParametersAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<MethodParameterInfo> parameters() {
            if (this.parameters == null) {
                int cnt = this.classReader.readU1(this.payloadStart);
                MethodParameterInfo[] elements = new MethodParameterInfo[cnt];
                int p = this.payloadStart + 1;
                int pEnd = p + cnt * 4;
                int i = 0;
                while (p < pEnd) {
                    Utf8Entry name = this.classReader.readUtf8Entry(p);
                    int accessFlags = this.classReader.readU2(p + 2);
                    elements[i] = MethodParameterInfo.of(Optional.ofNullable(name), accessFlags);
                    p += 4;
                    ++i;
                }
                this.parameters = List.of(elements);
            }
            return this.parameters;
        }
    }

    public static final class BoundLocalVariableTypeTableAttribute
    extends BoundAttribute<LocalVariableTypeTableAttribute>
    implements LocalVariableTypeTableAttribute {
        private final CodeImpl codeAttribute;
        private List<LocalVariableTypeInfo> localVars = null;

        public BoundLocalVariableTypeTableAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<LocalVariableTypeTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            this.codeAttribute = (CodeImpl)enclosing;
        }

        @Override
        public List<LocalVariableTypeInfo> localVariableTypes() {
            if (this.localVars == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                BoundLocalVariableType[] elements = new BoundLocalVariableType[cnt];
                int p = this.payloadStart + 2;
                int pEnd = p + cnt * 10;
                int i = 0;
                while (p < pEnd) {
                    elements[i] = new BoundLocalVariableType(this.codeAttribute, p);
                    p += 10;
                    ++i;
                }
                this.localVars = List.of(elements);
            }
            return this.localVars;
        }
    }

    public static final class BoundLocalVariableTableAttribute
    extends BoundAttribute<LocalVariableTableAttribute>
    implements LocalVariableTableAttribute {
        private final CodeImpl codeAttribute;
        private List<LocalVariableInfo> localVars = null;

        public BoundLocalVariableTableAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<LocalVariableTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            this.codeAttribute = (CodeImpl)enclosing;
        }

        @Override
        public List<LocalVariableInfo> localVariables() {
            if (this.localVars == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                BoundLocalVariable[] elements = new BoundLocalVariable[cnt];
                int p = this.payloadStart + 2;
                int pEnd = p + cnt * 10;
                int i = 0;
                while (p < pEnd) {
                    elements[i] = new BoundLocalVariable(this.codeAttribute, p);
                    p += 10;
                    ++i;
                }
                this.localVars = List.of(elements);
            }
            return this.localVars;
        }
    }

    public static final class BoundCharacterRangeTableAttribute
    extends BoundAttribute<CharacterRangeTableAttribute>
    implements CharacterRangeTableAttribute {
        private List<CharacterRangeInfo> characterRangeTable = null;

        public BoundCharacterRangeTableAttribute(ClassReader cf, AttributeMapper<CharacterRangeTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<CharacterRangeInfo> characterRangeTable() {
            if (this.characterRangeTable == null) {
                int nLn = this.classReader.readU2(this.payloadStart);
                CharacterRangeInfo[] elements = new CharacterRangeInfo[nLn];
                int p = this.payloadStart + 2;
                int pEnd = p + nLn * 14;
                int i = 0;
                while (p < pEnd) {
                    int startPc = this.classReader.readU2(p);
                    int endPc = this.classReader.readU2(p + 2);
                    int characterRangeStart = this.classReader.readInt(p + 4);
                    int characterRangeEnd = this.classReader.readInt(p + 8);
                    int flags = this.classReader.readU2(p + 12);
                    elements[i] = CharacterRangeInfo.of(startPc, endPc, characterRangeStart, characterRangeEnd, flags);
                    p += 14;
                    ++i;
                }
                this.characterRangeTable = List.of(elements);
            }
            return this.characterRangeTable;
        }
    }

    public static final class BoundLineNumberTableAttribute
    extends BoundAttribute<LineNumberTableAttribute>
    implements LineNumberTableAttribute {
        private List<LineNumberInfo> lineNumbers = null;

        public BoundLineNumberTableAttribute(ClassReader cf, AttributeMapper<LineNumberTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<LineNumberInfo> lineNumbers() {
            if (this.lineNumbers == null) {
                int nLn = this.classReader.readU2(this.payloadStart);
                LineNumberInfo[] elements = new LineNumberInfo[nLn];
                int p = this.payloadStart + 2;
                int pEnd = p + nLn * 4;
                int i = 0;
                while (p < pEnd) {
                    int startPc = this.classReader.readU2(p);
                    int lineNumber = this.classReader.readU2(p + 2);
                    elements[i] = LineNumberInfo.of(startPc, lineNumber);
                    p += 4;
                    ++i;
                }
                this.lineNumbers = List.of(elements);
            }
            return this.lineNumbers;
        }
    }

    public static final class BoundSyntheticAttribute
    extends BoundAttribute<SyntheticAttribute>
    implements SyntheticAttribute {
        public BoundSyntheticAttribute(ClassReader cf, AttributeMapper<SyntheticAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundStackMapTableAttribute
    extends BoundAttribute<StackMapTableAttribute>
    implements StackMapTableAttribute {
        final MethodModel method;
        final LabelContext ctx;
        List<StackMapFrameInfo> entries = null;

        public BoundStackMapTableAttribute(CodeImpl code, ClassReader cf, AttributeMapper<StackMapTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            this.method = code.parent().orElseThrow();
            this.ctx = code;
        }

        @Override
        public List<StackMapFrameInfo> entries() {
            if (this.entries == null) {
                this.entries = new StackMapDecoder(this.classReader, this.payloadStart, this.ctx, StackMapDecoder.initFrameLocals(this.method)).entries();
            }
            return this.entries;
        }
    }
}

