/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantDynamicEntry;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;

public class BytecodeHelpers {
    private BytecodeHelpers() {
    }

    public static Opcode loadOpcode(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.IntType, TypeKind.ShortType, TypeKind.ByteType, TypeKind.CharType, TypeKind.BooleanType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.ILOAD_0;
                    }
                    case 1: {
                        yield Opcode.ILOAD_1;
                    }
                    case 2: {
                        yield Opcode.ILOAD_2;
                    }
                    case 3: {
                        yield Opcode.ILOAD_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.ILOAD;
                }
                yield Opcode.ILOAD_W;
            }
            case TypeKind.LongType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.LLOAD_0;
                    }
                    case 1: {
                        yield Opcode.LLOAD_1;
                    }
                    case 2: {
                        yield Opcode.LLOAD_2;
                    }
                    case 3: {
                        yield Opcode.LLOAD_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.LLOAD;
                }
                yield Opcode.LLOAD_W;
            }
            case TypeKind.DoubleType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.DLOAD_0;
                    }
                    case 1: {
                        yield Opcode.DLOAD_1;
                    }
                    case 2: {
                        yield Opcode.DLOAD_2;
                    }
                    case 3: {
                        yield Opcode.DLOAD_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.DLOAD;
                }
                yield Opcode.DLOAD_W;
            }
            case TypeKind.FloatType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.FLOAD_0;
                    }
                    case 1: {
                        yield Opcode.FLOAD_1;
                    }
                    case 2: {
                        yield Opcode.FLOAD_2;
                    }
                    case 3: {
                        yield Opcode.FLOAD_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.FLOAD;
                }
                yield Opcode.FLOAD_W;
            }
            case TypeKind.ReferenceType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.ALOAD_0;
                    }
                    case 1: {
                        yield Opcode.ALOAD_1;
                    }
                    case 2: {
                        yield Opcode.ALOAD_2;
                    }
                    case 3: {
                        yield Opcode.ALOAD_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.ALOAD;
                }
                yield Opcode.ALOAD_W;
            }
            case TypeKind.VoidType -> throw new IllegalArgumentException("void");
        };
    }

    public static Opcode storeOpcode(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.IntType, TypeKind.ShortType, TypeKind.ByteType, TypeKind.CharType, TypeKind.BooleanType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.ISTORE_0;
                    }
                    case 1: {
                        yield Opcode.ISTORE_1;
                    }
                    case 2: {
                        yield Opcode.ISTORE_2;
                    }
                    case 3: {
                        yield Opcode.ISTORE_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.ISTORE;
                }
                yield Opcode.ISTORE_W;
            }
            case TypeKind.LongType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.LSTORE_0;
                    }
                    case 1: {
                        yield Opcode.LSTORE_1;
                    }
                    case 2: {
                        yield Opcode.LSTORE_2;
                    }
                    case 3: {
                        yield Opcode.LSTORE_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.LSTORE;
                }
                yield Opcode.LSTORE_W;
            }
            case TypeKind.DoubleType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.DSTORE_0;
                    }
                    case 1: {
                        yield Opcode.DSTORE_1;
                    }
                    case 2: {
                        yield Opcode.DSTORE_2;
                    }
                    case 3: {
                        yield Opcode.DSTORE_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.DSTORE;
                }
                yield Opcode.DSTORE_W;
            }
            case TypeKind.FloatType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.FSTORE_0;
                    }
                    case 1: {
                        yield Opcode.FSTORE_1;
                    }
                    case 2: {
                        yield Opcode.FSTORE_2;
                    }
                    case 3: {
                        yield Opcode.FSTORE_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.FSTORE;
                }
                yield Opcode.FSTORE_W;
            }
            case TypeKind.ReferenceType -> {
                switch (slot) {
                    case 0: {
                        yield Opcode.ASTORE_0;
                    }
                    case 1: {
                        yield Opcode.ASTORE_1;
                    }
                    case 2: {
                        yield Opcode.ASTORE_2;
                    }
                    case 3: {
                        yield Opcode.ASTORE_3;
                    }
                }
                if (slot < 256) {
                    yield Opcode.ASTORE;
                }
                yield Opcode.ASTORE_W;
            }
            case TypeKind.VoidType -> throw new IllegalArgumentException("void");
        };
    }

    public static Opcode returnOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.IntType, TypeKind.ShortType, TypeKind.ByteType, TypeKind.CharType, TypeKind.BooleanType -> Opcode.IRETURN;
            case TypeKind.FloatType -> Opcode.FRETURN;
            case TypeKind.LongType -> Opcode.LRETURN;
            case TypeKind.DoubleType -> Opcode.DRETURN;
            case TypeKind.ReferenceType -> Opcode.ARETURN;
            case TypeKind.VoidType -> Opcode.RETURN;
        };
    }

    public static Opcode arrayLoadOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.ByteType, TypeKind.BooleanType -> Opcode.BALOAD;
            case TypeKind.ShortType -> Opcode.SALOAD;
            case TypeKind.IntType -> Opcode.IALOAD;
            case TypeKind.FloatType -> Opcode.FALOAD;
            case TypeKind.LongType -> Opcode.LALOAD;
            case TypeKind.DoubleType -> Opcode.DALOAD;
            case TypeKind.ReferenceType -> Opcode.AALOAD;
            case TypeKind.CharType -> Opcode.CALOAD;
            case TypeKind.VoidType -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static Opcode arrayStoreOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.ByteType, TypeKind.BooleanType -> Opcode.BASTORE;
            case TypeKind.ShortType -> Opcode.SASTORE;
            case TypeKind.IntType -> Opcode.IASTORE;
            case TypeKind.FloatType -> Opcode.FASTORE;
            case TypeKind.LongType -> Opcode.LASTORE;
            case TypeKind.DoubleType -> Opcode.DASTORE;
            case TypeKind.ReferenceType -> Opcode.AASTORE;
            case TypeKind.CharType -> Opcode.CASTORE;
            case TypeKind.VoidType -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static Opcode reverseBranchOpcode(Opcode op) {
        return switch (op) {
            case Opcode.IFEQ -> Opcode.IFNE;
            case Opcode.IFNE -> Opcode.IFEQ;
            case Opcode.IFLT -> Opcode.IFGE;
            case Opcode.IFGE -> Opcode.IFLT;
            case Opcode.IFGT -> Opcode.IFLE;
            case Opcode.IFLE -> Opcode.IFGT;
            case Opcode.IF_ICMPEQ -> Opcode.IF_ICMPNE;
            case Opcode.IF_ICMPNE -> Opcode.IF_ICMPEQ;
            case Opcode.IF_ICMPLT -> Opcode.IF_ICMPGE;
            case Opcode.IF_ICMPGE -> Opcode.IF_ICMPLT;
            case Opcode.IF_ICMPGT -> Opcode.IF_ICMPLE;
            case Opcode.IF_ICMPLE -> Opcode.IF_ICMPGT;
            case Opcode.IF_ACMPEQ -> Opcode.IF_ACMPNE;
            case Opcode.IF_ACMPNE -> Opcode.IF_ACMPEQ;
            case Opcode.IFNULL -> Opcode.IFNONNULL;
            case Opcode.IFNONNULL -> Opcode.IFNULL;
            default -> throw new IllegalArgumentException("Unknown branch instruction: " + op);
        };
    }

    public static Opcode convertOpcode(TypeKind from, TypeKind to) {
        return switch (from) {
            case TypeKind.IntType -> {
                switch (to) {
                    case LongType: {
                        yield Opcode.I2L;
                    }
                    case FloatType: {
                        yield Opcode.I2F;
                    }
                    case DoubleType: {
                        yield Opcode.I2D;
                    }
                    case ByteType: {
                        yield Opcode.I2B;
                    }
                    case CharType: {
                        yield Opcode.I2C;
                    }
                    case ShortType: {
                        yield Opcode.I2S;
                    }
                }
                throw new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
            }
            case TypeKind.LongType -> {
                switch (to) {
                    case FloatType: {
                        yield Opcode.L2F;
                    }
                    case DoubleType: {
                        yield Opcode.L2D;
                    }
                    case IntType: {
                        yield Opcode.L2I;
                    }
                }
                throw new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
            }
            case TypeKind.DoubleType -> {
                switch (to) {
                    case FloatType: {
                        yield Opcode.D2F;
                    }
                    case LongType: {
                        yield Opcode.D2L;
                    }
                    case IntType: {
                        yield Opcode.D2I;
                    }
                }
                throw new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
            }
            case TypeKind.FloatType -> {
                switch (to) {
                    case LongType: {
                        yield Opcode.F2L;
                    }
                    case DoubleType: {
                        yield Opcode.F2D;
                    }
                    case IntType: {
                        yield Opcode.F2I;
                    }
                }
                throw new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
            }
            default -> throw new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
        };
    }

    static void validateSIPUSH(ConstantDesc d) {
        Long lVal;
        Integer iVal;
        if (d instanceof Integer && Short.MIN_VALUE <= (iVal = (Integer)d) && iVal <= Short.MAX_VALUE) {
            return;
        }
        if (d instanceof Long && -32768L <= (lVal = (Long)d) && 32767L <= lVal) {
            return;
        }
        throw new IllegalArgumentException("SIPUSH: value must be within: Short.MIN_VALUE <= value <= Short.MAX_VALUE, found: " + d);
    }

    static void validateBIPUSH(ConstantDesc d) {
        Long lVal;
        Integer iVal;
        if (d instanceof Integer && -128 <= (iVal = (Integer)d) && iVal <= 127) {
            return;
        }
        if (d instanceof Long && -128L <= (lVal = (Long)d) && 127L <= lVal) {
            return;
        }
        throw new IllegalArgumentException("BIPUSH: value must be within: Byte.MIN_VALUE <= value <= Byte.MAX_VALUE, found: " + d);
    }

    public static MethodHandleEntry handleDescToHandleInfo(ConstantPoolBuilder constantPool, DirectMethodHandleDesc bootstrapMethod) {
        ClassEntry bsOwner = constantPool.classEntry(bootstrapMethod.owner());
        NameAndTypeEntry bsNameAndType = constantPool.nameAndTypeEntry(constantPool.utf8Entry(bootstrapMethod.methodName()), constantPool.utf8Entry(bootstrapMethod.lookupDescriptor()));
        int bsRefKind = bootstrapMethod.refKind();
        MemberRefEntry bsReference = BytecodeHelpers.toBootstrapMemberRef(constantPool, bsRefKind, bsOwner, bsNameAndType, bootstrapMethod.isOwnerInterface());
        return constantPool.methodHandleEntry(bsRefKind, bsReference);
    }

    static MemberRefEntry toBootstrapMemberRef(ConstantPoolBuilder constantPool, int bsRefKind, ClassEntry owner, NameAndTypeEntry nat, boolean isOwnerInterface) {
        return isOwnerInterface ? constantPool.interfaceMethodRefEntry(owner, nat) : (bsRefKind <= 4 ? constantPool.fieldRefEntry(owner, nat) : constantPool.methodRefEntry(owner, nat));
    }

    static ConstantDynamicEntry handleConstantDescToHandleInfo(ConstantPoolBuilder constantPool, DynamicConstantDesc<?> desc) {
        ConstantDesc[] bootstrapArgs = desc.bootstrapArgs();
        ArrayList<LoadableConstantEntry> staticArgs = new ArrayList<LoadableConstantEntry>(bootstrapArgs.length);
        for (ConstantDesc bootstrapArg : bootstrapArgs) {
            staticArgs.add(constantPool.loadableConstantEntry(bootstrapArg));
        }
        DirectMethodHandleDesc bootstrapDesc = desc.bootstrapMethod();
        ClassEntry bsOwner = constantPool.classEntry(bootstrapDesc.owner());
        NameAndTypeEntry bsNameAndType = constantPool.nameAndTypeEntry(bootstrapDesc.methodName(), bootstrapDesc.invocationType());
        int bsRefKind = bootstrapDesc.refKind();
        MemberRefEntry memberRefEntry = BytecodeHelpers.toBootstrapMemberRef(constantPool, bsRefKind, bsOwner, bsNameAndType, bootstrapDesc.isOwnerInterface());
        MethodHandleEntry methodHandleEntry = constantPool.methodHandleEntry(bsRefKind, memberRefEntry);
        BootstrapMethodEntry bme = constantPool.bsmEntry(methodHandleEntry, staticArgs);
        return constantPool.constantDynamicEntry(bme, constantPool.nameAndTypeEntry(desc.constantName(), desc.constantType()));
    }

    public static void validateValue(Opcode opcode, ConstantDesc v) {
        switch (opcode) {
            case ACONST_NULL: {
                if (v == null || v == ConstantDescs.NULL) break;
                throw new IllegalArgumentException("value must be null or ConstantDescs.NULL with opcode ACONST_NULL");
            }
            case SIPUSH: {
                BytecodeHelpers.validateSIPUSH(v);
                break;
            }
            case BIPUSH: {
                BytecodeHelpers.validateBIPUSH(v);
                break;
            }
            case LDC: 
            case LDC_W: 
            case LDC2_W: {
                if (v != null) break;
                throw new IllegalArgumentException("`null` must use ACONST_NULL");
            }
            default: {
                Long l;
                ConstantDesc exp = opcode.constantValue();
                if (exp == null) {
                    throw new IllegalArgumentException("Can not use Opcode: " + opcode + " with constant()");
                }
                if (v != null && (v.equals(exp) || exp instanceof Long && v.equals((l = (Long)exp).intValue()))) break;
                String t = exp instanceof Long ? "L" : (exp instanceof Float ? "f" : (exp instanceof Double ? "d" : ""));
                throw new IllegalArgumentException("value must be " + exp + t + " with opcode " + opcode.name());
            }
        }
    }

    public static LoadableConstantEntry constantEntry(ConstantPoolBuilder constantPool, ConstantDesc constantValue) {
        if (constantValue instanceof Integer) {
            Integer value = (Integer)constantValue;
            return constantPool.intEntry(value);
        }
        if (constantValue instanceof String) {
            String value = (String)((Object)constantValue);
            return constantPool.stringEntry(value);
        }
        if (constantValue instanceof ClassDesc) {
            ClassDesc value = (ClassDesc)constantValue;
            return constantPool.classEntry(value);
        }
        if (constantValue instanceof Long) {
            Long value = (Long)constantValue;
            return constantPool.longEntry(value);
        }
        if (constantValue instanceof Float) {
            Float value = (Float)constantValue;
            return constantPool.floatEntry(value.floatValue());
        }
        if (constantValue instanceof Double) {
            Double value = (Double)constantValue;
            return constantPool.doubleEntry(value);
        }
        if (constantValue instanceof MethodTypeDesc) {
            MethodTypeDesc value = (MethodTypeDesc)constantValue;
            return constantPool.methodTypeEntry(value);
        }
        if (constantValue instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc value = (DirectMethodHandleDesc)constantValue;
            return BytecodeHelpers.handleDescToHandleInfo(constantPool, value);
        }
        if (constantValue instanceof DynamicConstantDesc) {
            DynamicConstantDesc value = (DynamicConstantDesc)constantValue;
            return BytecodeHelpers.handleConstantDescToHandleInfo(constantPool, value);
        }
        throw new UnsupportedOperationException("not yet: " + constantValue);
    }
}

