/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.impl.BlockCodeBuilderImpl;

public final class CatchBuilderImpl
implements CodeBuilder.CatchBuilder {
    final CodeBuilder b;
    final BlockCodeBuilderImpl tryBlock;
    final Label tryCatchEnd;
    final Set<ConstantDesc> catchTypes;
    BlockCodeBuilderImpl catchBlock;

    public CatchBuilderImpl(CodeBuilder b, BlockCodeBuilderImpl tryBlock, Label tryCatchEnd) {
        this.b = b;
        this.tryBlock = tryBlock;
        this.tryCatchEnd = tryCatchEnd;
        this.catchTypes = new HashSet<ConstantDesc>();
    }

    @Override
    public CodeBuilder.CatchBuilder catching(ClassDesc exceptionType, Consumer<CodeBuilder.BlockCodeBuilder> catchHandler) {
        return this.catchingMulti(exceptionType == null ? List.of() : List.of(exceptionType), catchHandler);
    }

    @Override
    public CodeBuilder.CatchBuilder catchingMulti(List<ClassDesc> exceptionTypes, Consumer<CodeBuilder.BlockCodeBuilder> catchHandler) {
        Objects.requireNonNull(exceptionTypes);
        Objects.requireNonNull(catchHandler);
        if (this.catchBlock == null && this.tryBlock.reachable()) {
            this.b.branchInstruction(Opcode.GOTO, this.tryCatchEnd);
        }
        for (ClassDesc exceptionType : exceptionTypes) {
            if (this.catchTypes.add(exceptionType)) continue;
            throw new IllegalArgumentException("Existing catch block catches exception of type: " + exceptionType);
        }
        if (this.catchBlock != null) {
            this.catchBlock.end();
            if (this.catchBlock.reachable()) {
                this.b.branchInstruction(Opcode.GOTO, this.tryCatchEnd);
            }
        }
        this.catchBlock = new BlockCodeBuilderImpl(this.b, this.tryCatchEnd);
        Label tryStart = this.tryBlock.startLabel();
        Label tryEnd = this.tryBlock.endLabel();
        if (exceptionTypes.isEmpty()) {
            this.catchBlock.exceptionCatchAll(tryStart, tryEnd, this.catchBlock.startLabel());
        } else {
            for (ClassDesc exceptionType : exceptionTypes) {
                this.catchBlock.exceptionCatch(tryStart, tryEnd, this.catchBlock.startLabel(), exceptionType);
            }
        }
        this.catchBlock.start();
        catchHandler.accept(this.catchBlock);
        return this;
    }

    @Override
    public void catchingAll(Consumer<CodeBuilder.BlockCodeBuilder> catchAllHandler) {
        this.catchingMulti(List.of(), catchAllHandler);
    }

    public void finish() {
        if (this.catchBlock != null) {
            this.catchBlock.end();
        }
        this.b.labelBinding(this.tryCatchEnd);
    }
}

