/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.glavo.classfile.ClassHierarchyResolver;
import org.glavo.classfile.jdk.ClassDescUtils;

public final class ClassHierarchyImpl {
    private final ClassHierarchyResolver resolver;
    private static System.Logger logger;

    public ClassHierarchyImpl(ClassHierarchyResolver classHierarchyResolver) {
        this.resolver = classHierarchyResolver;
    }

    private ClassHierarchyResolver.ClassHierarchyInfo resolve(ClassDesc classDesc) {
        ClassHierarchyResolver.ClassHierarchyInfo res = this.resolver.getClassInfo(classDesc);
        if (res != null) {
            return res;
        }
        if (logger == null) {
            logger = System.getLogger("org.glavo.classfile");
        }
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, "Could not resolve class " + classDesc.displayName());
        }
        return new ClassHierarchyResolver.ClassHierarchyInfo(classDesc, false, null);
    }

    public boolean isInterface(ClassDesc classDesc) {
        return this.resolve(classDesc).isInterface();
    }

    public ClassDesc commonAncestor(ClassDesc symbol1, ClassDesc symbol2) {
        if (this.isInterface(symbol1) || this.isInterface(symbol2)) {
            return ConstantDescs.CD_Object;
        }
        ClassDesc s1 = symbol1;
        while (s1 != null) {
            ClassDesc s2 = symbol2;
            while (s2 != null) {
                if (s1.equals(s2)) {
                    return s1;
                }
                s2 = this.resolve(s2).superClass();
            }
            s1 = this.resolve(s1).superClass();
        }
        return null;
    }

    public boolean isAssignableFrom(ClassDesc thisClass, ClassDesc fromClass) {
        if (this.isInterface(fromClass)) {
            return this.resolve(thisClass).superClass() == null;
        }
        ClassDesc anc = this.commonAncestor(thisClass, fromClass);
        return anc == null || thisClass.equals(anc);
    }

    public static final class StaticClassHierarchyResolver
    implements ClassHierarchyResolver {
        private final Map<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> map;

        public StaticClassHierarchyResolver(Collection<ClassDesc> interfaceNames, Map<ClassDesc, ClassDesc> classToSuperClass) {
            this.map = new HashMap<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo>(interfaceNames.size() + classToSuperClass.size());
            for (Map.Entry<ClassDesc, ClassDesc> e : classToSuperClass.entrySet()) {
                this.map.put(e.getKey(), new ClassHierarchyResolver.ClassHierarchyInfo(e.getKey(), false, e.getValue()));
            }
            for (ClassDesc i : interfaceNames) {
                this.map.put(i, new ClassHierarchyResolver.ClassHierarchyInfo(i, true, null));
            }
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
            return this.map.get(classDesc);
        }
    }

    public static final class CachedClassHierarchyResolver
    implements ClassHierarchyResolver {
        private final Function<ClassDesc, InputStream> streamProvider;
        private final Map<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> resolvedCache;

        public CachedClassHierarchyResolver(Function<ClassDesc, InputStream> classStreamProvider) {
            this.streamProvider = classStreamProvider;
            this.resolvedCache = Collections.synchronizedMap(new HashMap());
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
            ClassHierarchyResolver.ClassHierarchyInfo res = this.resolvedCache.get(classDesc);
            if (res == null && !this.resolvedCache.containsKey(classDesc)) {
                InputStream ci = this.streamProvider.apply(classDesc);
                if (ci != null) {
                    try (DataInputStream in = new DataInputStream(new BufferedInputStream(ci));){
                        in.skipBytes(8);
                        int cpLength = in.readUnsignedShort();
                        String[] cpStrings = new String[cpLength];
                        int[] cpClasses = new int[cpLength];
                        block15: for (int i = 1; i < cpLength; ++i) {
                            switch (in.readUnsignedByte()) {
                                case 1: {
                                    cpStrings[i] = in.readUTF();
                                    continue block15;
                                }
                                case 7: {
                                    cpClasses[i] = in.readUnsignedShort();
                                    continue block15;
                                }
                                case 8: 
                                case 16: 
                                case 19: 
                                case 20: {
                                    in.skipBytes(2);
                                    continue block15;
                                }
                                case 15: {
                                    in.skipBytes(3);
                                    continue block15;
                                }
                                case 3: 
                                case 4: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 17: 
                                case 18: {
                                    in.skipBytes(4);
                                    continue block15;
                                }
                                case 5: 
                                case 6: {
                                    in.skipBytes(8);
                                    ++i;
                                }
                            }
                        }
                        boolean isInterface = (in.readUnsignedShort() & 0x200) != 0;
                        in.skipBytes(2);
                        int superIndex = in.readUnsignedShort();
                        ClassDesc superClass = superIndex > 0 ? ClassDescUtils.ofInternalName(cpStrings[cpClasses[superIndex]]) : null;
                        res = new ClassHierarchyResolver.ClassHierarchyInfo(classDesc, isInterface, superClass);
                        int interfCount = in.readUnsignedShort();
                        for (int i = 0; i < interfCount; ++i) {
                            ClassDesc intDesc = ClassDescUtils.ofInternalName(cpStrings[cpClasses[in.readUnsignedShort()]]);
                            this.resolvedCache.put(intDesc, new ClassHierarchyResolver.ClassHierarchyInfo(intDesc, true, null));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.resolvedCache.put(classDesc, res);
            }
            return res;
        }
    }
}

