/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.DirectClassBuilder;

public final class FieldImpl
extends AbstractElement
implements FieldModel {
    private final ClassReader reader;
    private final int startPos;
    private final int endPos;
    private final int attributesPos;
    private List<Attribute<?>> attributes;

    public FieldImpl(ClassReader reader, int startPos, int endPos, int attributesPos) {
        this.reader = reader;
        this.startPos = startPos;
        this.endPos = endPos;
        this.attributesPos = attributesPos;
    }

    @Override
    public AccessFlags flags() {
        return AccessFlags.ofField(this.reader.readU2(this.startPos));
    }

    @Override
    public Optional<ClassModel> parent() {
        ClassReader classReader = this.reader;
        if (classReader instanceof ClassReaderImpl) {
            ClassReaderImpl cri = (ClassReaderImpl)classReader;
            return Optional.of(cri.getContainedClass());
        }
        return Optional.empty();
    }

    @Override
    public Utf8Entry fieldName() {
        return this.reader.readUtf8Entry(this.startPos + 2);
    }

    @Override
    public Utf8Entry fieldType() {
        return this.reader.readUtf8Entry(this.startPos + 4);
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void writeTo(BufWriter buf) {
        if (buf.canWriteDirect(this.reader)) {
            this.reader.copyBytesTo(buf, this.startPos, this.endPos - this.startPos);
        } else {
            buf.writeU2(this.flags().flagsMask());
            buf.writeIndex(this.fieldName());
            buf.writeIndex(this.fieldType());
            buf.writeList(this.attributes());
        }
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        if (builder.canWriteDirect(this.reader)) {
            builder.withField(this);
        } else {
            builder.withField(this.fieldName(), this.fieldType(), (Consumer<? super FieldBuilder>)new Consumer<FieldBuilder>(){

                @Override
                public void accept(FieldBuilder fb) {
                    FieldImpl.this.forEachElement(fb);
                }
            });
        }
    }

    @Override
    public void forEachElement(Consumer<FieldElement> consumer) {
        consumer.accept(this.flags());
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof FieldElement)) continue;
            FieldElement e = (FieldElement)((Object)attr);
            consumer.accept(e);
        }
    }

    public String toString() {
        return String.format("FieldModel[fieldName=%s, fieldType=%s, flags=%d]", this.fieldName().stringValue(), this.fieldType().stringValue(), this.flags().flagsMask());
    }
}

