/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Collection;
import java.util.function.Function;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.ClassHierarchyResolver;
import org.glavo.classfile.Classfile;
import org.glavo.classfile.constantpool.Utf8Entry;

public class Options {
    public Boolean generateStackmaps = true;
    public Boolean processDebug = true;
    public Boolean processLineNumbers = true;
    public Boolean processUnknownAttributes = true;
    public Boolean cpSharing = true;
    public Boolean fixJumps = true;
    public Boolean patchCode = true;
    public Boolean filterDeadLabels = false;
    public ClassHierarchyResolver classHierarchyResolver = ClassHierarchyResolver.DEFAULT_CLASS_HIERARCHY_RESOLVER;
    public Function<Utf8Entry, AttributeMapper<?>> attributeMapper = new Function<Utf8Entry, AttributeMapper<?>>(){

        @Override
        public AttributeMapper<?> apply(Utf8Entry k) {
            return null;
        }
    };

    public Options(Collection<Classfile.Option> options) {
        for (Classfile.Option o : options) {
            OptionValue ov = (OptionValue)o;
            Object v = ov.value();
            switch (ov.key()) {
                case GENERATE_STACK_MAPS: {
                    this.generateStackmaps = (Boolean)v;
                    break;
                }
                case PROCESS_DEBUG: {
                    this.processDebug = (Boolean)v;
                    break;
                }
                case PROCESS_LINE_NUMBERS: {
                    this.processLineNumbers = (Boolean)v;
                    break;
                }
                case PROCESS_UNKNOWN_ATTRIBUTES: {
                    this.processUnknownAttributes = (Boolean)v;
                    break;
                }
                case CP_SHARING: {
                    this.cpSharing = (Boolean)v;
                    break;
                }
                case FIX_SHORT_JUMPS: {
                    this.fixJumps = (Boolean)v;
                    break;
                }
                case PATCH_DEAD_CODE: {
                    this.patchCode = (Boolean)v;
                    break;
                }
                case HIERARCHY_RESOLVER: {
                    this.classHierarchyResolver = (ClassHierarchyResolver)v;
                    break;
                }
                case ATTRIBUTE_MAPPER: {
                    this.attributeMapper = (Function)v;
                    break;
                }
                case FILTER_DEAD_LABELS: {
                    this.filterDeadLabels = (Boolean)v;
                }
            }
        }
    }

    public record OptionValue(Key key, Object value) implements Classfile.Option
    {
    }

    public static enum Key {
        GENERATE_STACK_MAPS,
        PROCESS_DEBUG,
        PROCESS_LINE_NUMBERS,
        PROCESS_UNKNOWN_ATTRIBUTES,
        CP_SHARING,
        FIX_SHORT_JUMPS,
        PATCH_DEAD_CODE,
        HIERARCHY_RESOLVER,
        ATTRIBUTE_MAPPER,
        FILTER_DEAD_LABELS;

    }
}

