/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AnnotationImpl;
import org.glavo.classfile.impl.TemporaryConstantPool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotationElement
extends WritableElement<AnnotationElement> {
    public Utf8Entry name();

    public AnnotationValue value();

    public static AnnotationElement of(Utf8Entry name, AnnotationValue value) {
        return new AnnotationImpl.AnnotationElementImpl(name, value);
    }

    public static AnnotationElement of(String name, AnnotationValue value) {
        return AnnotationElement.of(TemporaryConstantPool.INSTANCE.utf8Entry(name), value);
    }

    public static AnnotationElement ofClass(String name, ClassDesc value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofClass(value));
    }

    public static AnnotationElement ofString(String name, String value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofString(value));
    }

    public static AnnotationElement ofLong(String name, long value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofLong(value));
    }

    public static AnnotationElement ofInt(String name, int value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofInt(value));
    }

    public static AnnotationElement ofChar(String name, char value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofChar(value));
    }

    public static AnnotationElement ofShort(String name, short value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofShort(value));
    }

    public static AnnotationElement ofByte(String name, byte value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofByte(value));
    }

    public static AnnotationElement ofBoolean(String name, boolean value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofBoolean(value));
    }

    public static AnnotationElement ofDouble(String name, double value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofDouble(value));
    }

    public static AnnotationElement ofFloat(String name, float value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofFloat(value));
    }

    public static AnnotationElement ofAnnotation(String name, Annotation value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofAnnotation(value));
    }

    public static AnnotationElement ofArray(String name, AnnotationValue ... values) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofArray(values));
    }
}

