/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import org.glavo.classfile.ClassfileElement;
import org.glavo.classfile.ClassfileTransform;
import org.glavo.classfile.CompoundElement;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;

public interface ClassfileBuilder<E extends ClassfileElement, B extends ClassfileBuilder<E, B>>
extends Consumer<E> {
    @Override
    default public void accept(E e) {
        this.with(e);
    }

    public B with(E var1);

    public ConstantPoolBuilder constantPool();

    default public boolean canWriteDirect(ConstantPool source) {
        return this.constantPool().canWriteDirect(source);
    }

    default public void transform(CompoundElement<E> model, ClassfileTransform<?, E, B> transform) {
        ClassfileBuilder builder = this;
        ClassfileTransform.ResolvedTransform<E> resolved = transform.resolve(builder);
        resolved.startHandler().run();
        model.forEachElement(resolved.consumer());
        resolved.endHandler().run();
    }
}

