/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.glavo.classfile.ClassfileTransform;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.impl.TransformImpl;

@FunctionalInterface
public interface MethodTransform
extends ClassfileTransform<MethodTransform, MethodElement, MethodBuilder> {
    public static final MethodTransform ACCEPT_ALL = new MethodTransform(){

        @Override
        public void accept(MethodBuilder builder, MethodElement element) {
            builder.with(element);
        }
    };

    public static MethodTransform ofStateful(Supplier<MethodTransform> supplier) {
        return new TransformImpl.SupplierMethodTransform(supplier);
    }

    public static MethodTransform endHandler(final Consumer<MethodBuilder> finisher) {
        return new MethodTransform(){

            @Override
            public void accept(MethodBuilder builder, MethodElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(MethodBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static MethodTransform dropping(Predicate<MethodElement> filter) {
        return (b, e) -> {
            if (!filter.test((MethodElement)e)) {
                b.with(e);
            }
        };
    }

    public static MethodTransform transformingCode(CodeTransform xform) {
        return new TransformImpl.MethodCodeTransform(xform);
    }

    @Override
    default public ClassfileTransform.ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
        return new TransformImpl.ResolvedTransformImpl<MethodElement>(e -> this.accept(builder, e), () -> this.atEnd(builder), () -> this.atStart(builder));
    }

    @Override
    default public MethodTransform andThen(MethodTransform t) {
        return new TransformImpl.ChainedMethodTransform(this, t);
    }
}

