/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

public enum TypeKind {
    ByteType("byte", "B", 8),
    ShortType("short", "S", 9),
    IntType("int", "I", 10),
    FloatType("float", "F", 6),
    LongType("long", "J", 11),
    DoubleType("double", "D", 7),
    ReferenceType("reference type", "L", -1),
    CharType("char", "C", 5),
    BooleanType("boolean", "Z", 4),
    VoidType("void", "V", -1);

    private static TypeKind[] newarraycodeToTypeTag;
    private final String name;
    private final String descriptor;
    private final int newarraycode;

    public String typeName() {
        return this.name;
    }

    public String descriptor() {
        return this.descriptor;
    }

    public int newarraycode() {
        return this.newarraycode;
    }

    public int slotSize() {
        return switch (this) {
            case VoidType -> 0;
            case LongType, DoubleType -> 2;
            default -> 1;
        };
    }

    public TypeKind asLoadable() {
        return switch (this) {
            case BooleanType, ByteType, CharType, ShortType -> IntType;
            default -> this;
        };
    }

    private TypeKind(String name, String descriptor, int newarraycode) {
        this.name = name;
        this.descriptor = descriptor;
        this.newarraycode = newarraycode;
    }

    public static TypeKind fromNewArrayCode(int newarraycode) {
        if (newarraycodeToTypeTag == null) {
            newarraycodeToTypeTag = new TypeKind[12];
            for (TypeKind tag : TypeKind.values()) {
                if (tag.newarraycode <= 0) continue;
                TypeKind.newarraycodeToTypeTag[tag.newarraycode] = tag;
            }
        }
        return newarraycodeToTypeTag[newarraycode];
    }

    public static TypeKind fromDescriptor(CharSequence s) {
        return switch (s.charAt(0)) {
            case 'L', '[' -> ReferenceType;
            case 'B' -> ByteType;
            case 'C' -> CharType;
            case 'Z' -> BooleanType;
            case 'S' -> ShortType;
            case 'I' -> IntType;
            case 'F' -> FloatType;
            case 'J' -> LongType;
            case 'D' -> DoubleType;
            case 'V' -> VoidType;
            default -> throw new IllegalStateException("Bad type: " + s);
        };
    }
}

