/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ClassDesc;
import java.util.Optional;
import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InnerClassInfo {
    public ClassEntry innerClass();

    public Optional<ClassEntry> outerClass();

    public Optional<Utf8Entry> innerName();

    public int flagsMask();

    default public Set<AccessFlag> flags() {
        return AccessFlag.maskToAccessFlags(this.flagsMask(), AccessFlag.Location.INNER_CLASS);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.INNER_CLASS, this.flagsMask(), flag);
    }

    public static InnerClassInfo of(ClassEntry innerClass, Optional<ClassEntry> outerClass, Optional<Utf8Entry> innerName, int flags) {
        return new UnboundAttribute.UnboundInnerClassInfo(innerClass, outerClass, innerName, flags);
    }

    public static InnerClassInfo of(ClassDesc innerClass, Optional<ClassDesc> outerClass, Optional<String> innerName, int flags) {
        return new UnboundAttribute.UnboundInnerClassInfo(TemporaryConstantPool.INSTANCE.classEntry(innerClass), outerClass.map(TemporaryConstantPool.INSTANCE::classEntry), innerName.map(TemporaryConstantPool.INSTANCE::utf8Entry), flags);
    }

    public static InnerClassInfo of(ClassDesc innerClass, Optional<ClassDesc> outerClass, Optional<String> innerName, AccessFlag ... flags) {
        return InnerClassInfo.of(innerClass, outerClass, innerName, Util.flagsToBits(AccessFlag.Location.INNER_CLASS, flags));
    }
}

