/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.java.lang.constant.ModuleDesc;
import org.glavo.classfile.java.lang.constant.PackageDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleOpenInfo {
    public PackageEntry openedPackage();

    public int opensFlagsMask();

    default public Set<AccessFlag> opensFlags() {
        return AccessFlag.maskToAccessFlags(this.opensFlagsMask(), AccessFlag.Location.MODULE_OPENS);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE_OPENS, this.opensFlagsMask(), flag);
    }

    public List<ModuleEntry> opensTo();

    public static ModuleOpenInfo of(PackageEntry opens, int opensFlags, List<ModuleEntry> opensTo) {
        return new UnboundAttribute.UnboundModuleOpenInfo(opens, opensFlags, opensTo);
    }

    public static ModuleOpenInfo of(PackageEntry opens, Collection<AccessFlag> opensFlags, List<ModuleEntry> opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageEntry opens, int opensFlags, ModuleEntry ... opensTo) {
        return ModuleOpenInfo.of(opens, opensFlags, List.of(opensTo));
    }

    public static ModuleOpenInfo of(PackageEntry opens, Collection<AccessFlag> opensFlags, ModuleEntry ... opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageDesc opens, int opensFlags, List<ModuleDesc> opensTo) {
        return ModuleOpenInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(opens.packageInternalName())), opensFlags, Util.moduleEntryList(opensTo));
    }

    public static ModuleOpenInfo of(PackageDesc opens, Collection<AccessFlag> opensFlags, List<ModuleDesc> opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageDesc opens, int opensFlags, ModuleDesc ... opensTo) {
        return ModuleOpenInfo.of(opens, opensFlags, List.of(opensTo));
    }

    public static ModuleOpenInfo of(PackageDesc opens, Collection<AccessFlag> opensFlags, ModuleDesc ... opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }
}

