/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ClassDesc;
import java.util.List;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributedElement;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RecordComponentInfo
extends AttributedElement {
    public Utf8Entry name();

    public Utf8Entry descriptor();

    default public ClassDesc descriptorSymbol() {
        return ClassDesc.ofDescriptor(this.descriptor().stringValue());
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(name, descriptor, attributes);
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(TemporaryConstantPool.INSTANCE.utf8Entry(name), TemporaryConstantPool.INSTANCE.utf8Entry(descriptor.descriptorString()), attributes);
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }
}

