/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ClassDesc;
import java.util.List;
import org.glavo.classfile.Label;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.impl.StackMapDecoder;
import org.glavo.classfile.impl.TemporaryConstantPool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StackMapFrameInfo {
    public int frameType();

    public Label target();

    public List<VerificationTypeInfo> locals();

    public List<VerificationTypeInfo> stack();

    public static StackMapFrameInfo of(Label target, List<VerificationTypeInfo> locals, List<VerificationTypeInfo> stack) {
        return new StackMapDecoder.StackMapFrameImpl(255, target, locals, stack);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UninitializedVerificationTypeInfo
    extends VerificationTypeInfo {
        public Label newTarget();

        public static UninitializedVerificationTypeInfo of(Label newTarget) {
            return new StackMapDecoder.UninitializedVerificationTypeInfoImpl(newTarget);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ObjectVerificationTypeInfo
    extends VerificationTypeInfo {
        public static ObjectVerificationTypeInfo of(ClassEntry className) {
            return new StackMapDecoder.ObjectVerificationTypeInfoImpl(className);
        }

        public static ObjectVerificationTypeInfo of(ClassDesc classDesc) {
            return ObjectVerificationTypeInfo.of(TemporaryConstantPool.INSTANCE.classEntry(classDesc));
        }

        public ClassEntry className();

        default public ClassDesc classSymbol() {
            return this.className().asSymbol();
        }
    }

    public static enum SimpleVerificationTypeInfo implements VerificationTypeInfo
    {
        ITEM_TOP(0),
        ITEM_INTEGER(1),
        ITEM_FLOAT(2),
        ITEM_DOUBLE(3),
        ITEM_LONG(4),
        ITEM_NULL(5),
        ITEM_UNINITIALIZED_THIS(6);

        private final int tag;

        private SimpleVerificationTypeInfo(int tag) {
            this.tag = tag;
        }

        @Override
        public int tag() {
            return this.tag;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface VerificationTypeInfo {
        public int tag();
    }
}

