/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.runtime.SwitchBootstraps;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.Label;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.CharacterRange;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.LabelTarget;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.SwitchCase;
import org.glavo.classfile.instruction.TableSwitchInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeRelabeler
extends CodeTransform {
    public static CodeRelabeler of() {
        return CodeRelabeler.of(new IdentityHashMap<Label, Label>());
    }

    public static CodeRelabeler of(Map<Label, Label> map) {
        return CodeRelabeler.of((Label l, CodeBuilder cob) -> map.computeIfAbsent((Label)l, ll -> cob.newLabel()));
    }

    public static CodeRelabeler of(BiFunction<Label, CodeBuilder, Label> mapFunction) {
        return new CodeRelabelerImpl(mapFunction);
    }

    public Label relabel(Label var1, CodeBuilder var2);

    public record CodeRelabelerImpl(BiFunction<Label, CodeBuilder, Label> mapFunction) implements CodeRelabeler
    {
        @Override
        public Label relabel(Label label, CodeBuilder cob) {
            return this.mapFunction.apply(label, cob);
        }

        @Override
        public void accept(CodeBuilder cob, CodeElement coe) {
            CodeElement codeElement = coe;
            Objects.requireNonNull(codeElement);
            CodeElement codeElement2 = codeElement;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BranchInstruction.class, LookupSwitchInstruction.class, TableSwitchInstruction.class, LabelTarget.class, ExceptionCatch.class, LocalVariable.class, LocalVariableType.class, CharacterRange.class}, (Object)codeElement2, n)) {
                case 0: {
                    BranchInstruction bi = (BranchInstruction)codeElement2;
                    cob.branchInstruction(bi.opcode(), this.relabel(bi.target(), cob));
                    break;
                }
                case 1: {
                    LookupSwitchInstruction lsi = (LookupSwitchInstruction)codeElement2;
                    cob.lookupSwitchInstruction(this.relabel(lsi.defaultTarget(), cob), lsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
                    break;
                }
                case 2: {
                    TableSwitchInstruction tsi = (TableSwitchInstruction)codeElement2;
                    cob.tableSwitchInstruction(tsi.lowValue(), tsi.highValue(), this.relabel(tsi.defaultTarget(), cob), tsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
                    break;
                }
                case 3: {
                    LabelTarget lt = (LabelTarget)codeElement2;
                    cob.labelBinding(this.relabel(lt.label(), cob));
                    break;
                }
                case 4: {
                    ExceptionCatch ec = (ExceptionCatch)codeElement2;
                    cob.exceptionCatch(this.relabel(ec.tryStart(), cob), this.relabel(ec.tryEnd(), cob), this.relabel(ec.handler(), cob), ec.catchType());
                    break;
                }
                case 5: {
                    LocalVariable lv = (LocalVariable)codeElement2;
                    cob.localVariable(lv.slot(), lv.name().stringValue(), lv.typeSymbol(), this.relabel(lv.startScope(), cob), this.relabel(lv.endScope(), cob));
                    break;
                }
                case 6: {
                    LocalVariableType lvt = (LocalVariableType)codeElement2;
                    cob.localVariableType(lvt.slot(), lvt.name().stringValue(), lvt.signatureSymbol(), this.relabel(lvt.startScope(), cob), this.relabel(lvt.endScope(), cob));
                    break;
                }
                case 7: {
                    CharacterRange chr = (CharacterRange)codeElement2;
                    cob.characterRange(this.relabel(chr.startScope(), cob), this.relabel(chr.endScope(), cob), chr.characterRangeStart(), chr.characterRangeEnd(), chr.flags());
                    break;
                }
                default: {
                    cob.with(coe);
                }
            }
        }
    }
}

