/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.instruction.ArrayLoadInstruction;
import org.glavo.classfile.instruction.ArrayStoreInstruction;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.ConvertInstruction;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LabelTarget;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.MonitorInstruction;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewPrimitiveArrayInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.NopInstruction;
import org.glavo.classfile.instruction.OperatorInstruction;
import org.glavo.classfile.instruction.ReturnInstruction;
import org.glavo.classfile.instruction.StackInstruction;
import org.glavo.classfile.instruction.StoreInstruction;
import org.glavo.classfile.instruction.SwitchCase;
import org.glavo.classfile.instruction.TableSwitchInstruction;
import org.glavo.classfile.instruction.ThrowInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeStackTracker
extends CodeTransform {
    public static CodeStackTracker of(TypeKind ... initialStack) {
        return new CodeStackTrackerImpl(initialStack);
    }

    public Optional<Collection<TypeKind>> stack();

    public Optional<Integer> maxStackSize();

    public static final class CodeStackTrackerImpl
    implements CodeStackTracker {
        private Stack stack = new Stack(null, 0, 0);
        private Integer maxSize = 0;
        private final Map<Label, Stack> map = new HashMap<Label, Stack>();

        CodeStackTrackerImpl(TypeKind ... initialStack) {
            for (int i = initialStack.length - 1; i >= 0; --i) {
                this.push(initialStack[i]);
            }
        }

        @Override
        public Optional<Collection<TypeKind>> stack() {
            return Optional.ofNullable(this.fork());
        }

        @Override
        public Optional<Integer> maxStackSize() {
            return Optional.ofNullable(this.maxSize);
        }

        private void push(TypeKind type) {
            if (this.stack != null) {
                if (type != TypeKind.VoidType) {
                    this.stack.push(type);
                }
            } else {
                this.maxSize = null;
            }
        }

        private void pop(int i) {
            if (this.stack != null) {
                while (i-- > 0) {
                    this.stack.pop();
                }
            } else {
                this.maxSize = null;
            }
        }

        private Stack fork() {
            return this.stack == null ? null : new Stack(this.stack.top, this.stack.count, this.stack.realSize);
        }

        private void withStack(Consumer<Stack> c) {
            if (this.stack != null) {
                c.accept(this.stack);
            } else {
                this.maxSize = null;
            }
        }

        @Override
        public void accept(CodeBuilder cb, CodeElement el) {
            cb.with(el);
            CodeElement codeElement = el;
            Objects.requireNonNull(codeElement);
            CodeElement codeElement2 = codeElement;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayLoadInstruction.class, ArrayStoreInstruction.class, BranchInstruction.class, ConstantInstruction.class, ConvertInstruction.class, FieldInstruction.class, InvokeDynamicInstruction.class, InvokeInstruction.class, LoadInstruction.class, StoreInstruction.class, LookupSwitchInstruction.class, MonitorInstruction.class, NewMultiArrayInstruction.class, NewObjectInstruction.class, NewPrimitiveArrayInstruction.class, NewReferenceArrayInstruction.class, NopInstruction.class, OperatorInstruction.class, ReturnInstruction.class, StackInstruction.class, TableSwitchInstruction.class, ThrowInstruction.class, TypeCheckInstruction.class, ExceptionCatch.class, LabelTarget.class}, (Object)codeElement2, n)) {
                case 0: {
                    ArrayLoadInstruction i = (ArrayLoadInstruction)codeElement2;
                    this.pop(2);
                    this.push(i.typeKind());
                    break;
                }
                case 1: {
                    ArrayStoreInstruction i = (ArrayStoreInstruction)codeElement2;
                    this.pop(3);
                    break;
                }
                case 2: {
                    BranchInstruction i = (BranchInstruction)codeElement2;
                    if (i.opcode() == Opcode.GOTO || i.opcode() == Opcode.GOTO_W) {
                        this.map.put(i.target(), this.stack);
                        this.stack = null;
                        break;
                    }
                    this.pop(1);
                    this.map.put(i.target(), this.fork());
                    break;
                }
                case 3: {
                    ConstantInstruction i = (ConstantInstruction)codeElement2;
                    this.push(i.typeKind());
                    break;
                }
                case 4: {
                    ConvertInstruction i = (ConvertInstruction)codeElement2;
                    this.pop(1);
                    this.push(i.toType());
                    break;
                }
                case 5: {
                    FieldInstruction i = (FieldInstruction)codeElement2;
                    switch (i.opcode()) {
                        case GETSTATIC: {
                            this.push(TypeKind.fromDescriptor(i.type().stringValue()));
                            break;
                        }
                        case GETFIELD: {
                            this.pop(1);
                            this.push(TypeKind.fromDescriptor(i.type().stringValue()));
                            break;
                        }
                        case PUTSTATIC: {
                            this.pop(1);
                            break;
                        }
                        case PUTFIELD: {
                            this.pop(2);
                        }
                    }
                    break;
                }
                case 6: {
                    InvokeDynamicInstruction i = (InvokeDynamicInstruction)codeElement2;
                    MethodTypeDesc type = i.typeSymbol();
                    this.pop(type.parameterCount());
                    this.push(TypeKind.fromDescriptor(type.returnType().descriptorString()));
                    break;
                }
                case 7: {
                    InvokeInstruction i = (InvokeInstruction)codeElement2;
                    MethodTypeDesc type = i.typeSymbol();
                    this.pop(type.parameterCount());
                    if (i.opcode() != Opcode.INVOKESTATIC) {
                        this.pop(1);
                    }
                    this.push(TypeKind.fromDescriptor(type.returnType().descriptorString()));
                    break;
                }
                case 8: {
                    LoadInstruction i = (LoadInstruction)codeElement2;
                    this.push(i.typeKind());
                    break;
                }
                case 9: {
                    StoreInstruction i = (StoreInstruction)codeElement2;
                    this.pop(1);
                    break;
                }
                case 10: {
                    LookupSwitchInstruction i = (LookupSwitchInstruction)codeElement2;
                    this.map.put(i.defaultTarget(), this.stack);
                    for (SwitchCase c : i.cases()) {
                        this.map.put(c.target(), this.fork());
                    }
                    this.stack = null;
                    break;
                }
                case 11: {
                    MonitorInstruction i = (MonitorInstruction)codeElement2;
                    this.pop(1);
                    break;
                }
                case 12: {
                    NewMultiArrayInstruction i = (NewMultiArrayInstruction)codeElement2;
                    this.pop(i.dimensions());
                    this.push(TypeKind.ReferenceType);
                    break;
                }
                case 13: {
                    NewObjectInstruction i = (NewObjectInstruction)codeElement2;
                    this.push(TypeKind.ReferenceType);
                    break;
                }
                case 14: {
                    NewPrimitiveArrayInstruction i = (NewPrimitiveArrayInstruction)codeElement2;
                    this.pop(1);
                    this.push(TypeKind.ReferenceType);
                    break;
                }
                case 15: {
                    NewReferenceArrayInstruction i = (NewReferenceArrayInstruction)codeElement2;
                    this.pop(1);
                    this.push(TypeKind.ReferenceType);
                    break;
                }
                case 16: {
                    NopInstruction i = (NopInstruction)codeElement2;
                    break;
                }
                case 17: {
                    OperatorInstruction i = (OperatorInstruction)codeElement2;
                    switch (i.opcode()) {
                        case ARRAYLENGTH: 
                        case INEG: 
                        case LNEG: 
                        case FNEG: 
                        case DNEG: {
                            this.pop(1);
                            break;
                        }
                        default: {
                            this.pop(2);
                        }
                    }
                    this.push(i.typeKind());
                    break;
                }
                case 18: {
                    ReturnInstruction i = (ReturnInstruction)codeElement2;
                    this.stack = null;
                    break;
                }
                case 19: {
                    StackInstruction i = (StackInstruction)codeElement2;
                    switch (i.opcode()) {
                        case POP: {
                            this.pop(1);
                            break;
                        }
                        case POP2: {
                            this.withStack(s -> {
                                if (s.pop().slotSize() == 1) {
                                    s.pop();
                                }
                            });
                            break;
                        }
                        case DUP: {
                            this.withStack(s -> {
                                TypeKind v = s.pop();
                                s.push(v);
                                s.push(v);
                            });
                            break;
                        }
                        case DUP2: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                if (v1.slotSize() == 1) {
                                    TypeKind v2 = s.pop();
                                    s.push(v2);
                                    s.push(v1);
                                    s.push(v2);
                                    s.push(v1);
                                } else {
                                    s.push(v1);
                                    s.push(v1);
                                }
                            });
                            break;
                        }
                        case DUP_X1: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                TypeKind v2 = s.pop();
                                s.push(v1);
                                s.push(v2);
                                s.push(v1);
                            });
                            break;
                        }
                        case DUP_X2: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                TypeKind v2 = s.pop();
                                if (v2.slotSize() == 1) {
                                    TypeKind v3 = s.pop();
                                    s.push(v1);
                                    s.push(v3);
                                    s.push(v2);
                                    s.push(v1);
                                } else {
                                    s.push(v1);
                                    s.push(v2);
                                    s.push(v1);
                                }
                            });
                            break;
                        }
                        case DUP2_X1: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                TypeKind v2 = s.pop();
                                if (v1.slotSize() == 1) {
                                    TypeKind v3 = s.pop();
                                    s.push(v2);
                                    s.push(v1);
                                    s.push(v3);
                                    s.push(v2);
                                    s.push(v1);
                                } else {
                                    s.push(v1);
                                    s.push(v2);
                                    s.push(v1);
                                }
                            });
                            break;
                        }
                        case DUP2_X2: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                TypeKind v2 = s.pop();
                                if (v1.slotSize() == 1) {
                                    TypeKind v3 = s.pop();
                                    if (v3.slotSize() == 1) {
                                        TypeKind v4 = s.pop();
                                        s.push(v2);
                                        s.push(v1);
                                        s.push(v4);
                                        s.push(v3);
                                        s.push(v2);
                                        s.push(v1);
                                    } else {
                                        s.push(v2);
                                        s.push(v1);
                                        s.push(v3);
                                        s.push(v2);
                                        s.push(v1);
                                    }
                                } else if (v2.slotSize() == 1) {
                                    TypeKind v3 = s.pop();
                                    s.push(v1);
                                    s.push(v3);
                                    s.push(v2);
                                    s.push(v1);
                                } else {
                                    s.push(v1);
                                    s.push(v2);
                                    s.push(v1);
                                }
                            });
                            break;
                        }
                        case SWAP: {
                            this.withStack(s -> {
                                TypeKind v1 = s.pop();
                                TypeKind v2 = s.pop();
                                s.push(v1);
                                s.push(v2);
                            });
                        }
                    }
                    break;
                }
                case 20: {
                    TableSwitchInstruction i = (TableSwitchInstruction)codeElement2;
                    this.map.put(i.defaultTarget(), this.stack);
                    for (SwitchCase c : i.cases()) {
                        this.map.put(c.target(), this.fork());
                    }
                    this.stack = null;
                    break;
                }
                case 21: {
                    ThrowInstruction i = (ThrowInstruction)codeElement2;
                    this.stack = null;
                    break;
                }
                case 22: {
                    TypeCheckInstruction i = (TypeCheckInstruction)codeElement2;
                    switch (i.opcode()) {
                        case CHECKCAST: {
                            this.pop(1);
                            this.push(TypeKind.ReferenceType);
                            break;
                        }
                        case INSTANCEOF: {
                            this.pop(1);
                            this.push(TypeKind.IntType);
                        }
                    }
                    break;
                }
                case 23: {
                    ExceptionCatch i = (ExceptionCatch)codeElement2;
                    this.map.put(i.handler(), new Stack(new Item(TypeKind.ReferenceType, null), 1, 1));
                    break;
                }
                case 24: {
                    LabelTarget i = (LabelTarget)codeElement2;
                    this.stack = this.map.getOrDefault(i.label(), this.stack);
                    break;
                }
            }
        }

        private final class Stack
        extends AbstractCollection<TypeKind> {
            private Item top;
            private int count;
            private int realSize;

            Stack(Item top, int count, int realSize) {
                this.top = top;
                this.count = count;
                this.realSize = realSize;
            }

            @Override
            public Iterator<TypeKind> iterator() {
                return new Iterator<TypeKind>(){
                    Item i;
                    {
                        this.i = Stack.this.top;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i != null;
                    }

                    @Override
                    public TypeKind next() {
                        if (this.i == null) {
                            throw new NoSuchElementException();
                        }
                        TypeKind t = this.i.type;
                        this.i = this.i.next;
                        return t;
                    }
                };
            }

            @Override
            public int size() {
                return this.count;
            }

            private void push(TypeKind type) {
                this.top = new Item(type, this.top);
                this.realSize += type.slotSize();
                ++this.count;
                if (CodeStackTrackerImpl.this.maxSize != null && this.realSize > CodeStackTrackerImpl.this.maxSize) {
                    CodeStackTrackerImpl.this.maxSize = this.realSize;
                }
            }

            private TypeKind pop() {
                TypeKind t = this.top.type;
                this.realSize -= t.slotSize();
                --this.count;
                this.top = this.top.next;
                return t;
            }
        }

        private record Item(TypeKind type, Item next) {
        }
    }
}

