/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import org.glavo.classfile.BufWriter;
import org.glavo.classfile.Label;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.LabelContext;

public class AbstractBoundLocalVariable
extends AbstractElement {
    protected final CodeImpl code;
    protected final int offset;
    private Utf8Entry nameEntry;
    private Utf8Entry secondaryEntry;

    public AbstractBoundLocalVariable(CodeImpl code, int offset) {
        this.code = code;
        this.offset = offset;
    }

    protected int nameIndex() {
        return this.code.classReader.readU2(this.offset + 4);
    }

    public Utf8Entry name() {
        if (this.nameEntry == null) {
            this.nameEntry = (Utf8Entry)this.code.constantPool().entryByIndex(this.nameIndex());
        }
        return this.nameEntry;
    }

    protected int secondaryIndex() {
        return this.code.classReader.readU2(this.offset + 6);
    }

    protected Utf8Entry secondaryEntry() {
        if (this.secondaryEntry == null) {
            this.secondaryEntry = (Utf8Entry)this.code.constantPool().entryByIndex(this.secondaryIndex());
        }
        return this.secondaryEntry;
    }

    public Label startScope() {
        return this.code.getLabel(this.startPc());
    }

    public Label endScope() {
        return this.code.getLabel(this.startPc() + this.length());
    }

    public int startPc() {
        return this.code.classReader.readU2(this.offset);
    }

    public int length() {
        return this.code.classReader.readU2(this.offset + 2);
    }

    public int slot() {
        return this.code.classReader.readU2(this.offset + 8);
    }

    public boolean writeTo(BufWriter b) {
        LabelContext lc = ((BufWriterImpl)b).labelContext();
        int startBci = lc.labelToBci(this.startScope());
        int endBci = lc.labelToBci(this.endScope());
        if (startBci == -1 || endBci == -1) {
            return false;
        }
        int length = endBci - startBci;
        b.writeU2(startBci);
        b.writeU2(length);
        if (b.canWriteDirect(this.code.constantPool())) {
            b.writeU2(this.nameIndex());
            b.writeU2(this.secondaryIndex());
        } else {
            b.writeIndex(this.name());
            b.writeIndex(this.secondaryEntry());
        }
        b.writeU2(this.slot());
        return true;
    }
}

