/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassTransform;
import org.glavo.classfile.ClassfileElement;
import org.glavo.classfile.ClassfileTransform;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.impl.ChainedClassBuilder;
import org.glavo.classfile.impl.ChainedCodeBuilder;
import org.glavo.classfile.impl.ChainedFieldBuilder;
import org.glavo.classfile.impl.ChainedMethodBuilder;

public class TransformImpl {
    private static final Runnable NOTHING = () -> {};

    private TransformImpl() {
    }

    private static Runnable chainRunnable(Runnable a, Runnable b) {
        return () -> {
            a.run();
            b.run();
        };
    }

    public record SupplierCodeTransform(Supplier<CodeTransform> supplier) implements UnresolvedCodeTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<CodeElement> resolve(CodeBuilder builder) {
            return this.supplier.get().resolve(builder);
        }
    }

    public record ChainedCodeTransform(CodeTransform t, CodeTransform next) implements UnresolvedCodeTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<CodeElement> resolve(CodeBuilder builder) {
            ClassfileTransform.ResolvedTransform<CodeElement> downstream = this.next.resolve(builder);
            ChainedCodeBuilder chainedBuilder = new ChainedCodeBuilder(builder, downstream.consumer());
            ClassfileTransform.ResolvedTransform<CodeElement> upstream = this.t.resolve(chainedBuilder);
            return new ResolvedTransformImpl<CodeElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(upstream.startHandler(), downstream.startHandler()));
        }
    }

    static interface UnresolvedCodeTransform
    extends CodeTransform {
        @Override
        default public void accept(CodeBuilder builder, CodeElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(CodeBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(CodeBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record SupplierFieldTransform(Supplier<FieldTransform> supplier) implements UnresolvedFieldTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<FieldElement> resolve(FieldBuilder builder) {
            return this.supplier.get().resolve(builder);
        }
    }

    public record ChainedFieldTransform(FieldTransform t, FieldTransform next) implements UnresolvedFieldTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<FieldElement> resolve(FieldBuilder builder) {
            ClassfileTransform.ResolvedTransform<FieldElement> downstream = this.next.resolve(builder);
            ChainedFieldBuilder chainedBuilder = new ChainedFieldBuilder(builder, downstream.consumer());
            ClassfileTransform.ResolvedTransform<FieldElement> upstream = this.t.resolve(chainedBuilder);
            return new ResolvedTransformImpl<FieldElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(upstream.startHandler(), downstream.startHandler()));
        }
    }

    static interface UnresolvedFieldTransform
    extends FieldTransform {
        @Override
        default public void accept(FieldBuilder builder, FieldElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(FieldBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(FieldBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record MethodCodeTransform(CodeTransform xform) implements UnresolvedMethodTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            return new ResolvedTransformImpl<MethodElement>(me -> {
                if (me instanceof CodeModel) {
                    CodeModel cm = (CodeModel)me;
                    builder.transformCode(cm, this.xform);
                } else {
                    builder.with(me);
                }
            }, NOTHING, NOTHING);
        }

        @Override
        public MethodTransform andThen(MethodTransform next) {
            MethodTransform methodTransform;
            if (next instanceof MethodCodeTransform) {
                MethodCodeTransform mct = (MethodCodeTransform)next;
                methodTransform = new MethodCodeTransform(this.xform.andThen(mct.xform));
            } else {
                methodTransform = UnresolvedMethodTransform.super.andThen(next);
            }
            return methodTransform;
        }
    }

    public record SupplierMethodTransform(Supplier<MethodTransform> supplier) implements UnresolvedMethodTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            return this.supplier.get().resolve(builder);
        }
    }

    public record ChainedMethodTransform(MethodTransform t, MethodTransform next) implements UnresolvedMethodTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            ClassfileTransform.ResolvedTransform<MethodElement> downstream = this.next.resolve(builder);
            ChainedMethodBuilder chainedBuilder = new ChainedMethodBuilder(builder, downstream.consumer());
            ClassfileTransform.ResolvedTransform<MethodElement> upstream = this.t.resolve(chainedBuilder);
            return new ResolvedTransformImpl<MethodElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(upstream.startHandler(), downstream.startHandler()));
        }
    }

    static interface UnresolvedMethodTransform
    extends MethodTransform {
        @Override
        default public void accept(MethodBuilder builder, MethodElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(MethodBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(MethodBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record ClassFieldTransform(FieldTransform transform, Predicate<FieldModel> filter) implements UnresolvedClassTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return new ResolvedTransformImpl<ClassElement>(ce -> {
                FieldModel fm;
                if (ce instanceof FieldModel && this.filter.test(fm = (FieldModel)ce)) {
                    builder.transformField(fm, this.transform);
                } else {
                    builder.with(ce);
                }
            });
        }

        @Override
        public ClassTransform andThen(ClassTransform next) {
            if (next instanceof ClassFieldTransform) {
                ClassFieldTransform cft = (ClassFieldTransform)next;
                return new ClassFieldTransform(this.transform.andThen(cft.transform), mm -> this.filter.test((FieldModel)mm) && cft.filter.test((FieldModel)mm));
            }
            return UnresolvedClassTransform.super.andThen(next);
        }
    }

    public record ClassMethodTransform(MethodTransform transform, Predicate<MethodModel> filter) implements UnresolvedClassTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return new ResolvedTransformImpl<ClassElement>(ce -> {
                MethodModel mm;
                if (ce instanceof MethodModel && this.filter.test(mm = (MethodModel)ce)) {
                    builder.transformMethod(mm, this.transform);
                } else {
                    builder.with(ce);
                }
            });
        }

        @Override
        public ClassTransform andThen(ClassTransform next) {
            if (next instanceof ClassMethodTransform) {
                ClassMethodTransform cmt = (ClassMethodTransform)next;
                return new ClassMethodTransform(this.transform.andThen(cmt.transform), mm -> this.filter.test((MethodModel)mm) && cmt.filter.test((MethodModel)mm));
            }
            return UnresolvedClassTransform.super.andThen(next);
        }
    }

    public record SupplierClassTransform(Supplier<ClassTransform> supplier) implements UnresolvedClassTransform
    {
        @Override
        public ClassfileTransform.ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return this.supplier.get().resolve(builder);
        }
    }

    public record ChainedClassTransform(ClassTransform t, ClassTransform next) implements UnresolvedClassTransform
    {
        @Override
        public ResolvedTransformImpl<ClassElement> resolve(ClassBuilder builder) {
            ClassfileTransform.ResolvedTransform<ClassElement> downstream = this.next.resolve(builder);
            ChainedClassBuilder chainedBuilder = new ChainedClassBuilder(builder, downstream.consumer());
            ClassfileTransform.ResolvedTransform<ClassElement> upstream = this.t.resolve(chainedBuilder);
            return new ResolvedTransformImpl<ClassElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(upstream.startHandler(), downstream.startHandler()));
        }
    }

    public record ResolvedTransformImpl<E extends ClassfileElement>(Consumer<E> consumer, Runnable endHandler, Runnable startHandler) implements ClassfileTransform.ResolvedTransform<E>
    {
        public ResolvedTransformImpl(Consumer<E> consumer) {
            this(consumer, NOTHING, NOTHING);
        }
    }

    static interface UnresolvedClassTransform
    extends ClassTransform {
        @Override
        default public void accept(ClassBuilder builder, ClassElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(ClassBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(ClassBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }
}

