/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.java.lang.constant.ModuleDesc;
import org.glavo.classfile.jdk.ClassDescUtils;
import org.glavo.classfile.jdk.CollectionUtils;

public class Util {
    private Util() {
    }

    public static String arrayOf(CharSequence s) {
        return "[" + s;
    }

    public static BitSet findParams(String type) {
        BitSet bs = new BitSet();
        if (type.charAt(0) != '(') {
            throw new IllegalArgumentException();
        }
        block4: for (int i = 1; i < type.length(); ++i) {
            switch (type.charAt(i)) {
                case '[': {
                    bs.set(i);
                    while (type.charAt(++i) == '[') {
                    }
                    if (type.charAt(i) != 'L') continue block4;
                    while (type.charAt(++i) != ';') {
                    }
                    continue block4;
                }
                case ')': {
                    break block4;
                }
                default: {
                    bs.set(i);
                    if (type.charAt(i) != 'L') continue block4;
                    while (type.charAt(++i) != ';') {
                    }
                    break block0;
                }
            }
        }
        return bs;
    }

    public static int parameterSlots(String type) {
        BitSet bs = Util.findParams(type);
        int count = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            count += type.charAt(i) == 'J' || type.charAt(i) == 'D' ? 2 : 1;
            i = bs.nextSetBit(i + 1);
        }
        return count;
    }

    public static int[] parseParameterSlots(int flags, String type) {
        BitSet bs = Util.findParams(type);
        int[] result = new int[bs.cardinality()];
        int index = 0;
        int count = (flags & 8) != 0 ? 0 : 1;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            result[index++] = count;
            count += type.charAt(i) == 'J' || type.charAt(i) == 'D' ? 2 : 1;
            i = bs.nextSetBit(i + 1);
        }
        return result;
    }

    public static int maxLocals(int flags, String type) {
        BitSet bs = Util.findParams(type);
        int count = (flags & 8) != 0 ? 0 : 1;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            count += type.charAt(i) == 'J' || type.charAt(i) == 'D' ? 2 : 1;
            i = bs.nextSetBit(i + 1);
        }
        return count;
    }

    public static String toClassString(String desc) {
        return desc.replace('/', '.');
    }

    public static Iterator<String> parameterTypes(final String s) {
        return new Iterator<String>(){
            int ch = 1;

            @Override
            public boolean hasNext() {
                return s.charAt(this.ch) != ')';
            }

            @Override
            public String next() {
                char curr = s.charAt(this.ch);
                switch (curr) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        ++this.ch;
                        return String.valueOf(curr);
                    }
                    case '[': {
                        ++this.ch;
                        return "[" + this.next();
                    }
                    case 'L': {
                        int start = this.ch;
                        while (s.charAt(++this.ch) != ';') {
                        }
                        ++this.ch;
                        return s.substring(start, this.ch);
                    }
                }
                throw new AssertionError((Object)("cannot parse string: " + s));
            }
        };
    }

    public static String returnDescriptor(String s) {
        return s.substring(s.indexOf(41) + 1);
    }

    public static String toInternalName(ClassDesc cd) {
        String desc = cd.descriptorString();
        switch (desc.charAt(0)) {
            case 'L': {
                break;
            }
            default: {
                throw new IllegalArgumentException(desc);
            }
        }
        return desc.substring(1, desc.length() - 1);
    }

    public static ClassDesc toClassDesc(String classInternalNameOrArrayDesc) {
        return classInternalNameOrArrayDesc.charAt(0) == '[' ? ClassDesc.ofDescriptor(classInternalNameOrArrayDesc) : ClassDescUtils.ofInternalName(classInternalNameOrArrayDesc);
    }

    public static <T, U> List<U> mappedList(final List<? extends T> list, final Function<T, U> mapper) {
        return new AbstractList<U>(){

            @Override
            public U get(int index) {
                return mapper.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static List<ClassEntry> entryList(List<? extends ClassDesc> list) {
        Object[] result = new Object[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TemporaryConstantPool.INSTANCE.classEntry(TemporaryConstantPool.INSTANCE.utf8Entry(Util.toInternalName(list.get(i))));
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(result);
    }

    public static List<ModuleEntry> moduleEntryList(List<? extends ModuleDesc> list) {
        Object[] result = new Object[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(list.get(i).moduleName()));
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(result);
    }

    public static void checkKind(Opcode op, Opcode.Kind k) {
        if (op.kind() != k) {
            throw new IllegalArgumentException(String.format("Wrong opcode kind specified; found %s(%s), expected %s", new Object[]{op, op.kind(), k}));
        }
    }

    public static int flagsToBits(AccessFlag.Location location, Collection<AccessFlag> flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static int flagsToBits(AccessFlag.Location location, AccessFlag ... flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static boolean has(AccessFlag.Location location, int flagsMask, AccessFlag flag) {
        return (flag.mask() & flagsMask) == flag.mask() && flag.locations().contains((Object)location);
    }
}

