/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl.verifier;

import java.lang.constant.ClassDesc;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.glavo.classfile.impl.ClassHierarchyImpl;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.impl.verifier.VerificationSignature;
import org.glavo.classfile.impl.verifier.VerifierImpl;

class VerificationType {
    private static final int BitsPerByte = 8;
    static final int ITEM_Top = 0;
    static final int ITEM_Integer = 1;
    static final int ITEM_Float = 2;
    static final int ITEM_Double = 3;
    static final int ITEM_Long = 4;
    static final int ITEM_Null = 5;
    static final int ITEM_UninitializedThis = 6;
    static final int ITEM_Object = 7;
    static final int ITEM_Uninitialized = 8;
    static final int ITEM_Bogus = -1;
    private final int _data;
    private final String _sym;
    private static final Map<VerificationType, String> _constantsMap = new IdentityHashMap<VerificationType, String>(18);
    private static final int ITEM_Boolean = 9;
    private static final int ITEM_Byte = 10;
    private static final int ITEM_Short = 11;
    private static final int ITEM_Char = 12;
    private static final int ITEM_Long_2nd = 13;
    private static final int ITEM_Double_2nd = 14;
    private static final int TypeMask = 3;
    private static final int Reference = 0;
    private static final int Primitive = 1;
    private static final int Uninitialized = 2;
    private static final int TypeQuery = 3;
    private static final int ReferenceFlag = 0;
    private static final int Category1Flag = 1;
    private static final int Category2Flag = 2;
    private static final int Category2_2ndFlag = 4;
    private static final int Null = 0;
    private static final int Category1 = 257;
    private static final int Category2 = 513;
    private static final int Category2_2nd = 1025;
    private static final int Bogus = -65535;
    private static final int Boolean = 590081;
    private static final int Byte = 655617;
    private static final int Short = 721153;
    private static final int Char = 786689;
    private static final int Integer = 65793;
    private static final int Float = 131329;
    private static final int Long = 262657;
    private static final int Double = 197121;
    private static final int Long_2nd = 852993;
    private static final int Double_2nd = 918529;
    private static final int BciMask = 0xFFFF00;
    private static final int BciForThis = 65535;
    private static final int ReferenceQuery = 3;
    private static final int Category1Query = 259;
    private static final int Category2Query = 515;
    private static final int Category2_2ndQuery = 1027;
    static final VerificationType bogus_type = new VerificationType(-65535);
    static final VerificationType null_type = new VerificationType(0);
    static final VerificationType integer_type = new VerificationType(65793);
    static final VerificationType float_type = new VerificationType(131329);
    static final VerificationType long_type = new VerificationType(262657);
    static final VerificationType long2_type = new VerificationType(852993);
    static final VerificationType double_type = new VerificationType(197121);
    static final VerificationType boolean_type = new VerificationType(590081);
    static final VerificationType byte_type = new VerificationType(655617);
    static final VerificationType char_type = new VerificationType(786689);
    static final VerificationType short_type = new VerificationType(721153);
    static final VerificationType double2_type = new VerificationType(918529);
    static final VerificationType reference_check = new VerificationType(3);
    static final VerificationType category1_check = new VerificationType(259);
    static final VerificationType category2_check = new VerificationType(515);
    static final VerificationType uninitialized_this_type = VerificationType.uninitialized_type(65535);

    VerificationType(String sym) {
        this._data = 256;
        this._sym = sym;
    }

    public VerificationType(int data, String sym) {
        this._data = data;
        this._sym = sym;
    }

    public int hashCode() {
        return this._sym == null ? this._data : this._sym.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof VerificationType ? this._data == ((VerificationType)obj)._data && Objects.equals(this._sym, ((VerificationType)obj)._sym) : false;
    }

    public String toString() {
        if (_constantsMap.isEmpty()) {
            for (Field f : VerificationType.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != VerificationType.class) continue;
                try {
                    _constantsMap.put((VerificationType)f.get(null), f.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        if (this._sym != null) {
            return this._sym;
        }
        if ((this._data & 0xFF) == 2) {
            return "uninit@" + (this._data >> 8);
        }
        return _constantsMap.getOrDefault(this, java.lang.Integer.toHexString(this._data));
    }

    String name() {
        return this._sym;
    }

    VerificationType(int raw_data) {
        this._data = raw_data;
        this._sym = null;
    }

    static VerificationType reference_type(String sh) {
        return new VerificationType(sh);
    }

    static VerificationType uninitialized_type(int bci) {
        return new VerificationType(bci << 8 | 2);
    }

    boolean is_bogus() {
        return this._data == -65535;
    }

    boolean is_null() {
        return this._data == 0;
    }

    boolean is_integer() {
        return this._data == 65793;
    }

    boolean is_long() {
        return this._data == 262657;
    }

    boolean is_double() {
        return this._data == 197121;
    }

    boolean is_long2() {
        return this._data == 852993;
    }

    boolean is_double2() {
        return this._data == 918529;
    }

    boolean is_reference() {
        return (this._data & 3) == 0;
    }

    boolean is_category1(VerifierImpl context) {
        if (this.is_check()) {
            context.verifyError("Must not be a check type (wrong value returned)");
        }
        return (this._data & 0x101) != 1;
    }

    boolean is_category2() {
        return (this._data & 0x201) == 513;
    }

    boolean is_category2_2nd() {
        return (this._data & 0x401) == 1025;
    }

    boolean is_check() {
        return (this._data & 3) == 3;
    }

    boolean is_x_array(char sig) {
        return this.is_null() || this.is_array() && this.name().charAt(1) == sig;
    }

    boolean is_int_array() {
        return this.is_x_array('I');
    }

    boolean is_byte_array() {
        return this.is_x_array('B');
    }

    boolean is_bool_array() {
        return this.is_x_array('Z');
    }

    boolean is_char_array() {
        return this.is_x_array('C');
    }

    boolean is_short_array() {
        return this.is_x_array('S');
    }

    boolean is_long_array() {
        return this.is_x_array('J');
    }

    boolean is_float_array() {
        return this.is_x_array('F');
    }

    boolean is_double_array() {
        return this.is_x_array('D');
    }

    boolean is_object_array() {
        return this.is_x_array('L');
    }

    boolean is_array_array() {
        return this.is_x_array('[');
    }

    boolean is_reference_array() {
        return this.is_object_array() || this.is_array_array();
    }

    boolean is_object() {
        return this.is_reference() && !this.is_null() && this.name().length() >= 1 && this.name().charAt(0) != '[';
    }

    boolean is_array() {
        return this.is_reference() && !this.is_null() && this.name().length() >= 2 && this.name().charAt(0) == '[';
    }

    boolean is_uninitialized() {
        return (this._data & 2) == 2;
    }

    boolean is_uninitialized_this(VerifierImpl context) {
        return this.is_uninitialized() && this.bci(context) == 65535;
    }

    VerificationType to_category2_2nd(VerifierImpl context) {
        if (!this.is_category2()) {
            context.verifyError("Must be a double word");
        }
        return this.is_long() ? long2_type : double2_type;
    }

    int bci(VerifierImpl context) {
        if (!this.is_uninitialized()) {
            context.verifyError("Must be uninitialized type");
        }
        return (this._data & 0xFFFF00) >> 8;
    }

    boolean is_assignable_from(VerificationType from, VerifierImpl context) {
        boolean ret = this._is_assignable_from(from, context);
        context.errorContext = ret ? "" : String.format("(%s is not assignable from %s)", this, from);
        return ret;
    }

    private boolean _is_assignable_from(VerificationType from, VerifierImpl context) {
        if (this.equals(from) || this.is_bogus()) {
            return true;
        }
        switch (this._data) {
            case 259: {
                return from.is_category1(context);
            }
            case 515: {
                return from.is_category2();
            }
            case 1027: {
                return from.is_category2_2nd();
            }
            case 3: {
                return from.is_reference() || from.is_uninitialized();
            }
            case 590081: 
            case 655617: 
            case 721153: 
            case 786689: {
                return from.is_integer();
            }
        }
        if (this.is_reference() && from.is_reference()) {
            return this.is_reference_assignable_from(from, context);
        }
        return false;
    }

    boolean is_component_assignable_from(VerificationType from, VerifierImpl context) {
        if (this.equals(from) || this.is_bogus()) {
            return true;
        }
        switch (this._data) {
            case 590081: 
            case 655617: 
            case 721153: 
            case 786689: {
                return false;
            }
        }
        return this.is_assignable_from(from, context);
    }

    int dimensions(VerifierImpl context) {
        if (!this.is_array()) {
            context.verifyError("Must be an array");
        }
        int index = 0;
        while (this.name().charAt(index) == '[') {
            ++index;
        }
        return index;
    }

    static VerificationType from_tag(int tag, VerifierImpl context) {
        switch (tag) {
            case 0: {
                return bogus_type;
            }
            case 1: {
                return integer_type;
            }
            case 2: {
                return float_type;
            }
            case 3: {
                return double_type;
            }
            case 4: {
                return long_type;
            }
            case 5: {
                return null_type;
            }
        }
        context.verifyError("Should not reach here");
        return bogus_type;
    }

    boolean resolve_and_check_assignability(ClassHierarchyImpl assignResolver, String name, String from_name, boolean from_is_array, boolean from_is_object) {
        ClassDesc desc = Util.toClassDesc(name);
        if (assignResolver.isInterface(desc)) {
            return !from_is_array || "java/lang/Cloneable".equals(name) || "java/io/Serializable".equals(name);
        }
        if (from_is_object) {
            return assignResolver.isAssignableFrom(desc, Util.toClassDesc(from_name));
        }
        return false;
    }

    boolean is_reference_assignable_from(VerificationType from, VerifierImpl context) {
        ClassHierarchyImpl clsTree = context.class_hierarchy();
        if (from.is_null()) {
            return true;
        }
        if (this.is_null()) {
            return false;
        }
        if (this.name().equals(from.name())) {
            return true;
        }
        if (this.is_object()) {
            if ("java/lang/Object".equals(this.name())) {
                return true;
            }
            return this.resolve_and_check_assignability(clsTree, this.name(), from.name(), from.is_array(), from.is_object());
        }
        if (this.is_array() && from.is_array()) {
            VerificationType comp_this = this.get_component(context);
            VerificationType comp_from = from.get_component(context);
            if (!comp_this.is_bogus() && !comp_from.is_bogus()) {
                return comp_this.is_component_assignable_from(comp_from, context);
            }
        }
        return false;
    }

    VerificationType get_component(VerifierImpl context) {
        if (!this.is_array() || this.name().length() < 2) {
            context.verifyError("Must be a valid array");
        }
        VerificationSignature ss = new VerificationSignature(this.name(), false, context);
        ss.skipArrayPrefix(1);
        switch (ss.type()) {
            case T_BOOLEAN: {
                return boolean_type;
            }
            case T_BYTE: {
                return byte_type;
            }
            case T_CHAR: {
                return char_type;
            }
            case T_SHORT: {
                return short_type;
            }
            case T_INT: {
                return integer_type;
            }
            case T_LONG: {
                return long_type;
            }
            case T_FLOAT: {
                return float_type;
            }
            case T_DOUBLE: {
                return double_type;
            }
            case T_ARRAY: 
            case T_OBJECT: {
                if (!ss.isReference()) {
                    context.verifyError("Unchecked verifier input");
                }
                String component = ss.asSymbol();
                return VerificationType.reference_type(component);
            }
        }
        return bogus_type;
    }
}

