/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import java.lang.constant.MethodTypeDesc;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InvokeInstruction
extends Instruction {
    public MemberRefEntry method();

    public boolean isInterface();

    public int count();

    default public ClassEntry owner() {
        return this.method().owner();
    }

    default public Utf8Entry name() {
        return this.method().nameAndType().name();
    }

    default public Utf8Entry type() {
        return this.method().nameAndType().type();
    }

    default public MethodTypeDesc typeSymbol() {
        return MethodTypeDesc.ofDescriptor(this.type().stringValue());
    }

    public static InvokeInstruction of(Opcode op, MemberRefEntry method) {
        Util.checkKind(op, Opcode.Kind.INVOKE);
        return new AbstractInstruction.UnboundInvokeInstruction(op, method);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, Utf8Entry name, Utf8Entry type, boolean isInterface) {
        return InvokeInstruction.of(op, owner, TemporaryConstantPool.INSTANCE.nameAndTypeEntry(name, type), isInterface);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, NameAndTypeEntry nameAndType, boolean isInterface) {
        return InvokeInstruction.of(op, isInterface ? TemporaryConstantPool.INSTANCE.interfaceMethodRefEntry(owner, nameAndType) : TemporaryConstantPool.INSTANCE.methodRefEntry(owner, nameAndType));
    }
}

