/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.AttributedElement;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.attribute.AnnotationDefaultAttribute;
import org.glavo.classfile.attribute.BootstrapMethodsAttribute;
import org.glavo.classfile.attribute.CharacterRangeInfo;
import org.glavo.classfile.attribute.CharacterRangeTableAttribute;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.attribute.CompilationIDAttribute;
import org.glavo.classfile.attribute.ConstantValueAttribute;
import org.glavo.classfile.attribute.DeprecatedAttribute;
import org.glavo.classfile.attribute.EnclosingMethodAttribute;
import org.glavo.classfile.attribute.ExceptionsAttribute;
import org.glavo.classfile.attribute.InnerClassInfo;
import org.glavo.classfile.attribute.InnerClassesAttribute;
import org.glavo.classfile.attribute.LineNumberInfo;
import org.glavo.classfile.attribute.LineNumberTableAttribute;
import org.glavo.classfile.attribute.LocalVariableInfo;
import org.glavo.classfile.attribute.LocalVariableTableAttribute;
import org.glavo.classfile.attribute.LocalVariableTypeInfo;
import org.glavo.classfile.attribute.LocalVariableTypeTableAttribute;
import org.glavo.classfile.attribute.MethodParameterInfo;
import org.glavo.classfile.attribute.MethodParametersAttribute;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.attribute.ModuleExportInfo;
import org.glavo.classfile.attribute.ModuleHashInfo;
import org.glavo.classfile.attribute.ModuleHashesAttribute;
import org.glavo.classfile.attribute.ModuleMainClassAttribute;
import org.glavo.classfile.attribute.ModuleOpenInfo;
import org.glavo.classfile.attribute.ModulePackagesAttribute;
import org.glavo.classfile.attribute.ModuleProvideInfo;
import org.glavo.classfile.attribute.ModuleRequireInfo;
import org.glavo.classfile.attribute.ModuleResolutionAttribute;
import org.glavo.classfile.attribute.ModuleTargetAttribute;
import org.glavo.classfile.attribute.NestHostAttribute;
import org.glavo.classfile.attribute.NestMembersAttribute;
import org.glavo.classfile.attribute.PermittedSubclassesAttribute;
import org.glavo.classfile.attribute.RecordAttribute;
import org.glavo.classfile.attribute.RecordComponentInfo;
import org.glavo.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.SignatureAttribute;
import org.glavo.classfile.attribute.SourceDebugExtensionAttribute;
import org.glavo.classfile.attribute.SourceFileAttribute;
import org.glavo.classfile.attribute.SourceIDAttribute;
import org.glavo.classfile.attribute.StackMapTableAttribute;
import org.glavo.classfile.attribute.SyntheticAttribute;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractAttributeMapper;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.StackMapDecoder;

public class Attributes {
    public static final String NAME_ANNOTATION_DEFAULT = "AnnotationDefault";
    public static final String NAME_BOOTSTRAP_METHODS = "BootstrapMethods";
    public static final String NAME_CHARACTER_RANGE_TABLE = "CharacterRangeTable";
    public static final String NAME_CODE = "Code";
    public static final String NAME_COMPILATION_ID = "CompilationID";
    public static final String NAME_CONSTANT_VALUE = "ConstantValue";
    public static final String NAME_DEPRECATED = "Deprecated";
    public static final String NAME_ENCLOSING_METHOD = "EnclosingMethod";
    public static final String NAME_EXCEPTIONS = "Exceptions";
    public static final String NAME_INNER_CLASSES = "InnerClasses";
    public static final String NAME_LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String NAME_LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String NAME_LOCAL_VARIABLE_TYPE_TABLE = "LocalVariableTypeTable";
    public static final String NAME_METHOD_PARAMETERS = "MethodParameters";
    public static final String NAME_MODULE = "Module";
    public static final String NAME_MODULE_HASHES = "ModuleHashes";
    public static final String NAME_MODULE_MAIN_CLASS = "ModuleMainClass";
    public static final String NAME_MODULE_PACKAGES = "ModulePackages";
    public static final String NAME_MODULE_RESOLUTION = "ModuleResolution";
    public static final String NAME_MODULE_TARGET = "ModuleTarget";
    public static final String NAME_NEST_HOST = "NestHost";
    public static final String NAME_NEST_MEMBERS = "NestMembers";
    public static final String NAME_PERMITTED_SUBCLASSES = "PermittedSubclasses";
    public static final String NAME_RECORD = "Record";
    public static final String NAME_RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    public static final String NAME_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
    public static final String NAME_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
    public static final String NAME_RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String NAME_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
    public static final String NAME_RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
    public static final String NAME_SIGNATURE = "Signature";
    public static final String NAME_SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
    public static final String NAME_SOURCE_FILE = "SourceFile";
    public static final String NAME_SOURCE_ID = "SourceID";
    public static final String NAME_STACK_MAP_TABLE = "StackMapTable";
    public static final String NAME_SYNTHETIC = "Synthetic";
    public static final AttributeMapper<AnnotationDefaultAttribute> ANNOTATION_DEFAULT = new AbstractAttributeMapper<AnnotationDefaultAttribute>("AnnotationDefault", 49){

        @Override
        public AnnotationDefaultAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundAnnotationDefaultAttr(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, AnnotationDefaultAttribute attr) {
            attr.defaultValue().writeTo(buf);
        }
    };
    public static final AttributeMapper<BootstrapMethodsAttribute> BOOTSTRAP_METHODS = new AbstractAttributeMapper<BootstrapMethodsAttribute>("BootstrapMethods", 61){

        @Override
        public BootstrapMethodsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundBootstrapMethodsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, BootstrapMethodsAttribute attr) {
            buf.writeList(attr.bootstrapMethods());
        }
    };
    public static final AttributeMapper<CharacterRangeTableAttribute> CHARACTER_RANGE_TABLE = new AbstractAttributeMapper<CharacterRangeTableAttribute>("CharacterRangeTable", true, 48){

        @Override
        public CharacterRangeTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundCharacterRangeTableAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, CharacterRangeTableAttribute attr) {
            List<CharacterRangeInfo> ranges = attr.characterRangeTable();
            buf.writeU2(ranges.size());
            for (CharacterRangeInfo info : ranges) {
                buf.writeU2(info.startPc());
                buf.writeU2(info.endPc());
                buf.writeInt(info.characterRangeStart());
                buf.writeInt(info.characterRangeEnd());
                buf.writeU2(info.flags());
            }
        }
    };
    public static final AttributeMapper<CodeAttribute> CODE = new AbstractAttributeMapper<CodeAttribute>("Code"){

        @Override
        public CodeAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new CodeImpl(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, CodeAttribute attr) {
            throw new UnsupportedOperationException("Code attribute does not support direct write");
        }
    };
    public static final AttributeMapper<CompilationIDAttribute> COMPILATION_ID = new AbstractAttributeMapper<CompilationIDAttribute>("CompilationID", true){

        @Override
        public CompilationIDAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundCompilationIDAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, CompilationIDAttribute attr) {
            buf.writeIndex(attr.compilationId());
        }
    };
    public static final AttributeMapper<ConstantValueAttribute> CONSTANT_VALUE = new AbstractAttributeMapper<ConstantValueAttribute>("ConstantValue"){

        @Override
        public ConstantValueAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundConstantValueAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ConstantValueAttribute attr) {
            buf.writeIndex(attr.constant());
        }
    };
    public static final AttributeMapper<DeprecatedAttribute> DEPRECATED = new AbstractAttributeMapper<DeprecatedAttribute>("Deprecated", true){

        @Override
        public DeprecatedAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundDeprecatedAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, DeprecatedAttribute attr) {
        }
    };
    public static final AttributeMapper<EnclosingMethodAttribute> ENCLOSING_METHOD = new AbstractAttributeMapper<EnclosingMethodAttribute>("EnclosingMethod", 49){

        @Override
        public EnclosingMethodAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundEnclosingMethodAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, EnclosingMethodAttribute attr) {
            buf.writeIndex(attr.enclosingClass());
            buf.writeIndexOrZero(attr.enclosingMethod().orElse(null));
        }
    };
    public static final AttributeMapper<ExceptionsAttribute> EXCEPTIONS = new AbstractAttributeMapper<ExceptionsAttribute>("Exceptions"){

        @Override
        public ExceptionsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundExceptionsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ExceptionsAttribute attr) {
            buf.writeListIndices(attr.exceptions());
        }
    };
    public static final AttributeMapper<InnerClassesAttribute> INNER_CLASSES = new AbstractAttributeMapper<InnerClassesAttribute>("InnerClasses"){

        @Override
        public InnerClassesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundInnerClassesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, InnerClassesAttribute attr) {
            List<InnerClassInfo> classes = attr.classes();
            buf.writeU2(classes.size());
            for (InnerClassInfo ic : classes) {
                buf.writeIndex(ic.innerClass());
                buf.writeIndexOrZero(ic.outerClass().orElse(null));
                buf.writeIndexOrZero(ic.innerName().orElse(null));
                buf.writeU2(ic.flagsMask());
            }
        }
    };
    public static final AttributeMapper<LineNumberTableAttribute> LINE_NUMBER_TABLE = new AbstractAttributeMapper<LineNumberTableAttribute>("LineNumberTable", true){

        @Override
        public LineNumberTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLineNumberTableAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, LineNumberTableAttribute attr) {
            List<LineNumberInfo> lines = attr.lineNumbers();
            buf.writeU2(lines.size());
            for (LineNumberInfo line : lines) {
                buf.writeU2(line.startPc());
                buf.writeU2(line.lineNumber());
            }
        }
    };
    public static final AttributeMapper<LocalVariableTableAttribute> LOCAL_VARIABLE_TABLE = new AbstractAttributeMapper<LocalVariableTableAttribute>("LocalVariableTable", true){

        @Override
        public LocalVariableTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLocalVariableTableAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, LocalVariableTableAttribute attr) {
            List<LocalVariableInfo> infos = attr.localVariables();
            buf.writeU2(infos.size());
            for (LocalVariableInfo info : infos) {
                buf.writeU2(info.startPc());
                buf.writeU2(info.length());
                buf.writeIndex(info.name());
                buf.writeIndex(info.type());
                buf.writeU2(info.slot());
            }
        }
    };
    public static final AttributeMapper<LocalVariableTypeTableAttribute> LOCAL_VARIABLE_TYPE_TABLE = new AbstractAttributeMapper<LocalVariableTypeTableAttribute>("LocalVariableTypeTable", true, 49){

        @Override
        public LocalVariableTypeTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLocalVariableTypeTableAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, LocalVariableTypeTableAttribute attr) {
            List<LocalVariableTypeInfo> infos = attr.localVariableTypes();
            buf.writeU2(infos.size());
            for (LocalVariableTypeInfo info : infos) {
                buf.writeU2(info.startPc());
                buf.writeU2(info.length());
                buf.writeIndex(info.name());
                buf.writeIndex(info.signature());
                buf.writeU2(info.slot());
            }
        }
    };
    public static final AttributeMapper<MethodParametersAttribute> METHOD_PARAMETERS = new AbstractAttributeMapper<MethodParametersAttribute>("MethodParameters", 52){

        @Override
        public MethodParametersAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundMethodParametersAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, MethodParametersAttribute attr) {
            List<MethodParameterInfo> parameters = attr.parameters();
            buf.writeU1(parameters.size());
            for (MethodParameterInfo info : parameters) {
                buf.writeIndexOrZero(info.name().orElse(null));
                buf.writeU2(info.flagsMask());
            }
        }
    };
    public static final AttributeMapper<ModuleAttribute> MODULE = new AbstractAttributeMapper<ModuleAttribute>("Module", 53){

        @Override
        public ModuleAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleAttribute attr) {
            buf.writeIndex(attr.moduleName());
            buf.writeU2(attr.moduleFlagsMask());
            buf.writeIndexOrZero(attr.moduleVersion().orElse(null));
            buf.writeU2(attr.requires().size());
            for (ModuleRequireInfo require : attr.requires()) {
                buf.writeIndex(require.requires());
                buf.writeU2(require.requiresFlagsMask());
                buf.writeIndexOrZero(require.requiresVersion().orElse(null));
            }
            buf.writeU2(attr.exports().size());
            for (ModuleExportInfo export : attr.exports()) {
                buf.writeIndex(export.exportedPackage());
                buf.writeU2(export.exportsFlagsMask());
                buf.writeListIndices(export.exportsTo());
            }
            buf.writeU2(attr.opens().size());
            for (ModuleOpenInfo open : attr.opens()) {
                buf.writeIndex(open.openedPackage());
                buf.writeU2(open.opensFlagsMask());
                buf.writeListIndices(open.opensTo());
            }
            buf.writeListIndices(attr.uses());
            buf.writeU2(attr.provides().size());
            for (ModuleProvideInfo provide : attr.provides()) {
                buf.writeIndex(provide.provides());
                buf.writeListIndices(provide.providesWith());
            }
        }
    };
    public static final AttributeMapper<ModuleHashesAttribute> MODULE_HASHES = new AbstractAttributeMapper<ModuleHashesAttribute>("ModuleHashes", 53){

        @Override
        public ModuleHashesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleHashesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleHashesAttribute attr) {
            buf.writeIndex(attr.algorithm());
            List<ModuleHashInfo> hashes = attr.hashes();
            buf.writeU2(hashes.size());
            for (ModuleHashInfo hash : hashes) {
                buf.writeIndex(hash.moduleName());
                buf.writeU2(hash.hash().length);
                buf.writeBytes(hash.hash());
            }
        }
    };
    public static final AttributeMapper<ModuleMainClassAttribute> MODULE_MAIN_CLASS = new AbstractAttributeMapper<ModuleMainClassAttribute>("ModuleMainClass", 53){

        @Override
        public ModuleMainClassAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleMainClassAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleMainClassAttribute attr) {
            buf.writeIndex(attr.mainClass());
        }
    };
    public static final AttributeMapper<ModulePackagesAttribute> MODULE_PACKAGES = new AbstractAttributeMapper<ModulePackagesAttribute>("ModulePackages", 53){

        @Override
        public ModulePackagesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModulePackagesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModulePackagesAttribute attr) {
            buf.writeListIndices(attr.packages());
        }
    };
    public static final AttributeMapper<ModuleResolutionAttribute> MODULE_RESOLUTION = new AbstractAttributeMapper<ModuleResolutionAttribute>("ModuleResolution", true, 53){

        @Override
        public ModuleResolutionAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleResolutionAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleResolutionAttribute attr) {
            buf.writeU2(attr.resolutionFlags());
        }
    };
    public static final AttributeMapper<ModuleTargetAttribute> MODULE_TARGET = new AbstractAttributeMapper<ModuleTargetAttribute>("ModuleTarget", true, 53){

        @Override
        public ModuleTargetAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleTargetAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleTargetAttribute attr) {
            buf.writeIndex(attr.targetPlatform());
        }
    };
    public static final AttributeMapper<NestHostAttribute> NEST_HOST = new AbstractAttributeMapper<NestHostAttribute>("NestHost", 55){

        @Override
        public NestHostAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundNestHostAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, NestHostAttribute attr) {
            buf.writeIndex(attr.nestHost());
        }
    };
    public static final AttributeMapper<NestMembersAttribute> NEST_MEMBERS = new AbstractAttributeMapper<NestMembersAttribute>("NestMembers", 55){

        @Override
        public NestMembersAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundNestMembersAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, NestMembersAttribute attr) {
            buf.writeListIndices(attr.nestMembers());
        }
    };
    public static final AttributeMapper<PermittedSubclassesAttribute> PERMITTED_SUBCLASSES = new AbstractAttributeMapper<PermittedSubclassesAttribute>("PermittedSubclasses", 59){

        @Override
        public PermittedSubclassesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundPermittedSubclassesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, PermittedSubclassesAttribute attr) {
            buf.writeListIndices(attr.permittedSubclasses());
        }
    };
    public static final AttributeMapper<RecordAttribute> RECORD = new AbstractAttributeMapper<RecordAttribute>("Record", 60){

        @Override
        public RecordAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRecordAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RecordAttribute attr) {
            List<RecordComponentInfo> components = attr.components();
            buf.writeU2(components.size());
            for (RecordComponentInfo info : components) {
                buf.writeIndex(info.name());
                buf.writeIndex(info.descriptor());
                buf.writeList(info.attributes());
            }
        }
    };
    public static final AttributeMapper<RuntimeInvisibleAnnotationsAttribute> RUNTIME_INVISIBLE_ANNOTATIONS = new AbstractAttributeMapper<RuntimeInvisibleAnnotationsAttribute>("RuntimeInvisibleAnnotations", 49){

        @Override
        public RuntimeInvisibleAnnotationsAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
            return new BoundAttribute.BoundRuntimeInvisibleAnnotationsAttribute(cf, pos);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleAnnotationsAttribute attr) {
            buf.writeList(attr.annotations());
        }
    };
    public static final AttributeMapper<RuntimeInvisibleParameterAnnotationsAttribute> RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = new AbstractAttributeMapper<RuntimeInvisibleParameterAnnotationsAttribute>("RuntimeInvisibleParameterAnnotations", 49){

        @Override
        public RuntimeInvisibleParameterAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeInvisibleParameterAnnotationsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleParameterAnnotationsAttribute attr) {
            List<List<Annotation>> lists = attr.parameterAnnotations();
            buf.writeU1(lists.size());
            for (List<Annotation> list : lists) {
                buf.writeList(list);
            }
        }
    };
    public static final AttributeMapper<RuntimeInvisibleTypeAnnotationsAttribute> RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = new AbstractAttributeMapper<RuntimeInvisibleTypeAnnotationsAttribute>("RuntimeInvisibleTypeAnnotations", 52){

        @Override
        public RuntimeInvisibleTypeAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeInvisibleTypeAnnotationsAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleTypeAnnotationsAttribute attr) {
            buf.writeList(attr.annotations());
        }
    };
    public static final AttributeMapper<RuntimeVisibleAnnotationsAttribute> RUNTIME_VISIBLE_ANNOTATIONS = new AbstractAttributeMapper<RuntimeVisibleAnnotationsAttribute>("RuntimeVisibleAnnotations", 49){

        @Override
        public RuntimeVisibleAnnotationsAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
            return new BoundAttribute.BoundRuntimeVisibleAnnotationsAttribute(cf, pos);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleAnnotationsAttribute attr) {
            buf.writeList(attr.annotations());
        }
    };
    public static final AttributeMapper<RuntimeVisibleParameterAnnotationsAttribute> RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = new AbstractAttributeMapper<RuntimeVisibleParameterAnnotationsAttribute>("RuntimeVisibleParameterAnnotations", 49){

        @Override
        public RuntimeVisibleParameterAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeVisibleParameterAnnotationsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleParameterAnnotationsAttribute attr) {
            List<List<Annotation>> lists = attr.parameterAnnotations();
            buf.writeU1(lists.size());
            for (List<Annotation> list : lists) {
                buf.writeList(list);
            }
        }
    };
    public static final AttributeMapper<RuntimeVisibleTypeAnnotationsAttribute> RUNTIME_VISIBLE_TYPE_ANNOTATIONS = new AbstractAttributeMapper<RuntimeVisibleTypeAnnotationsAttribute>("RuntimeVisibleTypeAnnotations", 52){

        @Override
        public RuntimeVisibleTypeAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeVisibleTypeAnnotationsAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleTypeAnnotationsAttribute attr) {
            buf.writeList(attr.annotations());
        }
    };
    public static final AttributeMapper<SignatureAttribute> SIGNATURE = new AbstractAttributeMapper<SignatureAttribute>("Signature", 49){

        @Override
        public SignatureAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSignatureAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SignatureAttribute attr) {
            buf.writeIndex(attr.signature());
        }
    };
    public static final AttributeMapper<SourceDebugExtensionAttribute> SOURCE_DEBUG_EXTENSION = new AbstractAttributeMapper<SourceDebugExtensionAttribute>("SourceDebugExtension", 49){

        @Override
        public SourceDebugExtensionAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceDebugExtensionAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceDebugExtensionAttribute attr) {
            buf.writeBytes(attr.contents());
        }
    };
    public static final AttributeMapper<SourceFileAttribute> SOURCE_FILE = new AbstractAttributeMapper<SourceFileAttribute>("SourceFile"){

        @Override
        public SourceFileAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceFileAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceFileAttribute attr) {
            buf.writeIndex(attr.sourceFile());
        }
    };
    public static final AttributeMapper<SourceIDAttribute> SOURCE_ID = new AbstractAttributeMapper<SourceIDAttribute>("SourceID"){

        @Override
        public SourceIDAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceIDAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceIDAttribute attr) {
            buf.writeIndex(attr.sourceId());
        }
    };
    public static final AttributeMapper<StackMapTableAttribute> STACK_MAP_TABLE = new AbstractAttributeMapper<StackMapTableAttribute>("StackMapTable", 50){

        @Override
        public StackMapTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundStackMapTableAttribute((CodeImpl)e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter b, StackMapTableAttribute attr) {
            StackMapDecoder.writeFrames(b, attr.entries());
        }
    };
    public static final AttributeMapper<SyntheticAttribute> SYNTHETIC = new AbstractAttributeMapper<SyntheticAttribute>("Synthetic"){

        @Override
        public SyntheticAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSyntheticAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SyntheticAttribute attr) {
        }
    };
    public static final Set<AttributeMapper<?>> PREDEFINED_ATTRIBUTES = Set.of(ANNOTATION_DEFAULT, BOOTSTRAP_METHODS, CHARACTER_RANGE_TABLE, CODE, COMPILATION_ID, CONSTANT_VALUE, DEPRECATED, ENCLOSING_METHOD, EXCEPTIONS, INNER_CLASSES, LINE_NUMBER_TABLE, LOCAL_VARIABLE_TABLE, LOCAL_VARIABLE_TYPE_TABLE, METHOD_PARAMETERS, MODULE, MODULE_HASHES, MODULE_MAIN_CLASS, MODULE_PACKAGES, MODULE_RESOLUTION, MODULE_TARGET, NEST_HOST, NEST_MEMBERS, PERMITTED_SUBCLASSES, RECORD, RUNTIME_INVISIBLE_ANNOTATIONS, RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS, RUNTIME_INVISIBLE_TYPE_ANNOTATIONS, RUNTIME_VISIBLE_ANNOTATIONS, RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, RUNTIME_VISIBLE_TYPE_ANNOTATIONS, SIGNATURE, SOURCE_DEBUG_EXTENSION, SOURCE_FILE, SOURCE_ID, STACK_MAP_TABLE, SYNTHETIC);
    private static final Map<Utf8Entry, AttributeMapper<?>> _ATTR_MAP;

    private Attributes() {
    }

    public static AttributeMapper<?> standardAttribute(Utf8Entry name) {
        return _ATTR_MAP.get(name);
    }

    static {
        HashMap map = new HashMap(64);
        for (AttributeMapper<?> am : PREDEFINED_ATTRIBUTES) {
            map.put(AbstractPoolEntry.rawUtf8EntryFromStandardAttributeName(am.name()), am);
        }
        _ATTR_MAP = Collections.unmodifiableMap(map);
    }
}

