/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.io.InputStream;
import java.lang.constant.ClassDesc;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.glavo.classfile.impl.ClassHierarchyImpl;
import org.glavo.classfile.impl.Util;

@FunctionalInterface
public interface ClassHierarchyResolver {
    public static final ClassHierarchyResolver DEFAULT_CLASS_HIERARCHY_RESOLVER = new ClassHierarchyImpl.CachedClassHierarchyResolver(new Function<ClassDesc, InputStream>(){

        @Override
        public InputStream apply(ClassDesc classDesc) {
            return ClassLoader.getSystemResourceAsStream(Util.toInternalName(classDesc) + ".class");
        }
    });

    public ClassHierarchyInfo getClassInfo(ClassDesc var1);

    default public ClassHierarchyResolver orElse(final ClassHierarchyResolver other) {
        return new ClassHierarchyResolver(){

            @Override
            public ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
                ClassHierarchyInfo chi = ClassHierarchyResolver.this.getClassInfo(classDesc);
                if (chi == null) {
                    chi = other.getClassInfo(classDesc);
                }
                return chi;
            }
        };
    }

    public static ClassHierarchyResolver ofCached(Function<ClassDesc, InputStream> classStreamResolver) {
        return new ClassHierarchyImpl.CachedClassHierarchyResolver(classStreamResolver);
    }

    public static ClassHierarchyResolver of(Collection<ClassDesc> interfaces, Map<ClassDesc, ClassDesc> classToSuperClass) {
        return new ClassHierarchyImpl.StaticClassHierarchyResolver(interfaces, classToSuperClass);
    }

    public record ClassHierarchyInfo(ClassDesc thisClass, boolean isInterface, ClassDesc superClass) {
    }
}

