/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.io.IOException;
import java.lang.constant.ClassDesc;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassHierarchyResolver;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.ClassImpl;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.Options;
import org.glavo.classfile.impl.SplitConstantPool;

public class Classfile {
    public static final int MAGIC_NUMBER = -889275714;
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int LDC_W = 19;
    public static final int LDC2_W = 20;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int INVOKEDYNAMIC = 186;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int WIDE = 196;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int GOTO_W = 200;
    public static final int JSR_W = 201;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_SUPER = 32;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_MODULE = 32768;
    public static final int ACC_OPEN = 32;
    public static final int ACC_MANDATED = 32768;
    public static final int ACC_TRANSITIVE = 32;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int CRT_STATEMENT = 1;
    public static final int CRT_BLOCK = 2;
    public static final int CRT_ASSIGNMENT = 4;
    public static final int CRT_FLOW_CONTROLLER = 8;
    public static final int CRT_FLOW_TARGET = 16;
    public static final int CRT_INVOKE = 32;
    public static final int CRT_CREATE = 64;
    public static final int CRT_BRANCH_TRUE = 128;
    public static final int CRT_BRANCH_FALSE = 256;
    public static final int TAG_CLASS = 7;
    public static final int TAG_CONSTANTDYNAMIC = 17;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_FIELDREF = 9;
    public static final int TAG_FLOAT = 4;
    public static final int TAG_INTEGER = 3;
    public static final int TAG_INTERFACEMETHODREF = 11;
    public static final int TAG_INVOKEDYNAMIC = 18;
    public static final int TAG_LONG = 5;
    public static final int TAG_METHODHANDLE = 15;
    public static final int TAG_METHODREF = 10;
    public static final int TAG_METHODTYPE = 16;
    public static final int TAG_MODULE = 19;
    public static final int TAG_NAMEANDTYPE = 12;
    public static final int TAG_PACKAGE = 20;
    public static final int TAG_STRING = 8;
    public static final int TAG_UNICODE = 2;
    public static final int TAG_UTF8 = 1;
    public static final int TAT_CLASS_TYPE_PARAMETER = 0;
    public static final int TAT_METHOD_TYPE_PARAMETER = 1;
    public static final int TAT_CLASS_EXTENDS = 16;
    public static final int TAT_CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int TAT_METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int TAT_FIELD = 19;
    public static final int TAT_METHOD_RETURN = 20;
    public static final int TAT_METHOD_RECEIVER = 21;
    public static final int TAT_METHOD_FORMAL_PARAMETER = 22;
    public static final int TAT_THROWS = 23;
    public static final int TAT_LOCAL_VARIABLE = 64;
    public static final int TAT_RESOURCE_VARIABLE = 65;
    public static final int TAT_EXCEPTION_PARAMETER = 66;
    public static final int TAT_INSTANCEOF = 67;
    public static final int TAT_NEW = 68;
    public static final int TAT_CONSTRUCTOR_REFERENCE = 69;
    public static final int TAT_METHOD_REFERENCE = 70;
    public static final int TAT_CAST = 71;
    public static final int TAT_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    public static final int TAT_METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    public static final int TAT_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    public static final int TAT_METHOD_REFERENCE_TYPE_ARGUMENT = 75;
    public static final int VT_TOP = 0;
    public static final int VT_INTEGER = 1;
    public static final int VT_FLOAT = 2;
    public static final int VT_DOUBLE = 3;
    public static final int VT_LONG = 4;
    public static final int VT_NULL = 5;
    public static final int VT_UNINITIALIZED_THIS = 6;
    public static final int VT_OBJECT = 7;
    public static final int VT_UNINITIALIZED = 8;
    public static final int DEFAULT_CLASS_FLAGS = 1;
    public static final int JAVA_1_VERSION = 45;
    public static final int JAVA_2_VERSION = 46;
    public static final int JAVA_3_VERSION = 47;
    public static final int JAVA_4_VERSION = 48;
    public static final int JAVA_5_VERSION = 49;
    public static final int JAVA_6_VERSION = 50;
    public static final int JAVA_7_VERSION = 51;
    public static final int JAVA_8_VERSION = 52;
    public static final int JAVA_9_VERSION = 53;
    public static final int JAVA_10_VERSION = 54;
    public static final int JAVA_11_VERSION = 55;
    public static final int JAVA_12_VERSION = 56;
    public static final int JAVA_13_VERSION = 57;
    public static final int JAVA_14_VERSION = 58;
    public static final int JAVA_15_VERSION = 59;
    public static final int JAVA_16_VERSION = 60;
    public static final int JAVA_17_VERSION = 61;
    public static final int JAVA_18_VERSION = 62;
    public static final int JAVA_19_VERSION = 63;
    public static final int JAVA_20_VERSION = 64;
    public static final int JAVA_21_VERSION = 65;
    public static final int LATEST_MAJOR_VERSION = 65;
    public static final int LATEST_MINOR_VERSION = 0;
    public static final int PREVIEW_MINOR_VERSION = -1;

    private Classfile() {
    }

    public static ClassModel parse(byte[] bytes, Option ... options) {
        List<Option> os = options == null || options.length == 0 ? Collections.emptyList() : List.of(options);
        return new ClassImpl(bytes, os);
    }

    public static ClassModel parse(Path path, Option ... options) throws IOException {
        return Classfile.parse(Files.readAllBytes(path), options);
    }

    public static byte[] build(ClassDesc thisClass, Consumer<ClassBuilder> handler) {
        return Classfile.build(thisClass, Collections.emptySet(), handler);
    }

    public static byte[] build(ClassDesc thisClass, Collection<Option> options, Consumer<? super ClassBuilder> handler) {
        ConstantPoolBuilder pool = ConstantPoolBuilder.of(options);
        return Classfile.build(pool.classEntry(thisClass), pool, handler);
    }

    public static byte[] build(ClassEntry thisClassEntry, ConstantPoolBuilder constantPool, Consumer<? super ClassBuilder> handler) {
        thisClassEntry = AbstractPoolEntry.maybeClone(constantPool, thisClassEntry);
        DirectClassBuilder builder = new DirectClassBuilder((SplitConstantPool)constantPool, thisClassEntry);
        handler.accept(builder);
        return builder.build();
    }

    public static void buildTo(Path path, ClassDesc thisClass, Consumer<ClassBuilder> handler) throws IOException {
        Files.write(path, Classfile.build(thisClass, Collections.emptySet(), handler), new OpenOption[0]);
    }

    public static void buildTo(Path path, ClassDesc thisClass, Collection<Option> options, Consumer<? super ClassBuilder> handler) throws IOException {
        Files.write(path, Classfile.build(thisClass, options, handler), new OpenOption[0]);
    }

    public static byte[] buildModule(ModuleAttribute moduleAttribute) {
        return Classfile.buildModule(moduleAttribute, clb -> {});
    }

    public static byte[] buildModule(ModuleAttribute moduleAttribute, Consumer<? super ClassBuilder> handler) {
        return Classfile.build(ClassDesc.of("module-info"), clb -> {
            clb.withFlags(AccessFlag.MODULE);
            clb.with(moduleAttribute);
            handler.accept((ClassBuilder)clb);
        });
    }

    public static void buildModuleTo(Path path, ModuleAttribute moduleAttribute) throws IOException {
        Classfile.buildModuleTo(path, moduleAttribute, clb -> {});
    }

    public static void buildModuleTo(Path path, ModuleAttribute moduleAttribute, Consumer<? super ClassBuilder> handler) throws IOException {
        Files.write(path, Classfile.buildModule(moduleAttribute, handler), new OpenOption[0]);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Option {
        public static Option generateStackmap(boolean b) {
            return new Options.OptionValue(Options.Key.GENERATE_STACK_MAPS, b);
        }

        public static Option processDebug(boolean b) {
            return new Options.OptionValue(Options.Key.PROCESS_DEBUG, b);
        }

        public static Option processLineNumbers(boolean b) {
            return new Options.OptionValue(Options.Key.PROCESS_LINE_NUMBERS, b);
        }

        public static Option processUnknownAttributes(boolean b) {
            return new Options.OptionValue(Options.Key.PROCESS_UNKNOWN_ATTRIBUTES, b);
        }

        public static Option constantPoolSharing(boolean b) {
            return new Options.OptionValue(Options.Key.CP_SHARING, b);
        }

        public static Option fixShortJumps(boolean b) {
            return new Options.OptionValue(Options.Key.FIX_SHORT_JUMPS, b);
        }

        public static Option patchDeadCode(boolean b) {
            return new Options.OptionValue(Options.Key.PATCH_DEAD_CODE, b);
        }

        public static Option classHierarchyResolver(ClassHierarchyResolver r) {
            return new Options.OptionValue(Options.Key.HIERARCHY_RESOLVER, r);
        }

        public static Option attributeMapper(Function<Utf8Entry, AttributeMapper<?>> r) {
            return new Options.OptionValue(Options.Key.ATTRIBUTE_MAPPER, r);
        }

        public static Option filterDeadLabels(boolean b) {
            return new Options.OptionValue(Options.Key.FILTER_DEAD_LABELS, b);
        }
    }
}

