/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.ClassfileBuilder;
import org.glavo.classfile.ClassfileTransform;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.Signature;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.MethodRefEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.BlockCodeBuilderImpl;
import org.glavo.classfile.impl.BytecodeHelpers;
import org.glavo.classfile.impl.CatchBuilderImpl;
import org.glavo.classfile.impl.LabelImpl;
import org.glavo.classfile.impl.TransformingCodeBuilder;
import org.glavo.classfile.instruction.ArrayLoadInstruction;
import org.glavo.classfile.instruction.ArrayStoreInstruction;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.CharacterRange;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.ConvertInstruction;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LineNumber;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.MonitorInstruction;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewPrimitiveArrayInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.NopInstruction;
import org.glavo.classfile.instruction.OperatorInstruction;
import org.glavo.classfile.instruction.ReturnInstruction;
import org.glavo.classfile.instruction.StackInstruction;
import org.glavo.classfile.instruction.StoreInstruction;
import org.glavo.classfile.instruction.SwitchCase;
import org.glavo.classfile.instruction.TableSwitchInstruction;
import org.glavo.classfile.instruction.ThrowInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeBuilder
extends ClassfileBuilder<CodeElement, CodeBuilder> {
    public Optional<CodeModel> original();

    public Label newLabel();

    public Label startLabel();

    public Label endLabel();

    public int receiverSlot();

    public int parameterSlot(int var1);

    public int allocateLocal(TypeKind var1);

    default public CodeBuilder transforming(CodeTransform transform, Consumer<CodeBuilder> handler) {
        ClassfileTransform.ResolvedTransform<CodeElement> resolved = transform.resolve(this);
        resolved.startHandler().run();
        handler.accept(new TransformingCodeBuilder(this, resolved.consumer()));
        resolved.endHandler().run();
        return this;
    }

    default public CodeBuilder block(Consumer<BlockCodeBuilder> handler) {
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl child = new BlockCodeBuilderImpl(this, breakLabel);
        child.start();
        handler.accept(child);
        child.end();
        this.labelBinding(breakLabel);
        return this;
    }

    default public CodeBuilder ifThen(Consumer<BlockCodeBuilder> thenHandler) {
        return this.ifThen(Opcode.IFNE, thenHandler);
    }

    default public CodeBuilder ifThen(Opcode opcode, Consumer<BlockCodeBuilder> thenHandler) {
        if (opcode.kind() != Opcode.Kind.BRANCH || opcode.primaryTypeKind() == TypeKind.VoidType) {
            throw new IllegalArgumentException("Illegal branch opcode: " + opcode);
        }
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl thenBlock = new BlockCodeBuilderImpl(this, breakLabel);
        this.branchInstruction(BytecodeHelpers.reverseBranchOpcode(opcode), thenBlock.endLabel());
        thenBlock.start();
        thenHandler.accept(thenBlock);
        thenBlock.end();
        this.labelBinding(breakLabel);
        return this;
    }

    default public CodeBuilder ifThenElse(Consumer<BlockCodeBuilder> thenHandler, Consumer<BlockCodeBuilder> elseHandler) {
        return this.ifThenElse(Opcode.IFNE, thenHandler, elseHandler);
    }

    default public CodeBuilder ifThenElse(Opcode opcode, Consumer<BlockCodeBuilder> thenHandler, Consumer<BlockCodeBuilder> elseHandler) {
        if (opcode.kind() != Opcode.Kind.BRANCH || opcode.primaryTypeKind() == TypeKind.VoidType) {
            throw new IllegalArgumentException("Illegal branch opcode: " + opcode);
        }
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl thenBlock = new BlockCodeBuilderImpl(this, breakLabel);
        BlockCodeBuilderImpl elseBlock = new BlockCodeBuilderImpl(this, breakLabel);
        this.branchInstruction(BytecodeHelpers.reverseBranchOpcode(opcode), elseBlock.startLabel());
        thenBlock.start();
        thenHandler.accept(thenBlock);
        if (thenBlock.reachable()) {
            thenBlock.branchInstruction(Opcode.GOTO, thenBlock.breakLabel());
        }
        thenBlock.end();
        elseBlock.start();
        elseHandler.accept(elseBlock);
        elseBlock.end();
        this.labelBinding(breakLabel);
        return this;
    }

    default public CodeBuilder trying(Consumer<BlockCodeBuilder> tryHandler, Consumer<CatchBuilder> catchesHandler) {
        Label tryCatchEnd = this.newLabel();
        BlockCodeBuilderImpl tryBlock = new BlockCodeBuilderImpl(this, tryCatchEnd);
        tryBlock.start();
        tryHandler.accept(tryBlock);
        tryBlock.end();
        if (tryBlock.isEmpty()) {
            throw new IllegalStateException("The body of the try block is empty");
        }
        CatchBuilderImpl catchBuilder = new CatchBuilderImpl(this, tryBlock, tryCatchEnd);
        catchesHandler.accept(catchBuilder);
        catchBuilder.finish();
        return this;
    }

    default public CodeBuilder loadInstruction(TypeKind tk, int slot) {
        this.with(LoadInstruction.of(tk, slot));
        return this;
    }

    default public CodeBuilder storeInstruction(TypeKind tk, int slot) {
        this.with(StoreInstruction.of(tk, slot));
        return this;
    }

    default public CodeBuilder incrementInstruction(int slot, int val) {
        this.with(IncrementInstruction.of(slot, val));
        return this;
    }

    default public CodeBuilder branchInstruction(Opcode op, Label target) {
        this.with(BranchInstruction.of(op, target));
        return this;
    }

    default public CodeBuilder lookupSwitchInstruction(Label defaultTarget, List<SwitchCase> cases) {
        this.with(LookupSwitchInstruction.of(defaultTarget, cases));
        return this;
    }

    default public CodeBuilder tableSwitchInstruction(int lowValue, int highValue, Label defaultTarget, List<SwitchCase> cases) {
        this.with(TableSwitchInstruction.of(lowValue, highValue, defaultTarget, cases));
        return this;
    }

    default public CodeBuilder returnInstruction(TypeKind tk) {
        this.with(ReturnInstruction.of(tk));
        return this;
    }

    default public CodeBuilder throwInstruction() {
        this.with(ThrowInstruction.of());
        return this;
    }

    default public CodeBuilder fieldInstruction(Opcode opcode, FieldRefEntry ref) {
        this.with(FieldInstruction.of(opcode, ref));
        return this;
    }

    default public CodeBuilder fieldInstruction(Opcode opcode, ClassDesc owner, String name, ClassDesc type) {
        return this.fieldInstruction(opcode, this.constantPool().fieldRefEntry(owner, name, type));
    }

    default public CodeBuilder invokeInstruction(Opcode opcode, MemberRefEntry ref) {
        return (CodeBuilder)this.with(InvokeInstruction.of(opcode, ref));
    }

    default public CodeBuilder invokeInstruction(Opcode opcode, ClassDesc owner, String name, MethodTypeDesc desc, boolean isInterface) {
        return this.invokeInstruction(opcode, isInterface ? this.constantPool().interfaceMethodRefEntry(owner, name, desc) : this.constantPool().methodRefEntry(owner, name, desc));
    }

    default public CodeBuilder invokeDynamicInstruction(InvokeDynamicEntry ref) {
        this.with(InvokeDynamicInstruction.of(ref));
        return this;
    }

    default public CodeBuilder invokeDynamicInstruction(DynamicCallSiteDesc desc) {
        MethodHandleEntry bsMethod = BytecodeHelpers.handleDescToHandleInfo(this.constantPool(), (DirectMethodHandleDesc)desc.bootstrapMethod());
        ConstantDesc[] cpArgs = desc.bootstrapArgs();
        ArrayList<LoadableConstantEntry> bsArguments = new ArrayList<LoadableConstantEntry>(cpArgs.length);
        for (ConstantDesc constantValue : cpArgs) {
            bsArguments.add(BytecodeHelpers.constantEntry(this.constantPool(), constantValue));
        }
        BootstrapMethodEntry bm = this.constantPool().bsmEntry(bsMethod, bsArguments);
        NameAndTypeEntry nameAndType = this.constantPool().nameAndTypeEntry(desc.invocationName(), desc.invocationType());
        this.invokeDynamicInstruction(this.constantPool().invokeDynamicEntry(bm, nameAndType));
        return this;
    }

    default public CodeBuilder newObjectInstruction(ClassEntry type) {
        this.with(NewObjectInstruction.of(type));
        return this;
    }

    default public CodeBuilder newObjectInstruction(ClassDesc type) {
        return this.newObjectInstruction(this.constantPool().classEntry(type));
    }

    default public CodeBuilder newPrimitiveArrayInstruction(TypeKind typeKind) {
        this.with(NewPrimitiveArrayInstruction.of(typeKind));
        return this;
    }

    default public CodeBuilder newReferenceArrayInstruction(ClassEntry type) {
        this.with(NewReferenceArrayInstruction.of(type));
        return this;
    }

    default public CodeBuilder newReferenceArrayInstruction(ClassDesc type) {
        return this.newReferenceArrayInstruction(this.constantPool().classEntry(type));
    }

    default public CodeBuilder newMultidimensionalArrayInstruction(int dimensions, ClassEntry type) {
        this.with(NewMultiArrayInstruction.of(type, dimensions));
        return this;
    }

    default public CodeBuilder newMultidimensionalArrayInstruction(int dimensions, ClassDesc type) {
        return this.newMultidimensionalArrayInstruction(dimensions, this.constantPool().classEntry(type));
    }

    default public CodeBuilder arrayLoadInstruction(TypeKind tk) {
        Opcode opcode = BytecodeHelpers.arrayLoadOpcode(tk);
        this.with(ArrayLoadInstruction.of(opcode));
        return this;
    }

    default public CodeBuilder arrayStoreInstruction(TypeKind tk) {
        Opcode opcode = BytecodeHelpers.arrayStoreOpcode(tk);
        this.with(ArrayStoreInstruction.of(opcode));
        return this;
    }

    default public CodeBuilder typeCheckInstruction(Opcode opcode, ClassEntry type) {
        this.with(TypeCheckInstruction.of(opcode, type));
        return this;
    }

    default public CodeBuilder typeCheckInstruction(Opcode opcode, ClassDesc type) {
        return this.typeCheckInstruction(opcode, this.constantPool().classEntry(type));
    }

    default public CodeBuilder convertInstruction(TypeKind fromType, TypeKind toType) {
        this.with(ConvertInstruction.of(fromType, toType));
        return this;
    }

    default public CodeBuilder stackInstruction(Opcode opcode) {
        this.with(StackInstruction.of(opcode));
        return this;
    }

    default public CodeBuilder operatorInstruction(Opcode opcode) {
        this.with(OperatorInstruction.of(opcode));
        return this;
    }

    default public CodeBuilder constantInstruction(Opcode opcode, ConstantDesc value) {
        BytecodeHelpers.validateValue(opcode, value);
        return (CodeBuilder)this.with(switch (opcode) {
            case Opcode.SIPUSH, Opcode.BIPUSH -> ConstantInstruction.ofArgument(opcode, ((Number)((Object)value)).intValue());
            case Opcode.LDC, Opcode.LDC_W, Opcode.LDC2_W -> ConstantInstruction.ofLoad(opcode, BytecodeHelpers.constantEntry(this.constantPool(), value));
            default -> ConstantInstruction.ofIntrinsic(opcode);
        });
    }

    default public CodeBuilder constantInstruction(ConstantDesc value) {
        if (value == null || value == ConstantDescs.NULL) {
            return this.aconst_null();
        }
        if (value instanceof Integer) {
            Integer iVal = (Integer)value;
            return switch (iVal) {
                case -1 -> this.iconst_m1();
                case 0 -> this.iconst_0();
                case 1 -> this.iconst_1();
                case 2 -> this.iconst_2();
                case 3 -> this.iconst_3();
                case 4 -> this.iconst_4();
                case 5 -> this.iconst_5();
                default -> iVal >= -128 && iVal <= 127 ? this.bipush(iVal) : (iVal >= Short.MIN_VALUE && iVal <= Short.MAX_VALUE ? this.sipush(iVal) : this.ldc(this.constantPool().intEntry(iVal)));
            };
        }
        if (value instanceof Long) {
            Long lVal = (Long)value;
            return lVal == 0L ? this.lconst_0() : (lVal == 1L ? this.lconst_1() : this.ldc(this.constantPool().longEntry(lVal)));
        }
        if (value instanceof Float) {
            Float fVal = (Float)value;
            return Float.floatToRawIntBits(fVal.floatValue()) == 0 ? this.fconst_0() : (fVal.floatValue() == 1.0f ? this.fconst_1() : (fVal.floatValue() == 2.0f ? this.fconst_2() : this.ldc(this.constantPool().floatEntry(fVal.floatValue()))));
        }
        if (value instanceof Double) {
            Double dVal = (Double)value;
            return Double.doubleToRawLongBits(dVal) == 0L ? this.dconst_0() : (dVal == 1.0 ? this.dconst_1() : this.ldc(this.constantPool().doubleEntry(dVal)));
        }
        return this.ldc(BytecodeHelpers.constantEntry(this.constantPool(), value));
    }

    default public CodeBuilder monitorInstruction(Opcode opcode) {
        this.with(MonitorInstruction.of(opcode));
        return null;
    }

    default public CodeBuilder nopInstruction() {
        this.with(NopInstruction.of());
        return this;
    }

    default public CodeBuilder nop() {
        return this.nopInstruction();
    }

    default public Label newBoundLabel() {
        Label label = this.newLabel();
        this.labelBinding(label);
        return label;
    }

    default public CodeBuilder labelBinding(Label label) {
        this.with((LabelImpl)label);
        return this;
    }

    default public CodeBuilder lineNumber(int line) {
        this.with(LineNumber.of(line));
        return this;
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, ClassEntry catchType) {
        this.with(ExceptionCatch.of(handler, start, end, Optional.of(catchType)));
        return this;
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, Optional<ClassEntry> catchType) {
        this.with(ExceptionCatch.of(handler, start, end, catchType));
        return this;
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, ClassDesc catchType) {
        Objects.requireNonNull(catchType);
        return this.exceptionCatch(start, end, handler, this.constantPool().classEntry(catchType));
    }

    default public CodeBuilder exceptionCatchAll(Label start, Label end, Label handler) {
        this.with(ExceptionCatch.of(handler, start, end));
        return this;
    }

    default public CodeBuilder characterRange(Label startScope, Label endScope, int characterRangeStart, int characterRangeEnd, int flags) {
        this.with(CharacterRange.of(startScope, endScope, characterRangeStart, characterRangeEnd, flags));
        return this;
    }

    default public CodeBuilder localVariable(int slot, Utf8Entry nameEntry, Utf8Entry descriptorEntry, Label startScope, Label endScope) {
        this.with(LocalVariable.of(slot, nameEntry, descriptorEntry, startScope, endScope));
        return this;
    }

    default public CodeBuilder localVariable(int slot, String name, ClassDesc descriptor, Label startScope, Label endScope) {
        return this.localVariable(slot, this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor.descriptorString()), startScope, endScope);
    }

    default public CodeBuilder localVariableType(int slot, Utf8Entry nameEntry, Utf8Entry signatureEntry, Label startScope, Label endScope) {
        this.with(LocalVariableType.of(slot, nameEntry, signatureEntry, startScope, endScope));
        return this;
    }

    default public CodeBuilder localVariableType(int slot, String name, Signature signature, Label startScope, Label endScope) {
        return this.localVariableType(slot, this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(signature.signatureString()), startScope, endScope);
    }

    default public CodeBuilder aconst_null() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ACONST_NULL));
    }

    default public CodeBuilder aaload() {
        return this.arrayLoadInstruction(TypeKind.ReferenceType);
    }

    default public CodeBuilder aastore() {
        return this.arrayStoreInstruction(TypeKind.ReferenceType);
    }

    default public CodeBuilder aload(int slot) {
        return this.loadInstruction(TypeKind.ReferenceType, slot);
    }

    default public CodeBuilder anewarray(ClassEntry classEntry) {
        return this.newReferenceArrayInstruction(classEntry);
    }

    default public CodeBuilder anewarray(ClassDesc className) {
        return this.newReferenceArrayInstruction(this.constantPool().classEntry(className));
    }

    default public CodeBuilder areturn() {
        return this.returnInstruction(TypeKind.ReferenceType);
    }

    default public CodeBuilder arraylength() {
        return this.operatorInstruction(Opcode.ARRAYLENGTH);
    }

    default public CodeBuilder astore(int slot) {
        return this.storeInstruction(TypeKind.ReferenceType, slot);
    }

    default public CodeBuilder athrow() {
        return this.throwInstruction();
    }

    default public CodeBuilder baload() {
        return this.arrayLoadInstruction(TypeKind.ByteType);
    }

    default public CodeBuilder bastore() {
        return this.arrayStoreInstruction(TypeKind.ByteType);
    }

    default public CodeBuilder bipush(int b) {
        return this.constantInstruction(Opcode.BIPUSH, Integer.valueOf(b));
    }

    default public CodeBuilder caload() {
        return this.arrayLoadInstruction(TypeKind.CharType);
    }

    default public CodeBuilder castore() {
        return this.arrayStoreInstruction(TypeKind.CharType);
    }

    default public CodeBuilder checkcast(ClassEntry type) {
        return this.typeCheckInstruction(Opcode.CHECKCAST, type);
    }

    default public CodeBuilder checkcast(ClassDesc type) {
        return this.typeCheckInstruction(Opcode.CHECKCAST, type);
    }

    default public CodeBuilder d2f() {
        return this.convertInstruction(TypeKind.DoubleType, TypeKind.FloatType);
    }

    default public CodeBuilder d2i() {
        return this.convertInstruction(TypeKind.DoubleType, TypeKind.IntType);
    }

    default public CodeBuilder d2l() {
        return this.convertInstruction(TypeKind.DoubleType, TypeKind.LongType);
    }

    default public CodeBuilder dadd() {
        return this.operatorInstruction(Opcode.DADD);
    }

    default public CodeBuilder daload() {
        return this.arrayLoadInstruction(TypeKind.DoubleType);
    }

    default public CodeBuilder dastore() {
        return this.arrayStoreInstruction(TypeKind.DoubleType);
    }

    default public CodeBuilder dcmpg() {
        return this.operatorInstruction(Opcode.DCMPG);
    }

    default public CodeBuilder dcmpl() {
        return this.operatorInstruction(Opcode.DCMPL);
    }

    default public CodeBuilder dconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.DCONST_0));
    }

    default public CodeBuilder dconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.DCONST_1));
    }

    default public CodeBuilder ddiv() {
        return this.operatorInstruction(Opcode.DDIV);
    }

    default public CodeBuilder dload(int slot) {
        return this.loadInstruction(TypeKind.DoubleType, slot);
    }

    default public CodeBuilder dmul() {
        return this.operatorInstruction(Opcode.DMUL);
    }

    default public CodeBuilder dneg() {
        return this.operatorInstruction(Opcode.DNEG);
    }

    default public CodeBuilder drem() {
        return this.operatorInstruction(Opcode.DREM);
    }

    default public CodeBuilder dreturn() {
        return this.returnInstruction(TypeKind.DoubleType);
    }

    default public CodeBuilder dstore(int slot) {
        return this.storeInstruction(TypeKind.DoubleType, slot);
    }

    default public CodeBuilder dsub() {
        return this.operatorInstruction(Opcode.DSUB);
    }

    default public CodeBuilder dup() {
        return this.stackInstruction(Opcode.DUP);
    }

    default public CodeBuilder dup2() {
        return this.stackInstruction(Opcode.DUP2);
    }

    default public CodeBuilder dup2_x1() {
        return this.stackInstruction(Opcode.DUP2_X1);
    }

    default public CodeBuilder dup2_x2() {
        return this.stackInstruction(Opcode.DUP2_X2);
    }

    default public CodeBuilder dup_x1() {
        return this.stackInstruction(Opcode.DUP_X1);
    }

    default public CodeBuilder dup_x2() {
        return this.stackInstruction(Opcode.DUP_X2);
    }

    default public CodeBuilder f2d() {
        return this.convertInstruction(TypeKind.FloatType, TypeKind.DoubleType);
    }

    default public CodeBuilder f2i() {
        return this.convertInstruction(TypeKind.FloatType, TypeKind.IntType);
    }

    default public CodeBuilder f2l() {
        return this.convertInstruction(TypeKind.FloatType, TypeKind.LongType);
    }

    default public CodeBuilder fadd() {
        return this.operatorInstruction(Opcode.FADD);
    }

    default public CodeBuilder faload() {
        return this.arrayLoadInstruction(TypeKind.FloatType);
    }

    default public CodeBuilder fastore() {
        return this.arrayStoreInstruction(TypeKind.FloatType);
    }

    default public CodeBuilder fcmpg() {
        return this.operatorInstruction(Opcode.FCMPG);
    }

    default public CodeBuilder fcmpl() {
        return this.operatorInstruction(Opcode.FCMPL);
    }

    default public CodeBuilder fconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_0));
    }

    default public CodeBuilder fconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_1));
    }

    default public CodeBuilder fconst_2() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_2));
    }

    default public CodeBuilder fdiv() {
        return this.operatorInstruction(Opcode.FDIV);
    }

    default public CodeBuilder fload(int slot) {
        return this.loadInstruction(TypeKind.FloatType, slot);
    }

    default public CodeBuilder fmul() {
        return this.operatorInstruction(Opcode.FMUL);
    }

    default public CodeBuilder fneg() {
        return this.operatorInstruction(Opcode.FNEG);
    }

    default public CodeBuilder frem() {
        return this.operatorInstruction(Opcode.FREM);
    }

    default public CodeBuilder freturn() {
        return this.returnInstruction(TypeKind.FloatType);
    }

    default public CodeBuilder fstore(int slot) {
        return this.storeInstruction(TypeKind.FloatType, slot);
    }

    default public CodeBuilder fsub() {
        return this.operatorInstruction(Opcode.FSUB);
    }

    default public CodeBuilder getfield(FieldRefEntry ref) {
        return this.fieldInstruction(Opcode.GETFIELD, ref);
    }

    default public CodeBuilder getfield(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldInstruction(Opcode.GETFIELD, owner, name, type);
    }

    default public CodeBuilder getstatic(FieldRefEntry ref) {
        return this.fieldInstruction(Opcode.GETSTATIC, ref);
    }

    default public CodeBuilder getstatic(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldInstruction(Opcode.GETSTATIC, owner, name, type);
    }

    default public CodeBuilder goto_(Label target) {
        return this.branchInstruction(Opcode.GOTO, target);
    }

    default public CodeBuilder goto_w(Label target) {
        return this.branchInstruction(Opcode.GOTO_W, target);
    }

    default public CodeBuilder i2b() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.ByteType);
    }

    default public CodeBuilder i2c() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.CharType);
    }

    default public CodeBuilder i2d() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.DoubleType);
    }

    default public CodeBuilder i2f() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.FloatType);
    }

    default public CodeBuilder i2l() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.LongType);
    }

    default public CodeBuilder i2s() {
        return this.convertInstruction(TypeKind.IntType, TypeKind.ShortType);
    }

    default public CodeBuilder iadd() {
        return this.operatorInstruction(Opcode.IADD);
    }

    default public CodeBuilder iaload() {
        return this.arrayLoadInstruction(TypeKind.IntType);
    }

    default public CodeBuilder iand() {
        return this.operatorInstruction(Opcode.IAND);
    }

    default public CodeBuilder iastore() {
        return this.arrayStoreInstruction(TypeKind.IntType);
    }

    default public CodeBuilder iconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_0));
    }

    default public CodeBuilder iconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_1));
    }

    default public CodeBuilder iconst_2() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_2));
    }

    default public CodeBuilder iconst_3() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_3));
    }

    default public CodeBuilder iconst_4() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_4));
    }

    default public CodeBuilder iconst_5() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_5));
    }

    default public CodeBuilder iconst_m1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_M1));
    }

    default public CodeBuilder idiv() {
        return this.operatorInstruction(Opcode.IDIV);
    }

    default public CodeBuilder if_acmpeq(Label target) {
        return this.branchInstruction(Opcode.IF_ACMPEQ, target);
    }

    default public CodeBuilder if_acmpne(Label target) {
        return this.branchInstruction(Opcode.IF_ACMPNE, target);
    }

    default public CodeBuilder if_icmpeq(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPEQ, target);
    }

    default public CodeBuilder if_icmpge(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPGE, target);
    }

    default public CodeBuilder if_icmpgt(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPGT, target);
    }

    default public CodeBuilder if_icmple(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPLE, target);
    }

    default public CodeBuilder if_icmplt(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPLT, target);
    }

    default public CodeBuilder if_icmpne(Label target) {
        return this.branchInstruction(Opcode.IF_ICMPNE, target);
    }

    default public CodeBuilder if_nonnull(Label target) {
        return this.branchInstruction(Opcode.IFNONNULL, target);
    }

    default public CodeBuilder if_null(Label target) {
        return this.branchInstruction(Opcode.IFNULL, target);
    }

    default public CodeBuilder ifeq(Label target) {
        return this.branchInstruction(Opcode.IFEQ, target);
    }

    default public CodeBuilder ifge(Label target) {
        return this.branchInstruction(Opcode.IFGE, target);
    }

    default public CodeBuilder ifgt(Label target) {
        return this.branchInstruction(Opcode.IFGT, target);
    }

    default public CodeBuilder ifle(Label target) {
        return this.branchInstruction(Opcode.IFLE, target);
    }

    default public CodeBuilder iflt(Label target) {
        return this.branchInstruction(Opcode.IFLT, target);
    }

    default public CodeBuilder ifne(Label target) {
        return this.branchInstruction(Opcode.IFNE, target);
    }

    default public CodeBuilder iinc(int slot, int val) {
        return this.incrementInstruction(slot, val);
    }

    default public CodeBuilder iload(int slot) {
        return this.loadInstruction(TypeKind.IntType, slot);
    }

    default public CodeBuilder imul() {
        return this.operatorInstruction(Opcode.IMUL);
    }

    default public CodeBuilder ineg() {
        return this.operatorInstruction(Opcode.INEG);
    }

    default public CodeBuilder instanceof_(ClassEntry target) {
        return this.typeCheckInstruction(Opcode.INSTANCEOF, target);
    }

    default public CodeBuilder instanceof_(ClassDesc target) {
        return this.typeCheckInstruction(Opcode.INSTANCEOF, this.constantPool().classEntry(target));
    }

    default public CodeBuilder invokedynamic(InvokeDynamicEntry ref) {
        return this.invokeDynamicInstruction(ref);
    }

    default public CodeBuilder invokedynamic(DynamicCallSiteDesc ref) {
        return this.invokeDynamicInstruction(ref);
    }

    default public CodeBuilder invokeinterface(InterfaceMethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKEINTERFACE, ref);
    }

    default public CodeBuilder invokeinterface(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invokeInstruction(Opcode.INVOKEINTERFACE, this.constantPool().interfaceMethodRefEntry(owner, name, type));
    }

    default public CodeBuilder invokespecial(InterfaceMethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKESPECIAL, ref);
    }

    default public CodeBuilder invokespecial(MethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKESPECIAL, ref);
    }

    default public CodeBuilder invokespecial(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invokeInstruction(Opcode.INVOKESPECIAL, owner, name, type, false);
    }

    default public CodeBuilder invokespecial(ClassDesc owner, String name, MethodTypeDesc type, boolean isInterface) {
        return this.invokeInstruction(Opcode.INVOKESPECIAL, owner, name, type, isInterface);
    }

    default public CodeBuilder invokestatic(InterfaceMethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKESTATIC, ref);
    }

    default public CodeBuilder invokestatic(MethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKESTATIC, ref);
    }

    default public CodeBuilder invokestatic(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invokeInstruction(Opcode.INVOKESTATIC, owner, name, type, false);
    }

    default public CodeBuilder invokestatic(ClassDesc owner, String name, MethodTypeDesc type, boolean isInterface) {
        return this.invokeInstruction(Opcode.INVOKESTATIC, owner, name, type, isInterface);
    }

    default public CodeBuilder invokevirtual(MethodRefEntry ref) {
        return this.invokeInstruction(Opcode.INVOKEVIRTUAL, ref);
    }

    default public CodeBuilder invokevirtual(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invokeInstruction(Opcode.INVOKEVIRTUAL, owner, name, type, false);
    }

    default public CodeBuilder ior() {
        return this.operatorInstruction(Opcode.IOR);
    }

    default public CodeBuilder irem() {
        return this.operatorInstruction(Opcode.IREM);
    }

    default public CodeBuilder ireturn() {
        return this.returnInstruction(TypeKind.IntType);
    }

    default public CodeBuilder ishl() {
        return this.operatorInstruction(Opcode.ISHL);
    }

    default public CodeBuilder ishr() {
        return this.operatorInstruction(Opcode.ISHR);
    }

    default public CodeBuilder istore(int slot) {
        return this.storeInstruction(TypeKind.IntType, slot);
    }

    default public CodeBuilder isub() {
        return this.operatorInstruction(Opcode.ISUB);
    }

    default public CodeBuilder iushr() {
        return this.operatorInstruction(Opcode.IUSHR);
    }

    default public CodeBuilder ixor() {
        return this.operatorInstruction(Opcode.IXOR);
    }

    default public CodeBuilder lookupswitch(Label defaultTarget, List<SwitchCase> cases) {
        return this.lookupSwitchInstruction(defaultTarget, cases);
    }

    default public CodeBuilder l2d() {
        return this.convertInstruction(TypeKind.LongType, TypeKind.DoubleType);
    }

    default public CodeBuilder l2f() {
        return this.convertInstruction(TypeKind.LongType, TypeKind.FloatType);
    }

    default public CodeBuilder l2i() {
        return this.convertInstruction(TypeKind.LongType, TypeKind.IntType);
    }

    default public CodeBuilder ladd() {
        return this.operatorInstruction(Opcode.LADD);
    }

    default public CodeBuilder laload() {
        return this.arrayLoadInstruction(TypeKind.LongType);
    }

    default public CodeBuilder land() {
        return this.operatorInstruction(Opcode.LAND);
    }

    default public CodeBuilder lastore() {
        return this.arrayStoreInstruction(TypeKind.LongType);
    }

    default public CodeBuilder lcmp() {
        return this.operatorInstruction(Opcode.LCMP);
    }

    default public CodeBuilder lconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.LCONST_0));
    }

    default public CodeBuilder lconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.LCONST_1));
    }

    default public CodeBuilder ldc(LoadableConstantEntry entry) {
        return (CodeBuilder)this.with(ConstantInstruction.ofLoad(entry.typeKind().slotSize() == 2 ? Opcode.LDC2_W : (entry.index() > 255 ? Opcode.LDC_W : Opcode.LDC), entry));
    }

    default public CodeBuilder ldiv() {
        return this.operatorInstruction(Opcode.LDIV);
    }

    default public CodeBuilder lload(int slot) {
        return this.loadInstruction(TypeKind.LongType, slot);
    }

    default public CodeBuilder lmul() {
        return this.operatorInstruction(Opcode.LMUL);
    }

    default public CodeBuilder lneg() {
        return this.operatorInstruction(Opcode.LNEG);
    }

    default public CodeBuilder lor() {
        return this.operatorInstruction(Opcode.LOR);
    }

    default public CodeBuilder lrem() {
        return this.operatorInstruction(Opcode.LREM);
    }

    default public CodeBuilder lreturn() {
        return this.returnInstruction(TypeKind.LongType);
    }

    default public CodeBuilder lshl() {
        return this.operatorInstruction(Opcode.LSHL);
    }

    default public CodeBuilder lshr() {
        return this.operatorInstruction(Opcode.LSHR);
    }

    default public CodeBuilder lstore(int slot) {
        return this.storeInstruction(TypeKind.LongType, slot);
    }

    default public CodeBuilder lsub() {
        return this.operatorInstruction(Opcode.LSUB);
    }

    default public CodeBuilder lushr() {
        return this.operatorInstruction(Opcode.LUSHR);
    }

    default public CodeBuilder lxor() {
        return this.operatorInstruction(Opcode.LXOR);
    }

    default public CodeBuilder monitorenter() {
        return this.monitorInstruction(Opcode.MONITORENTER);
    }

    default public CodeBuilder monitorexit() {
        return this.monitorInstruction(Opcode.MONITOREXIT);
    }

    default public CodeBuilder multianewarray(ClassEntry array, int dims) {
        return this.newMultidimensionalArrayInstruction(dims, array);
    }

    default public CodeBuilder multianewarray(ClassDesc array, int dims) {
        return this.newMultidimensionalArrayInstruction(dims, this.constantPool().classEntry(array));
    }

    default public CodeBuilder new_(ClassEntry clazz) {
        return this.newObjectInstruction(clazz);
    }

    default public CodeBuilder new_(ClassDesc clazz) {
        return this.newObjectInstruction(this.constantPool().classEntry(clazz));
    }

    default public CodeBuilder newarray(TypeKind typeKind) {
        return this.newPrimitiveArrayInstruction(typeKind);
    }

    default public CodeBuilder pop() {
        return this.stackInstruction(Opcode.POP);
    }

    default public CodeBuilder pop2() {
        return this.stackInstruction(Opcode.POP2);
    }

    default public CodeBuilder putfield(FieldRefEntry ref) {
        return this.fieldInstruction(Opcode.PUTFIELD, ref);
    }

    default public CodeBuilder putfield(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldInstruction(Opcode.PUTFIELD, owner, name, type);
    }

    default public CodeBuilder putstatic(FieldRefEntry ref) {
        return this.fieldInstruction(Opcode.PUTSTATIC, ref);
    }

    default public CodeBuilder putstatic(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldInstruction(Opcode.PUTSTATIC, owner, name, type);
    }

    default public CodeBuilder return_() {
        return this.returnInstruction(TypeKind.VoidType);
    }

    default public CodeBuilder saload() {
        return this.arrayLoadInstruction(TypeKind.ShortType);
    }

    default public CodeBuilder sastore() {
        return this.arrayStoreInstruction(TypeKind.ShortType);
    }

    default public CodeBuilder sipush(int s) {
        return this.constantInstruction(Opcode.SIPUSH, Integer.valueOf(s));
    }

    default public CodeBuilder swap() {
        return this.stackInstruction(Opcode.SWAP);
    }

    default public CodeBuilder tableswitch(int low, int high, Label defaultTarget, List<SwitchCase> cases) {
        return this.tableSwitchInstruction(low, high, defaultTarget, cases);
    }

    default public CodeBuilder tableswitch(Label defaultTarget, List<SwitchCase> cases) {
        int low = Integer.MAX_VALUE;
        int high = Integer.MIN_VALUE;
        for (SwitchCase c : cases) {
            int i = c.caseValue();
            if (i < low) {
                low = i;
            }
            if (i <= high) continue;
            high = i;
        }
        return this.tableSwitchInstruction(low, high, defaultTarget, cases);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CatchBuilder {
        public CatchBuilder catching(ClassDesc var1, Consumer<BlockCodeBuilder> var2);

        public CatchBuilder catchingMulti(List<ClassDesc> var1, Consumer<BlockCodeBuilder> var2);

        public void catchingAll(Consumer<BlockCodeBuilder> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BlockCodeBuilder
    extends CodeBuilder {
        public Label breakLabel();
    }
}

