/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.java.lang.constant.ModuleDesc;
import org.glavo.classfile.java.lang.constant.PackageDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleExportInfo {
    public PackageEntry exportedPackage();

    public int exportsFlagsMask();

    default public Set<AccessFlag> exportsFlags() {
        return AccessFlag.maskToAccessFlags(this.exportsFlagsMask(), AccessFlag.Location.MODULE_EXPORTS);
    }

    public List<ModuleEntry> exportsTo();

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE_EXPORTS, this.exportsFlagsMask(), flag);
    }

    public static ModuleExportInfo of(PackageEntry exports, int exportFlags, List<ModuleEntry> exportsTo) {
        return new UnboundAttribute.UnboundModuleExportInfo(exports, exportFlags, exportsTo);
    }

    public static ModuleExportInfo of(PackageEntry exports, Collection<AccessFlag> exportFlags, List<ModuleEntry> exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageEntry exports, int exportFlags, ModuleEntry ... exportsTo) {
        return ModuleExportInfo.of(exports, exportFlags, List.of(exportsTo));
    }

    public static ModuleExportInfo of(PackageEntry exports, Collection<AccessFlag> exportFlags, ModuleEntry ... exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageDesc exports, int exportFlags, List<ModuleDesc> exportsTo) {
        return ModuleExportInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(exports.packageInternalName())), exportFlags, Util.moduleEntryList(exportsTo));
    }

    public static ModuleExportInfo of(PackageDesc exports, Collection<AccessFlag> exportFlags, List<ModuleDesc> exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageDesc exports, int exportFlags, ModuleDesc ... exportsTo) {
        return ModuleExportInfo.of(exports, exportFlags, List.of(exportsTo));
    }

    public static ModuleExportInfo of(PackageDesc exports, Collection<AccessFlag> exportFlags, ModuleDesc ... exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }
}

