/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import org.glavo.classfile.Attribute;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassSignature;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodSignature;
import org.glavo.classfile.Signature;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SignatureAttribute
extends Attribute<SignatureAttribute>,
ClassElement,
MethodElement,
FieldElement {
    public Utf8Entry signature();

    default public ClassSignature asClassSignature() {
        return ClassSignature.parseFrom(this.signature().stringValue());
    }

    default public MethodSignature asMethodSignature() {
        return MethodSignature.parseFrom(this.signature().stringValue());
    }

    default public Signature asTypeSignature() {
        return Signature.parseFrom(this.signature().stringValue());
    }

    public static SignatureAttribute of(ClassSignature classSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(classSignature.signatureString()));
    }

    public static SignatureAttribute of(MethodSignature methodSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(methodSignature.signatureString()));
    }

    public static SignatureAttribute of(Signature signature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(signature.signatureString()));
    }

    public static SignatureAttribute of(Utf8Entry signature) {
        return new UnboundAttribute.UnboundSignatureAttribute(signature);
    }
}

