/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Label;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.ChainedCodeBuilder;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.NonterminalCodeBuilder;
import org.glavo.classfile.impl.TransformingCodeBuilder;
import org.glavo.classfile.instruction.LabelTarget;

public final class BlockCodeBuilderImpl
extends NonterminalCodeBuilder
implements CodeBuilder.BlockCodeBuilder {
    private final Label startLabel;
    private final Label endLabel;
    private final Label breakLabel;
    private boolean reachable = true;
    private boolean hasInstructions = false;
    private int topLocal;
    private int terminalMaxLocals;

    public BlockCodeBuilderImpl(CodeBuilder parent, Label breakLabel) {
        super(parent);
        this.startLabel = parent.newLabel();
        this.endLabel = parent.newLabel();
        this.breakLabel = Objects.requireNonNull(breakLabel);
    }

    public void start() {
        this.topLocal = this.topLocal(this.parent);
        this.terminalMaxLocals = this.topLocal(this.terminal);
        this.terminal.with((LabelTarget)((Object)this.startLabel));
    }

    public void end() {
        this.terminal.with((LabelTarget)((Object)this.endLabel));
        if (this.terminalMaxLocals != this.topLocal(this.terminal)) {
            throw new IllegalStateException("Interference in local variable slot management");
        }
    }

    public boolean reachable() {
        return this.reachable;
    }

    public boolean isEmpty() {
        return !this.hasInstructions;
    }

    private int topLocal(CodeBuilder parent) {
        CodeBuilder codeBuilder = parent;
        Objects.requireNonNull(codeBuilder);
        CodeBuilder codeBuilder2 = codeBuilder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockCodeBuilderImpl.class, ChainedCodeBuilder.class, DirectCodeBuilder.class, BufferedCodeBuilder.class, TransformingCodeBuilder.class}, (Object)codeBuilder2, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                BlockCodeBuilderImpl b = (BlockCodeBuilderImpl)codeBuilder2;
                yield b.topLocal;
            }
            case 1 -> {
                ChainedCodeBuilder b = (ChainedCodeBuilder)codeBuilder2;
                yield this.topLocal(b.terminal);
            }
            case 2 -> {
                DirectCodeBuilder b = (DirectCodeBuilder)codeBuilder2;
                yield b.curTopLocal();
            }
            case 3 -> {
                BufferedCodeBuilder b = (BufferedCodeBuilder)codeBuilder2;
                yield b.curTopLocal();
            }
            case 4 -> {
                TransformingCodeBuilder b = (TransformingCodeBuilder)codeBuilder2;
                yield this.topLocal(b.delegate);
            }
        };
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        this.parent.with(element);
        this.hasInstructions |= element instanceof Instruction;
        if (this.reachable) {
            Instruction i;
            if (element instanceof Instruction && (i = (Instruction)element).opcode().isUnconditionalBranch()) {
                this.reachable = false;
            }
        } else if (element instanceof LabelTarget) {
            this.reachable = true;
        }
        return this;
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.topLocal;
        this.topLocal += typeKind.slotSize();
        return retVal;
    }

    @Override
    public Label breakLabel() {
        return this.breakLabel;
    }
}

