/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractUnboundModel;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.DirectMethodBuilder;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.TerminalMethodBuilder;
import org.glavo.classfile.impl.Util;

public final class BufferedMethodBuilder
implements TerminalMethodBuilder,
MethodInfo {
    private final List<MethodElement> elements = new ArrayList<MethodElement>();
    private final SplitConstantPool constantPool;
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private AccessFlags flags;
    private final MethodModel original;
    private int[] parameterSlots;

    public BufferedMethodBuilder(SplitConstantPool constantPool, Utf8Entry nameInfo, Utf8Entry typeInfo, MethodModel original) {
        this.constantPool = constantPool;
        this.name = nameInfo;
        this.desc = typeInfo;
        this.flags = AccessFlags.ofMethod(new AccessFlag[0]);
        this.original = original;
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        this.elements.add(element);
        if (element instanceof AccessFlags) {
            AccessFlags f;
            this.flags = f = (AccessFlags)element;
        }
        return this;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public Optional<MethodModel> original() {
        return Optional.ofNullable(this.original);
    }

    @Override
    public Utf8Entry methodName() {
        return this.name;
    }

    @Override
    public Utf8Entry methodType() {
        return this.desc;
    }

    @Override
    public int methodFlags() {
        return this.flags.flagsMask();
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodType().stringValue());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        return this.with(new BufferedCodeBuilder(this, this.constantPool, null).run(handler).toModel());
    }

    @Override
    public MethodBuilder transformCode(CodeModel code, CodeTransform transform) {
        BufferedCodeBuilder builder = new BufferedCodeBuilder(this, this.constantPool, code);
        builder.transform(code, transform);
        return this.with(builder.toModel());
    }

    @Override
    public BufferedCodeBuilder bufferedCodeBuilder(CodeModel original) {
        return new BufferedCodeBuilder(this, this.constantPool, original);
    }

    public BufferedMethodBuilder run(Consumer<? super MethodBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public MethodModel toModel() {
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<MethodElement>
    implements MethodModel,
    MethodInfo {
        public Model() {
            super(BufferedMethodBuilder.this.elements);
        }

        @Override
        public AccessFlags flags() {
            return BufferedMethodBuilder.this.flags;
        }

        @Override
        public Optional<ClassModel> parent() {
            return BufferedMethodBuilder.this.original().flatMap(MethodModel::parent);
        }

        @Override
        public Utf8Entry methodName() {
            return BufferedMethodBuilder.this.name;
        }

        @Override
        public Utf8Entry methodType() {
            return BufferedMethodBuilder.this.desc;
        }

        @Override
        public int methodFlags() {
            return BufferedMethodBuilder.this.flags.flagsMask();
        }

        @Override
        public int parameterSlot(int paramNo) {
            return BufferedMethodBuilder.this.parameterSlot(paramNo);
        }

        @Override
        public Optional<CodeModel> code() {
            throw new UnsupportedOperationException("nyi");
        }

        @Override
        public void writeTo(DirectClassBuilder builder) {
            builder.withMethod(this.methodName(), this.methodType(), this.methodFlags(), (Consumer<? super MethodBuilder>)new Consumer<MethodBuilder>(){

                @Override
                public void accept(MethodBuilder mb) {
                    Model.this.forEachElement(mb);
                }
            });
        }

        @Override
        public void writeTo(BufWriter buf) {
            DirectMethodBuilder mb = new DirectMethodBuilder(BufferedMethodBuilder.this.constantPool, BufferedMethodBuilder.this.name, BufferedMethodBuilder.this.desc, this.methodFlags(), null);
            BufferedMethodBuilder.this.elements.forEach(mb);
            mb.writeTo(buf);
        }

        public String toString() {
            return String.format("MethodModel[methodName=%s, methodType=%s, flags=%d]", BufferedMethodBuilder.this.name.stringValue(), BufferedMethodBuilder.this.desc.stringValue(), BufferedMethodBuilder.this.flags.flagsMask());
        }
    }
}

