/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractDirectBuilder;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.DirectFieldBuilder;
import org.glavo.classfile.impl.DirectMethodBuilder;
import org.glavo.classfile.impl.SplitConstantPool;

public final class DirectClassBuilder
extends AbstractDirectBuilder<ClassModel>
implements ClassBuilder {
    final ClassEntry thisClassEntry;
    private final List<WritableElement<FieldModel>> fields = new ArrayList<WritableElement<FieldModel>>();
    private final List<WritableElement<MethodModel>> methods = new ArrayList<WritableElement<MethodModel>>();
    private ClassEntry superclassEntry;
    private List<ClassEntry> interfaceEntries;
    private int majorVersion;
    private int minorVersion;
    private int flags;
    private int sizeHint;

    public DirectClassBuilder(SplitConstantPool constantPool, ClassEntry thisClass) {
        super(constantPool);
        this.thisClassEntry = AbstractPoolEntry.maybeClone(constantPool, thisClass);
        this.flags = 1;
        this.superclassEntry = null;
        this.interfaceEntries = Collections.emptyList();
        this.majorVersion = 61;
        this.minorVersion = 0;
    }

    @Override
    public ClassBuilder with(ClassElement element) {
        ((AbstractElement)((Object)element)).writeTo(this);
        return this;
    }

    @Override
    public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, Consumer<? super FieldBuilder> handler) {
        return this.withField(new DirectFieldBuilder(this.constantPool, name, descriptor, null).run(handler));
    }

    @Override
    public ClassBuilder transformField(FieldModel field, FieldTransform transform) {
        DirectFieldBuilder builder = new DirectFieldBuilder(this.constantPool, field.fieldName(), field.fieldType(), field);
        builder.transform(field, transform);
        return this.withField(builder);
    }

    @Override
    public ClassBuilder withMethod(Utf8Entry name, Utf8Entry descriptor, int flags, Consumer<? super MethodBuilder> handler) {
        return this.withMethod(new DirectMethodBuilder(this.constantPool, name, descriptor, flags, null).run(handler));
    }

    @Override
    public ClassBuilder transformMethod(MethodModel method, MethodTransform transform) {
        DirectMethodBuilder builder = new DirectMethodBuilder(this.constantPool, method.methodName(), method.methodType(), method.flags().flagsMask(), method);
        builder.transform(method, transform);
        return this.withMethod(builder);
    }

    public ClassBuilder withField(WritableElement<FieldModel> field) {
        this.fields.add(field);
        return this;
    }

    public ClassBuilder withMethod(WritableElement<MethodModel> method) {
        this.methods.add(method);
        return this;
    }

    void setSuperclass(ClassEntry superclassEntry) {
        this.superclassEntry = superclassEntry;
    }

    void setInterfaces(List<ClassEntry> interfaces) {
        this.interfaceEntries = interfaces;
    }

    void setVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    void setSizeHint(int sizeHint) {
        this.sizeHint = sizeHint;
    }

    public byte[] build() {
        ClassEntry superclass = this.superclassEntry;
        if (superclass != null) {
            superclass = AbstractPoolEntry.maybeClone(this.constantPool, superclass);
        } else if ((this.flags & 0x8000) == 0 && !"java/lang/Object".equals(this.thisClassEntry.asInternalName())) {
            superclass = this.constantPool.classEntry(ConstantDescs.CD_Object);
        }
        ArrayList<ClassEntry> ies = new ArrayList<ClassEntry>(this.interfaceEntries.size());
        for (ClassEntry ce : this.interfaceEntries) {
            ies.add(AbstractPoolEntry.maybeClone(this.constantPool, ce));
        }
        int size = this.sizeHint == 0 ? 256 : this.sizeHint;
        BufWriterImpl head = new BufWriterImpl(this.constantPool, size);
        BufWriterImpl tail = new BufWriterImpl(this.constantPool, size);
        tail.setThisClass(this.thisClassEntry);
        tail.writeList(this.fields);
        tail.writeList(this.methods);
        int attributesOffset = tail.size();
        this.attributes.writeTo(tail);
        boolean written = this.constantPool.writeBootstrapMethods(tail);
        if (written) {
            tail.patchInt(attributesOffset, 2, this.attributes.size() + 1);
        }
        head.writeInt(-889275714);
        head.writeU2(this.minorVersion);
        head.writeU2(this.majorVersion);
        this.constantPool.writeTo(head);
        head.writeU2(this.flags);
        head.writeIndex(this.thisClassEntry);
        head.writeIndexOrZero(superclass);
        head.writeListIndices(ies);
        byte[] result = new byte[head.size() + tail.size()];
        head.copyTo(result, 0);
        tail.copyTo(result, head.size());
        return result;
    }
}

