/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.nio.ByteBuffer;

public final class RawBytecodeHelper {
    public static final int ILLEGAL = -1;
    private static final byte[] LENGTHS = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 66, 66, 66, 66, 66, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 66, 66, 66, 66, 66, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 99, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 66, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 4, 4, 4, 2, 4, 3, 3, 0, 0, 1, 3, 2, 3, 3, 3, 1, 2, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final ByteBuffer bytecode;
    public int bci;
    public int nextBci;
    public int endBci;
    public int rawCode;
    public boolean isWide;

    public static boolean isStoreIntoLocal(int code) {
        return 54 <= code && code <= 78;
    }

    public static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public RawBytecodeHelper(ByteBuffer bytecode) {
        this.bytecode = bytecode;
        this.bci = 0;
        this.nextBci = 0;
        this.endBci = bytecode.capacity();
    }

    public boolean isLastBytecode() {
        return this.nextBci >= this.endBci;
    }

    public int getShort(int bci) {
        return this.bytecode.getShort(bci);
    }

    public int dest() {
        return this.bci + this.getShort(this.bci + 1);
    }

    public int getInt(int bci) {
        return this.bytecode.getInt(bci);
    }

    public int destW() {
        return this.bci + this.getInt(this.bci + 1);
    }

    public int getIndexU1() {
        return this.bytecode.get(this.bci + 1) & 0xFF;
    }

    public int getU1(int bci) {
        return this.bytecode.get(bci) & 0xFF;
    }

    public int rawNext(int jumpTo) {
        this.nextBci = jumpTo;
        return this.rawNext();
    }

    public int rawNext() {
        this.bci = this.nextBci;
        int code = this.bytecode.get(this.bci) & 0xFF;
        int len = LENGTHS[code] & 0xF;
        if (len > 0 && this.bci <= this.endBci - len) {
            this.isWide = false;
            this.nextBci += len;
            if (this.nextBci <= this.bci) {
                code = -1;
            }
            this.rawCode = code;
            return code;
        }
        switch (this.bytecode.get(this.bci) & 0xFF) {
            case 196: {
                int n;
                if (this.bci + 1 >= this.endBci) {
                    n = -1;
                    break;
                }
                n = LENGTHS[this.bytecode.get(this.bci + 1) & 0xFF] >> 4;
                break;
            }
            case 170: {
                int n;
                int aligned_bci = RawBytecodeHelper.align(this.bci + 1);
                if (aligned_bci + 12 >= this.endBci) {
                    n = -1;
                    break;
                }
                int lo = this.bytecode.getInt(aligned_bci + 4);
                int hi = this.bytecode.getInt(aligned_bci + 8);
                int l = aligned_bci - this.bci + (3 + hi - lo + 1) * 4;
                if (l > 0) {
                    n = l;
                    break;
                }
                n = -1;
                break;
            }
            case 171: {
                int n;
                int aligned_bci = RawBytecodeHelper.align(this.bci + 1);
                if (aligned_bci + 8 >= this.endBci) {
                    n = -1;
                    break;
                }
                int npairs = this.bytecode.getInt(aligned_bci + 4);
                int l = aligned_bci - this.bci + (2 + 2 * npairs) * 4;
                if (l > 0) {
                    n = l;
                    break;
                }
                n = -1;
                break;
            }
            default: {
                int n = len = 0;
            }
        }
        if (len <= 0 || this.bci > this.endBci - len || this.bci - len >= this.nextBci) {
            code = -1;
        } else {
            this.nextBci += len;
            this.isWide = false;
            if (code == 196) {
                if (this.bci + 1 >= this.endBci) {
                    code = -1;
                } else {
                    code = this.bytecode.get(this.bci + 1) & 0xFF;
                    this.isWide = true;
                }
            }
        }
        this.rawCode = code;
        return code;
    }

    public int getIndex() {
        return this.isWide ? this.getIndexU2Raw(this.bci + 2) : this.getIndexU1();
    }

    public int getIndexU2() {
        return this.getIndexU2Raw(this.bci + 1);
    }

    public int getIndexU2Raw(int bci) {
        return this.bytecode.getShort(bci) & 0xFFFF;
    }
}

