/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.Label;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.attribute.StackMapFrameInfo;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.TemporaryConstantPool;

public class StackMapDecoder {
    private static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    private static final int SAME_EXTENDED = 251;
    private final ClassReader classReader;
    private final int pos;
    private final LabelContext ctx;
    private final List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals;
    private int p;

    StackMapDecoder(ClassReader classReader, int pos, LabelContext ctx, List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals) {
        this.classReader = classReader;
        this.pos = pos;
        this.ctx = ctx;
        this.initFrameLocals = initFrameLocals;
    }

    static List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals(MethodModel method) {
        return StackMapDecoder.initFrameLocals(method.parent().orElseThrow().thisClass(), method.methodName().stringValue(), method.methodType().stringValue(), method.flags().has(AccessFlag.STATIC));
    }

    public static List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals(ClassEntry thisClass, String methodName, String methodType, boolean isStatic) {
        StackMapFrameInfo.VerificationTypeInfo[] vtis;
        MethodTypeDesc mdesc = MethodTypeDesc.ofDescriptor(methodType);
        int i = 0;
        if (!isStatic) {
            vtis = new StackMapFrameInfo.VerificationTypeInfo[mdesc.parameterCount() + 1];
            vtis[i++] = "<init>".equals(methodName) && !ConstantDescs.CD_Object.equals(thisClass.asSymbol()) ? StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_UNINITIALIZED_THIS : new ObjectVerificationTypeInfoImpl(thisClass);
        } else {
            vtis = new StackMapFrameInfo.VerificationTypeInfo[mdesc.parameterCount()];
        }
        for (ClassDesc arg : mdesc.parameterList()) {
            int n = i++;
            vtis[n] = switch (arg.descriptorString()) {
                case "I", "S", "C", "B", "Z" -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_INTEGER;
                case "J" -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_LONG;
                case "F" -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_FLOAT;
                case "D" -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_DOUBLE;
                case "V" -> throw new IllegalArgumentException("Illegal method argument type: " + arg);
                default -> new ObjectVerificationTypeInfoImpl(TemporaryConstantPool.INSTANCE.classEntry(arg));
            };
        }
        return List.of(vtis);
    }

    public static void writeFrames(BufWriter b, List<StackMapFrameInfo> entries) {
        BufWriterImpl buf = (BufWriterImpl)b;
        DirectCodeBuilder dcb = (DirectCodeBuilder)buf.labelContext();
        MethodInfo mi = dcb.methodInfo();
        List<StackMapFrameInfo.VerificationTypeInfo> prevLocals = StackMapDecoder.initFrameLocals(buf.thisClass(), mi.methodName().stringValue(), mi.methodType().stringValue(), (mi.methodFlags() & 8) != 0);
        int prevOffset = -1;
        TreeMap<Integer, StackMapFrameInfo> map = new TreeMap<Integer, StackMapFrameInfo>();
        for (StackMapFrameInfo stackMapFrameInfo : entries) {
            map.put(dcb.labelToBci(stackMapFrameInfo.target()), stackMapFrameInfo);
        }
        b.writeU2(map.size());
        for (Map.Entry entry : map.entrySet()) {
            int offset = (Integer)entry.getKey();
            StackMapFrameInfo fr = (StackMapFrameInfo)entry.getValue();
            StackMapDecoder.writeFrame(buf, offset - prevOffset - 1, prevLocals, fr);
            prevOffset = offset;
            prevLocals = fr.locals();
        }
    }

    private static void writeFrame(BufWriterImpl out, int offsetDelta, List<StackMapFrameInfo.VerificationTypeInfo> prevLocals, StackMapFrameInfo fr) {
        if (offsetDelta < 0) {
            throw new IllegalArgumentException("Invalid stack map frames order");
        }
        if (fr.stack().isEmpty()) {
            int commonLocalsSize = Math.min(prevLocals.size(), fr.locals().size());
            int diffLocalsSize = fr.locals().size() - prevLocals.size();
            if (-3 <= diffLocalsSize && diffLocalsSize <= 3 && StackMapDecoder.equals(fr.locals(), prevLocals, commonLocalsSize)) {
                if (diffLocalsSize == 0 && offsetDelta < 64) {
                    out.writeU1(offsetDelta);
                } else {
                    out.writeU1(251 + diffLocalsSize);
                    out.writeU2(offsetDelta);
                    for (int i = commonLocalsSize; i < fr.locals().size(); ++i) {
                        StackMapDecoder.writeTypeInfo(out, fr.locals().get(i));
                    }
                }
                return;
            }
        } else if (fr.stack().size() == 1 && fr.locals().equals(prevLocals)) {
            if (offsetDelta < 64) {
                out.writeU1(64 + offsetDelta);
            } else {
                out.writeU1(247);
                out.writeU2(offsetDelta);
            }
            StackMapDecoder.writeTypeInfo(out, fr.stack().get(0));
            return;
        }
        out.writeU1(255);
        out.writeU2(offsetDelta);
        out.writeU2(fr.locals().size());
        for (StackMapFrameInfo.VerificationTypeInfo l : fr.locals()) {
            StackMapDecoder.writeTypeInfo(out, l);
        }
        out.writeU2(fr.stack().size());
        for (StackMapFrameInfo.VerificationTypeInfo s : fr.stack()) {
            StackMapDecoder.writeTypeInfo(out, s);
        }
    }

    private static boolean equals(List<StackMapFrameInfo.VerificationTypeInfo> l1, List<StackMapFrameInfo.VerificationTypeInfo> l2, int compareSize) {
        for (int i = 0; i < compareSize; ++i) {
            if (l1.get(i).equals(l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void writeTypeInfo(BufWriterImpl bw, StackMapFrameInfo.VerificationTypeInfo vti) {
        bw.writeU1(vti.tag());
        StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo = vti;
        Objects.requireNonNull(verificationTypeInfo);
        StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo2 = verificationTypeInfo;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StackMapFrameInfo.SimpleVerificationTypeInfo.class, StackMapFrameInfo.ObjectVerificationTypeInfo.class, StackMapFrameInfo.UninitializedVerificationTypeInfo.class}, (Object)verificationTypeInfo2, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                StackMapFrameInfo.SimpleVerificationTypeInfo svti = (StackMapFrameInfo.SimpleVerificationTypeInfo)verificationTypeInfo2;
                break;
            }
            case 1: {
                StackMapFrameInfo.ObjectVerificationTypeInfo ovti = (StackMapFrameInfo.ObjectVerificationTypeInfo)verificationTypeInfo2;
                bw.writeIndex(ovti.className());
                break;
            }
            case 2: {
                StackMapFrameInfo.UninitializedVerificationTypeInfo uvti = (StackMapFrameInfo.UninitializedVerificationTypeInfo)verificationTypeInfo2;
                bw.writeU2(bw.labelContext().labelToBci(uvti.newTarget()));
            }
        }
    }

    List<StackMapFrameInfo> entries() {
        this.p = this.pos;
        List<StackMapFrameInfo.VerificationTypeInfo> locals = this.initFrameLocals;
        List<Object> stack = List.of();
        int bci = -1;
        StackMapFrameInfo[] entries = new StackMapFrameInfo[this.u2()];
        for (int ei = 0; ei < entries.length; ++ei) {
            int frameType;
            if ((frameType = this.classReader.readU1(this.p++)) < 64) {
                bci += frameType + 1;
                stack = List.of();
            } else if (frameType < 128) {
                bci += frameType - 63;
                stack = List.of(this.readVerificationTypeInfo());
            } else {
                if (frameType < 247) {
                    throw new IllegalArgumentException("Invalid stackmap frame type: " + frameType);
                }
                bci += this.u2() + 1;
                if (frameType == 247) {
                    stack = List.of(this.readVerificationTypeInfo());
                } else if (frameType < 251) {
                    locals = locals.subList(0, locals.size() + frameType - 251);
                    stack = List.of();
                } else if (frameType == 251) {
                    stack = List.of();
                } else if (frameType < 255) {
                    int actSize = locals.size();
                    StackMapFrameInfo.VerificationTypeInfo[] newLocals = locals.toArray(new StackMapFrameInfo.VerificationTypeInfo[actSize + frameType - 251]);
                    for (i = actSize; i < newLocals.length; ++i) {
                        newLocals[i] = this.readVerificationTypeInfo();
                    }
                    locals = List.of(newLocals);
                    stack = List.of();
                } else {
                    StackMapFrameInfo.VerificationTypeInfo[] newLocals = new StackMapFrameInfo.VerificationTypeInfo[this.u2()];
                    for (int i = 0; i < newLocals.length; ++i) {
                        newLocals[i] = this.readVerificationTypeInfo();
                    }
                    StackMapFrameInfo.VerificationTypeInfo[] newStack = new StackMapFrameInfo.VerificationTypeInfo[this.u2()];
                    for (i = 0; i < newStack.length; ++i) {
                        newStack[i] = this.readVerificationTypeInfo();
                    }
                    locals = List.of(newLocals);
                    stack = List.of(newStack);
                }
            }
            entries[ei] = new StackMapFrameImpl(frameType, this.ctx.getLabel(bci), locals, stack);
        }
        return List.of(entries);
    }

    private StackMapFrameInfo.VerificationTypeInfo readVerificationTypeInfo() {
        int tag = this.classReader.readU1(this.p++);
        return switch (tag) {
            case 0 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_TOP;
            case 1 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_INTEGER;
            case 2 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_FLOAT;
            case 3 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_DOUBLE;
            case 4 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_LONG;
            case 5 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_NULL;
            case 6 -> StackMapFrameInfo.SimpleVerificationTypeInfo.ITEM_UNINITIALIZED_THIS;
            case 7 -> new ObjectVerificationTypeInfoImpl((ClassEntry)this.classReader.entryByIndex(this.u2()));
            case 8 -> new UninitializedVerificationTypeInfoImpl(this.ctx.getLabel(this.u2()));
            default -> throw new IllegalArgumentException("Invalid verification type tag: " + tag);
        };
    }

    private int u2() {
        int v = this.classReader.readU2(this.p);
        this.p += 2;
        return v;
    }

    public record ObjectVerificationTypeInfoImpl(ClassEntry className) implements StackMapFrameInfo.ObjectVerificationTypeInfo
    {
        @Override
        public int tag() {
            return 7;
        }

        @Override
        public String toString() {
            return this.className.asInternalName();
        }
    }

    public record StackMapFrameImpl(int frameType, Label target, List<StackMapFrameInfo.VerificationTypeInfo> locals, List<StackMapFrameInfo.VerificationTypeInfo> stack) implements StackMapFrameInfo
    {
    }

    public record UninitializedVerificationTypeInfoImpl(Label newTarget) implements StackMapFrameInfo.UninitializedVerificationTypeInfo
    {
        @Override
        public int tag() {
            return 8;
        }

        @Override
        public String toString() {
            return "UNINIT(" + this.newTarget + ")";
        }
    }
}

