/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.Classfile;
import org.glavo.classfile.Label;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.attribute.StackMapTableAttribute;
import org.glavo.classfile.components.ClassPrinter;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantDynamicEntry;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.DynamicConstantPoolEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.impl.AbstractPseudoInstruction;
import org.glavo.classfile.impl.ClassHierarchyImpl;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.DirectMethodBuilder;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.RawBytecodeHelper;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;

public final class StackMapGenerator {
    private static final String OBJECT_INITIALIZER_NAME = "<init>";
    private static final int FLAG_THIS_UNINIT = 1;
    private static final int FRAME_DEFAULT_CAPACITY = 10;
    private static final int T_BOOLEAN = 4;
    private static final int T_LONG = 11;
    private static final int ITEM_TOP = 0;
    private static final int ITEM_INTEGER = 1;
    private static final int ITEM_FLOAT = 2;
    private static final int ITEM_DOUBLE = 3;
    private static final int ITEM_LONG = 4;
    private static final int ITEM_NULL = 5;
    private static final int ITEM_UNINITIALIZED_THIS = 6;
    private static final int ITEM_OBJECT = 7;
    private static final int ITEM_UNINITIALIZED = 8;
    private static final int ITEM_BOOLEAN = 9;
    private static final int ITEM_BYTE = 10;
    private static final int ITEM_SHORT = 11;
    private static final int ITEM_CHAR = 12;
    private static final int ITEM_LONG_2ND = 13;
    private static final int ITEM_DOUBLE_2ND = 14;
    private static final Type[] ARRAY_FROM_BASIC_TYPE = new Type[]{null, null, null, null, Type.BOOLEAN_ARRAY_TYPE, Type.CHAR_ARRAY_TYPE, Type.FLOAT_ARRAY_TYPE, Type.DOUBLE_ARRAY_TYPE, Type.BYTE_ARRAY_TYPE, Type.SHORT_ARRAY_TYPE, Type.INT_ARRAY_TYPE, Type.LONG_ARRAY_TYPE};
    private final Type thisType;
    private final String methodName;
    private final MethodTypeDesc methodDesc;
    private final ByteBuffer bytecode;
    private final SplitConstantPool cp;
    private final boolean isStatic;
    private final LabelContext labelContext;
    private final List<AbstractPseudoInstruction.ExceptionCatchImpl> exceptionTable;
    private final ClassHierarchyImpl classHierarchy;
    private final boolean patchDeadCode;
    private List<Frame> frames;
    private final Frame currentFrame;
    private int maxStack;
    private int maxLocals;
    private int exMin;
    private int exMax;

    public StackMapGenerator(LabelContext labelContext, ClassDesc thisClass, String methodName, MethodTypeDesc methodDesc, boolean isStatic, ByteBuffer bytecode, SplitConstantPool cp, List<AbstractPseudoInstruction.ExceptionCatchImpl> handlers) {
        this.thisType = Type.referenceType(thisClass);
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.isStatic = isStatic;
        this.bytecode = bytecode;
        this.cp = cp;
        this.labelContext = labelContext;
        this.exceptionTable = handlers;
        this.classHierarchy = new ClassHierarchyImpl(cp.options().classHierarchyResolver);
        this.patchDeadCode = cp.options().patchCode;
        this.currentFrame = new Frame(this.classHierarchy);
        this.generate();
    }

    public int maxLocals() {
        return this.maxLocals;
    }

    public int maxStack() {
        return this.maxStack;
    }

    private int getFrameIndexFromOffset(int offset) {
        int i;
        for (i = 0; i < this.frames.size(); ++i) {
            if (this.frames.get((int)i).offset != offset) continue;
            return i;
        }
        return i;
    }

    private void checkJumpTarget(Frame frame, int target) {
        int index = this.getFrameIndexFromOffset(target);
        frame.checkAssignableTo(this.frames.get(index));
    }

    private boolean isAnyFrameDirty() {
        for (Frame f : this.frames) {
            if (!f.dirty) continue;
            return true;
        }
        return false;
    }

    private void generate() {
        int i;
        this.exMin = this.bytecode.capacity();
        this.exMax = -1;
        for (AbstractPseudoInstruction.ExceptionCatchImpl exhandler : this.exceptionTable) {
            int start_pc = this.labelContext.labelToBci(exhandler.tryStart());
            int end_pc = this.labelContext.labelToBci(exhandler.tryEnd());
            if (start_pc < this.exMin) {
                this.exMin = start_pc;
            }
            if (end_pc <= this.exMax) continue;
            this.exMax = end_pc;
        }
        BitSet frameOffsets = this.detectFrameOffsets();
        int framesCount = frameOffsets.cardinality();
        this.frames = new ArrayList<Frame>(framesCount);
        int offset = -1;
        for (i = 0; i < framesCount; ++i) {
            offset = frameOffsets.nextSetBit(offset + 1);
            this.frames.add(new Frame(offset, this.classHierarchy));
        }
        do {
            this.processMethod();
        } while (this.isAnyFrameDirty());
        this.maxLocals = this.currentFrame.frameMaxLocals;
        this.maxStack = this.currentFrame.frameMaxStack;
        for (i = 0; i < framesCount; ++i) {
            Frame frame = this.frames.get(i);
            if (frame.flags != -1) continue;
            if (!this.patchDeadCode) {
                this.generatorError("Unable to generate stack map frame for dead code", frame.offset);
            }
            frame.pushStack(Type.THROWABLE_TYPE);
            if (this.maxStack < 1) {
                this.maxStack = 1;
            }
            int blockSize = (i < framesCount - 1 ? this.frames.get((int)(i + 1)).offset : this.bytecode.limit()) - frame.offset;
            this.bytecode.position(frame.offset);
            for (int n = 1; n < blockSize; ++n) {
                this.bytecode.put((byte)0);
            }
            this.bytecode.put((byte)-65);
            this.removeRangeFromExcTable(frame.offset, frame.offset + blockSize);
        }
    }

    private void removeRangeFromExcTable(int rangeStart, int rangeEnd) {
        ListIterator<AbstractPseudoInstruction.ExceptionCatchImpl> it = this.exceptionTable.listIterator();
        while (it.hasNext()) {
            Label newStart;
            AbstractPseudoInstruction.ExceptionCatchImpl e = it.next();
            int handlerStart = this.labelContext.labelToBci(e.tryStart());
            int handlerEnd = this.labelContext.labelToBci(e.tryEnd());
            if (rangeStart >= handlerEnd || rangeEnd <= handlerStart) continue;
            if (rangeStart <= handlerStart) {
                if (rangeEnd >= handlerEnd) {
                    it.remove();
                    continue;
                }
                newStart = this.labelContext.newLabel();
                this.labelContext.setLabelTarget(newStart, rangeEnd);
                it.set(new AbstractPseudoInstruction.ExceptionCatchImpl(e.handler(), newStart, e.tryEnd(), e.catchType()));
                continue;
            }
            if (rangeEnd >= handlerEnd) {
                Label newEnd = this.labelContext.newLabel();
                this.labelContext.setLabelTarget(newEnd, rangeStart);
                it.set(new AbstractPseudoInstruction.ExceptionCatchImpl(e.handler(), e.tryStart(), newEnd, e.catchType()));
                continue;
            }
            newStart = this.labelContext.newLabel();
            this.labelContext.setLabelTarget(newStart, rangeEnd);
            Label newEnd = this.labelContext.newLabel();
            this.labelContext.setLabelTarget(newEnd, rangeStart);
            it.set(new AbstractPseudoInstruction.ExceptionCatchImpl(e.handler(), e.tryStart(), newEnd, e.catchType()));
            it.add(new AbstractPseudoInstruction.ExceptionCatchImpl(e.handler(), newStart, e.tryEnd(), e.catchType()));
        }
    }

    public Attribute<? extends StackMapTableAttribute> stackMapTableAttribute() {
        return this.frames.isEmpty() ? null : new UnboundAttribute.AdHocAttribute<StackMapTableAttribute>(Attributes.STACK_MAP_TABLE){

            @Override
            public void writeBody(BufWriter b) {
                b.writeU2(StackMapGenerator.this.frames.size());
                Frame prevFrame = new Frame(StackMapGenerator.this.classHierarchy);
                prevFrame.setLocalsFromArg(StackMapGenerator.this.methodName, StackMapGenerator.this.methodDesc, StackMapGenerator.this.isStatic, StackMapGenerator.this.thisType);
                prevFrame.trimAndCompress();
                for (Frame fr : StackMapGenerator.this.frames) {
                    fr.trimAndCompress();
                    fr.writeTo(b, prevFrame, StackMapGenerator.this.cp);
                    prevFrame = fr;
                }
            }
        };
    }

    private static Type cpIndexToType(int index, ConstantPoolBuilder cp) {
        return Type.referenceType(((ClassEntry)cp.entryByIndex(index)).asSymbol());
    }

    private static boolean isDoubleSlot(ClassDesc desc) {
        return ConstantDescs.CD_double.equals(desc) || ConstantDescs.CD_long.equals(desc);
    }

    private void processMethod() {
        this.currentFrame.setLocalsFromArg(this.methodName, this.methodDesc, this.isStatic, this.thisType);
        this.currentFrame.stackSize = 0;
        this.currentFrame.flags = 0;
        this.currentFrame.offset = -1;
        int stackmapIndex = 0;
        RawBytecodeHelper bcs = new RawBytecodeHelper(this.bytecode);
        boolean ncf = false;
        while (!bcs.isLastBytecode()) {
            bcs.rawNext();
            this.currentFrame.offset = bcs.bci;
            if (stackmapIndex < this.frames.size()) {
                int thisOffset = this.frames.get((int)stackmapIndex).offset;
                if (ncf && thisOffset > bcs.bci) {
                    this.generatorError("Expecting a stack map frame");
                }
                if (thisOffset == bcs.bci) {
                    if (!ncf) {
                        this.currentFrame.checkAssignableTo(this.frames.get(stackmapIndex));
                    }
                    Frame nextFrame = this.frames.get(stackmapIndex++);
                    while (!nextFrame.dirty) {
                        if (stackmapIndex == this.frames.size()) {
                            return;
                        }
                        nextFrame = this.frames.get(stackmapIndex++);
                    }
                    bcs.rawNext(nextFrame.offset);
                    this.currentFrame.offset = bcs.bci;
                    this.currentFrame.copyFrom(nextFrame);
                    nextFrame.dirty = false;
                } else if (thisOffset < bcs.bci) {
                    throw new ClassFormatError(String.format("Bad stack map offset %d", thisOffset));
                }
            } else if (ncf) {
                this.generatorError("Expecting a stack map frame");
            }
            ncf = this.processBlock(bcs);
        }
    }

    private boolean processBlock(RawBytecodeHelper bcs) {
        int opcode = bcs.rawCode;
        boolean ncf = false;
        boolean this_uninit = false;
        boolean verified_exc_handlers = false;
        int bci = bcs.bci;
        if (RawBytecodeHelper.isStoreIntoLocal(opcode) && bci >= this.exMin && bci < this.exMax) {
            this.processExceptionHandlerTargets(bci, this_uninit);
            verified_exc_handlers = true;
        }
        switch (opcode) {
            case 0: {
                break;
            }
            case 177: {
                ncf = true;
                break;
            }
            case 1: {
                this.currentFrame.pushStack(Type.NULL_TYPE);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                this.currentFrame.pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 9: 
            case 10: {
                this.currentFrame.pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.currentFrame.pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 14: 
            case 15: {
                this.currentFrame.pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 18: {
                this.processLdc(bcs.getIndexU1());
                break;
            }
            case 19: 
            case 20: {
                this.processLdc(bcs.getIndexU2());
                break;
            }
            case 21: {
                this.currentFrame.checkLocal(bcs.getIndex()).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.currentFrame.checkLocal(opcode - 26).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 22: {
                this.currentFrame.checkLocal(bcs.getIndex() + 1).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.currentFrame.checkLocal(opcode - 30 + 1).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 23: {
                this.currentFrame.checkLocal(bcs.getIndex()).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.currentFrame.checkLocal(opcode - 34).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 24: {
                this.currentFrame.checkLocal(bcs.getIndex() + 1).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.currentFrame.checkLocal(opcode - 38 + 1).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 25: {
                this.currentFrame.pushStack(this.currentFrame.getLocal(bcs.getIndex()));
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.currentFrame.pushStack(this.currentFrame.getLocal(opcode - 42));
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.currentFrame.decStack(2).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 47: {
                this.currentFrame.decStack(2).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 48: {
                this.currentFrame.decStack(2).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 49: {
                this.currentFrame.decStack(2).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 50: {
                Type type1 = this.currentFrame.decStack(1).popStack();
                this.currentFrame.pushStack(type1 == Type.NULL_TYPE ? Type.NULL_TYPE : type1.getComponent());
                break;
            }
            case 54: {
                this.currentFrame.decStack(1).setLocal(bcs.getIndex(), Type.INTEGER_TYPE);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.currentFrame.decStack(1).setLocal(opcode - 59, Type.INTEGER_TYPE);
                break;
            }
            case 55: {
                this.currentFrame.decStack(2).setLocal2(bcs.getIndex(), Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.currentFrame.decStack(2).setLocal2(opcode - 63, Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 56: {
                this.currentFrame.decStack(1).setLocal(bcs.getIndex(), Type.FLOAT_TYPE);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.currentFrame.decStack(1).setLocal(opcode - 67, Type.FLOAT_TYPE);
                break;
            }
            case 57: {
                this.currentFrame.decStack(2).setLocal2(bcs.getIndex(), Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.currentFrame.decStack(2).setLocal2(opcode - 71, Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 58: {
                this.currentFrame.setLocal(bcs.getIndex(), this.currentFrame.popStack());
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.currentFrame.setLocal(opcode - 75, this.currentFrame.popStack());
                break;
            }
            case 80: 
            case 82: {
                this.currentFrame.decStack(4);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.currentFrame.decStack(3);
                break;
            }
            case 87: 
            case 194: 
            case 195: {
                this.currentFrame.decStack(1);
                break;
            }
            case 88: {
                this.currentFrame.decStack(2);
                break;
            }
            case 89: {
                Type type1 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type1).pushStack(type1);
                break;
            }
            case 90: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type1).pushStack(type2).pushStack(type1);
                break;
            }
            case 91: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                Type type3 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type1).pushStack(type3).pushStack(type2).pushStack(type1);
                break;
            }
            case 92: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type2).pushStack(type1).pushStack(type2).pushStack(type1);
                break;
            }
            case 93: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                Type type3 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type2).pushStack(type1).pushStack(type3).pushStack(type2).pushStack(type1);
                break;
            }
            case 94: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                Type type3 = this.currentFrame.popStack();
                Type type4 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type2).pushStack(type1).pushStack(type4).pushStack(type3).pushStack(type2).pushStack(type1);
                break;
            }
            case 95: {
                Type type1 = this.currentFrame.popStack();
                Type type2 = this.currentFrame.popStack();
                this.currentFrame.pushStack(type1);
                this.currentFrame.pushStack(type2);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.currentFrame.decStack(2).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 116: 
            case 190: 
            case 193: {
                this.currentFrame.decStack(1).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.currentFrame.decStack(4).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 117: {
                this.currentFrame.decStack(2).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.currentFrame.decStack(3).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.currentFrame.decStack(2).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 118: {
                this.currentFrame.decStack(1).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.currentFrame.decStack(4).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 119: {
                this.currentFrame.decStack(2).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 132: {
                this.currentFrame.checkLocal(bcs.getIndex());
                break;
            }
            case 133: {
                this.currentFrame.decStack(1).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 136: {
                this.currentFrame.decStack(2).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 134: {
                this.currentFrame.decStack(1).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 135: {
                this.currentFrame.decStack(1).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 137: {
                this.currentFrame.decStack(2).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 138: {
                this.currentFrame.decStack(2).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 139: {
                this.currentFrame.decStack(1).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 140: {
                this.currentFrame.decStack(1).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 141: {
                this.currentFrame.decStack(1).pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 143: {
                this.currentFrame.decStack(2).pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 144: {
                this.currentFrame.decStack(2).pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                this.currentFrame.decStack(1).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.currentFrame.decStack(4).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 142: 
            case 149: 
            case 150: {
                this.currentFrame.decStack(2).pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.checkJumpTarget(this.currentFrame.decStack(2), bcs.dest());
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.checkJumpTarget(this.currentFrame.decStack(1), bcs.dest());
                break;
            }
            case 167: {
                this.checkJumpTarget(this.currentFrame, bcs.dest());
                ncf = true;
                break;
            }
            case 200: {
                this.checkJumpTarget(this.currentFrame, bcs.destW());
                ncf = true;
                break;
            }
            case 170: 
            case 171: {
                this.processSwitch(bcs);
                ncf = true;
                break;
            }
            case 173: 
            case 175: {
                this.currentFrame.decStack(2);
                ncf = true;
                break;
            }
            case 172: 
            case 174: 
            case 176: 
            case 191: {
                this.currentFrame.decStack(1);
                ncf = true;
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                this.processFieldInstructions(bcs);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                this_uninit = this.processInvokeInstructions(bcs, bci >= this.exMin && bci < this.exMax, this_uninit);
                break;
            }
            case 187: {
                this.currentFrame.pushStack(Type.uninitializedType(bci));
                break;
            }
            case 188: {
                this.currentFrame.decStack(1).pushStack(this.getNewarrayType(bcs.getIndex()));
                break;
            }
            case 189: {
                this.processAnewarray(bcs.getIndexU2());
                break;
            }
            case 192: {
                this.currentFrame.decStack(1).pushStack(StackMapGenerator.cpIndexToType(bcs.getIndexU2(), this.cp));
                break;
            }
            case 197: {
                Type type1 = StackMapGenerator.cpIndexToType(bcs.getIndexU2(), this.cp);
                int dim = bcs.getU1(bcs.bci + 3);
                for (int i = 0; i < dim; ++i) {
                    this.currentFrame.popStack();
                }
                this.currentFrame.pushStack(type1);
                break;
            }
            default: {
                this.generatorError(String.format("Bad instruction: %02x", opcode));
            }
        }
        if (!verified_exc_handlers && bci >= this.exMin && bci < this.exMax) {
            this.processExceptionHandlerTargets(bci, this_uninit);
        }
        return ncf;
    }

    private void processExceptionHandlerTargets(int bci, boolean this_uninit) {
        for (AbstractPseudoInstruction.ExceptionCatchImpl exhandler : this.exceptionTable) {
            if (bci < this.labelContext.labelToBci(exhandler.tryStart()) || bci >= this.labelContext.labelToBci(exhandler.tryEnd())) continue;
            int flags = this.currentFrame.flags;
            if (this_uninit) {
                flags |= 1;
            }
            Frame newFrame = this.currentFrame.frameInExceptionHandler(flags);
            Optional<ClassEntry> catchType = exhandler.catchType();
            newFrame.pushStack(catchType.isPresent() ? StackMapGenerator.cpIndexToType(catchType.get().index(), this.cp) : Type.THROWABLE_TYPE);
            int handler = this.labelContext.labelToBci(exhandler.handler());
            if (handler == -1) continue;
            this.checkJumpTarget(newFrame, handler);
        }
    }

    private void processLdc(int index) {
        switch (this.cp.entryByIndex(index).tag()) {
            case 1: {
                this.currentFrame.pushStack(Type.OBJECT_TYPE);
                break;
            }
            case 8: {
                this.currentFrame.pushStack(Type.STRING_TYPE);
                break;
            }
            case 7: {
                this.currentFrame.pushStack(Type.CLASS_TYPE);
                break;
            }
            case 3: {
                this.currentFrame.pushStack(Type.INTEGER_TYPE);
                break;
            }
            case 4: {
                this.currentFrame.pushStack(Type.FLOAT_TYPE);
                break;
            }
            case 6: {
                this.currentFrame.pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                break;
            }
            case 5: {
                this.currentFrame.pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                break;
            }
            case 15: {
                this.currentFrame.pushStack(Type.METHOD_HANDLE_TYPE);
                break;
            }
            case 16: {
                this.currentFrame.pushStack(Type.METHOD_TYPE);
                break;
            }
            case 17: {
                this.currentFrame.pushStack(((ConstantDynamicEntry)this.cp.entryByIndex(index)).asSymbol().constantType());
                break;
            }
            default: {
                this.generatorError("CP entry #%d %s is not loadable constant".formatted(index, this.cp.entryByIndex(index).tag()));
            }
        }
    }

    private void processSwitch(RawBytecodeHelper bcs) {
        int delta;
        int keys;
        int bci = bcs.bci;
        int alignedBci = RawBytecodeHelper.align(bci + 1);
        int defaultOfset = bcs.getInt(alignedBci);
        this.currentFrame.popStack();
        if (bcs.rawCode == 170) {
            int high;
            int low = bcs.getInt(alignedBci + 4);
            if (low > (high = bcs.getInt(alignedBci + 8))) {
                this.generatorError("low must be less than or equal to high in tableswitch");
            }
            if ((keys = high - low + 1) < 0) {
                this.generatorError("too many keys in tableswitch");
            }
            delta = 1;
        } else {
            keys = bcs.getInt(alignedBci + 4);
            if (keys < 0) {
                this.generatorError("number of keys in lookupswitch less than 0");
            }
            delta = 2;
            for (int i = 0; i < keys - 1; ++i) {
                int next_key;
                int this_key = bcs.getInt(alignedBci + (2 + 2 * i) * 4);
                if (this_key < (next_key = bcs.getInt(alignedBci + (2 + 2 * i + 2) * 4))) continue;
                this.generatorError("Bad lookupswitch instruction");
            }
        }
        int target = bci + defaultOfset;
        this.checkJumpTarget(this.currentFrame, target);
        for (int i = 0; i < keys; ++i) {
            alignedBci = RawBytecodeHelper.align(bcs.bci + 1);
            target = bci + bcs.getInt(alignedBci + (3 + i * delta) * 4);
            this.checkJumpTarget(this.currentFrame, target);
        }
    }

    private void processFieldInstructions(RawBytecodeHelper bcs) {
        ClassDesc desc = ClassDesc.ofDescriptor(((MemberRefEntry)this.cp.entryByIndex(bcs.getIndexU2())).nameAndType().type().stringValue());
        switch (bcs.rawCode) {
            case 178: {
                this.currentFrame.pushStack(desc);
                break;
            }
            case 179: {
                this.currentFrame.popStack();
                if (!StackMapGenerator.isDoubleSlot(desc)) break;
                this.currentFrame.popStack();
                break;
            }
            case 180: {
                this.currentFrame.popStack();
                this.currentFrame.pushStack(desc);
                break;
            }
            case 181: {
                this.currentFrame.popStack();
                this.currentFrame.popStack();
                if (!StackMapGenerator.isDoubleSlot(desc)) break;
                this.currentFrame.popStack();
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not reach here");
            }
        }
    }

    private boolean processInvokeInstructions(RawBytecodeHelper bcs, boolean inTryBlock, boolean thisUninit) {
        char ch;
        int index = bcs.getIndexU2();
        int opcode = bcs.rawCode;
        PoolEntry cpe = this.cp.entryByIndex(index);
        NameAndTypeEntry nameAndType = opcode == 186 ? ((DynamicConstantPoolEntry)cpe).nameAndType() : ((MemberRefEntry)cpe).nameAndType();
        String invokeMethodName = nameAndType.name().stringValue();
        String mDesc = nameAndType.type().stringValue();
        int nargs = 0;
        int pos = 0;
        int descLen = mDesc.length();
        if (descLen < 3 || mDesc.charAt(0) != '(') {
            throw new IllegalArgumentException("Bad method descriptor: " + mDesc);
        }
        block6: while (++pos < descLen && (ch = mDesc.charAt(pos)) != ')') {
            switch (ch) {
                case '[': {
                    ++nargs;
                    while (++pos < descLen && mDesc.charAt(pos) == '[') {
                    }
                    if (mDesc.charAt(pos) != 'L') continue block6;
                    while (++pos < descLen && mDesc.charAt(pos) != ';') {
                    }
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    nargs += 2;
                    continue block6;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++nargs;
                    continue block6;
                }
                case 'L': {
                    ++nargs;
                    while (++pos < descLen && mDesc.charAt(pos) != ';') {
                    }
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Bad method descriptor: " + mDesc);
        }
        if (++pos >= descLen) {
            throw new IllegalArgumentException("Bad method descriptor: " + mDesc);
        }
        int bci = bcs.bci;
        this.currentFrame.decStack(nargs);
        if (opcode != 184 && opcode != 186) {
            if (OBJECT_INITIALIZER_NAME.equals(invokeMethodName)) {
                Type type = this.currentFrame.popStack();
                if (type == Type.UNITIALIZED_THIS_TYPE) {
                    if (inTryBlock) {
                        this.processExceptionHandlerTargets(bci, true);
                    }
                    this.currentFrame.initializeObject(type, this.thisType);
                    thisUninit = true;
                } else if (type.tag == 8) {
                    int new_offset = type.bci;
                    int new_class_index = bcs.getIndexU2Raw(new_offset + 1);
                    Type new_class_type = StackMapGenerator.cpIndexToType(new_class_index, this.cp);
                    if (inTryBlock) {
                        this.processExceptionHandlerTargets(bci, thisUninit);
                    }
                    this.currentFrame.initializeObject(type, new_class_type);
                } else {
                    this.generatorError("Bad operand type when invoking <init>");
                }
            } else {
                this.currentFrame.popStack();
            }
        }
        this.currentFrame.pushStack(ClassDesc.ofDescriptor(mDesc.substring(pos)));
        return thisUninit;
    }

    private Type getNewarrayType(int index) {
        if (index < 4 || index > 11) {
            this.generatorError("Illegal newarray instruction type %d".formatted(index));
        }
        return ARRAY_FROM_BASIC_TYPE[index];
    }

    private void processAnewarray(int index) {
        this.currentFrame.popStack();
        this.currentFrame.pushStack(StackMapGenerator.cpIndexToType(index, this.cp).toArray());
    }

    private void generatorError(String msg) {
        this.generatorError(msg, this.currentFrame.offset);
    }

    private void generatorError(String msg, int offset) {
        StringBuilder sb = new StringBuilder("%s at bytecode offset %d of method %s(%s)".formatted(msg, offset, this.methodName, this.methodDesc.parameterList().stream().map(ClassDesc::displayName).collect(Collectors.joining(","))));
        try {
            this.cp.options.generateStackmaps = false;
            DirectClassBuilder clb = new DirectClassBuilder(this.cp, this.cp.classEntry(ClassDesc.of("FakeClass")));
            clb.withMethod(this.methodName, this.methodDesc, this.isStatic ? 8 : 0, mb -> ((DirectMethodBuilder)mb).writeAttribute(new UnboundAttribute.AdHocAttribute<CodeAttribute>(Attributes.CODE){

                @Override
                public void writeBody(BufWriter b) {
                    b.writeU2(-1);
                    b.writeU2(-1);
                    b.writeInt(StackMapGenerator.this.bytecode.limit());
                    b.writeBytes(StackMapGenerator.this.bytecode.array(), 0, StackMapGenerator.this.bytecode.limit());
                    b.writeU2(0);
                    b.writeU2(0);
                }
            }));
            ClassPrinter.toYaml(Classfile.parse(clb.build(), new Classfile.Option[0]).methods().get(0).code().get(), ClassPrinter.Verbosity.TRACE_ALL, sb::append);
        }
        catch (Error | Exception suppresed) {
            this.bytecode.rewind();
            while (this.bytecode.position() < this.bytecode.limit()) {
                sb.append("%n%04x:".formatted(this.bytecode.position()));
                for (int i = 0; i < 16 && this.bytecode.position() < this.bytecode.limit(); ++i) {
                    sb.append(" %02x".formatted(this.bytecode.get()));
                }
            }
            VerifyError err = new VerifyError(sb.toString());
            err.addSuppressed(suppresed);
            throw err;
        }
        throw new IllegalStateException(sb.toString());
    }

    private BitSet detectFrameOffsets() {
        var offsets = new BitSet(){

            @Override
            public void set(int i) {
                if (i < 0 || i >= StackMapGenerator.this.bytecode.capacity()) {
                    throw new IllegalArgumentException();
                }
                super.set(i);
            }
        };
        RawBytecodeHelper bcs = new RawBytecodeHelper(this.bytecode);
        boolean no_control_flow = false;
        int bci = 0;
        while (!bcs.isLastBytecode()) {
            try {
                int opcode = bcs.rawNext();
                bci = bcs.bci;
                if (no_control_flow) {
                    offsets.set(bci);
                }
                no_control_flow = switch (opcode) {
                    case 167 -> {
                        offsets.set(bcs.dest());
                        yield true;
                    }
                    case 200 -> {
                        offsets.set(bcs.destW());
                        yield true;
                    }
                    case 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 198, 199 -> {
                        offsets.set(bcs.dest());
                        yield false;
                    }
                    case 170, 171 -> {
                        int delta;
                        int keys;
                        int aligned_bci = RawBytecodeHelper.align(bci + 1);
                        int default_ofset = bcs.getInt(aligned_bci);
                        if (bcs.rawCode == 170) {
                            int low = bcs.getInt(aligned_bci + 4);
                            int high = bcs.getInt(aligned_bci + 8);
                            keys = high - low + 1;
                            delta = 1;
                        } else {
                            keys = bcs.getInt(aligned_bci + 4);
                            delta = 2;
                        }
                        offsets.set(bci + default_ofset);
                        for (int i = 0; i < keys; ++i) {
                            offsets.set(bci + bcs.getInt(aligned_bci + (3 + i * delta) * 4));
                        }
                        yield true;
                    }
                    case 172, 173, 174, 175, 176, 177, 191 -> true;
                    default -> false;
                };
            }
            catch (IllegalArgumentException iae) {
                this.generatorError("Detected branch target out of bytecode range", bci);
            }
        }
        for (AbstractPseudoInstruction.ExceptionCatchImpl exhandler : this.exceptionTable) {
            try {
                offsets.set(this.labelContext.labelToBci(exhandler.handler()));
            }
            catch (IllegalArgumentException iae) {
                if (this.cp.options().filterDeadLabels.booleanValue()) continue;
                this.generatorError("Detected exception handler out of bytecode range");
            }
        }
        return offsets;
    }

    private record Type(int tag, ClassDesc sym, int bci) {
        static final Type TOP_TYPE = Type.simpleType(0);
        static final Type NULL_TYPE = Type.simpleType(5);
        static final Type INTEGER_TYPE = Type.simpleType(1);
        static final Type FLOAT_TYPE = Type.simpleType(2);
        static final Type LONG_TYPE = Type.simpleType(4);
        static final Type LONG2_TYPE = Type.simpleType(13);
        static final Type DOUBLE_TYPE = Type.simpleType(3);
        static final Type BOOLEAN_TYPE = Type.simpleType(9);
        static final Type BYTE_TYPE = Type.simpleType(10);
        static final Type CHAR_TYPE = Type.simpleType(12);
        static final Type SHORT_TYPE = Type.simpleType(11);
        static final Type DOUBLE2_TYPE = Type.simpleType(14);
        static final Type UNITIALIZED_THIS_TYPE = Type.simpleType(6);
        static final Type OBJECT_TYPE = Type.referenceType(ConstantDescs.CD_Object);
        static final Type THROWABLE_TYPE = Type.referenceType(ConstantDescs.CD_Throwable);
        static final Type INT_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_int.arrayType());
        static final Type BOOLEAN_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_boolean.arrayType());
        static final Type BYTE_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_byte.arrayType());
        static final Type CHAR_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_char.arrayType());
        static final Type SHORT_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_short.arrayType());
        static final Type LONG_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_long.arrayType());
        static final Type DOUBLE_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_double.arrayType());
        static final Type FLOAT_ARRAY_TYPE = Type.referenceType(ConstantDescs.CD_float.arrayType());
        static final Type STRING_TYPE = Type.referenceType(ConstantDescs.CD_String);
        static final Type CLASS_TYPE = Type.referenceType(ConstantDescs.CD_Class);
        static final Type METHOD_HANDLE_TYPE = Type.referenceType(ConstantDescs.CD_MethodHandle);
        static final Type METHOD_TYPE = Type.referenceType(ConstantDescs.CD_MethodType);
        private static final ClassDesc CD_Cloneable = ClassDesc.of("java.lang.Cloneable");
        private static final ClassDesc CD_Serializable = ClassDesc.of("java.io.Serializable");

        private static Type simpleType(int tag) {
            return new Type(tag, null, 0);
        }

        static Type referenceType(ClassDesc desc) {
            return new Type(7, desc, 0);
        }

        static Type uninitializedType(int bci) {
            return new Type(8, null, bci);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Type)) return false;
            Type t = (Type)o;
            if (t.tag != this.tag) return false;
            if (t.bci != this.bci) return false;
            if (!Objects.equals(this.sym, t.sym)) return false;
            return true;
        }

        boolean isCategory2_2nd() {
            return this == DOUBLE2_TYPE || this == LONG2_TYPE;
        }

        boolean isReference() {
            return this.tag == 7 || this == NULL_TYPE;
        }

        boolean isObject() {
            return this.tag == 7 && this.sym.isClassOrInterface();
        }

        boolean isArray() {
            return this.tag == 7 && this.sym.isArray();
        }

        Type mergeFrom(Type from, ClassHierarchyImpl context) {
            if (this == TOP_TYPE || this == from || this.equals(from)) {
                return this;
            }
            return switch (this.tag) {
                case 9, 10, 11, 12 -> {
                    if (from == INTEGER_TYPE) {
                        yield this;
                    }
                    yield TOP_TYPE;
                }
                default -> this.isReference() && from.isReference() ? this.mergeReferenceFrom(from, context) : TOP_TYPE;
            };
        }

        Type mergeComponentFrom(Type from, ClassHierarchyImpl context) {
            if (this == TOP_TYPE || this == from || this.equals(from)) {
                return this;
            }
            return switch (this.tag) {
                case 9, 10, 11, 12 -> TOP_TYPE;
                default -> this.isReference() && from.isReference() ? this.mergeReferenceFrom(from, context) : TOP_TYPE;
            };
        }

        private Type mergeReferenceFrom(Type from, ClassHierarchyImpl context) {
            if (from == NULL_TYPE) {
                return this;
            }
            if (this == NULL_TYPE) {
                return from;
            }
            if (this.sym.equals(from.sym)) {
                return this;
            }
            if (this.isObject()) {
                if (ConstantDescs.CD_Object.equals(this.sym)) {
                    return this;
                }
                if (context.isInterface(this.sym)) {
                    if (!from.isArray() || CD_Cloneable.equals(this.sym) || CD_Serializable.equals(this.sym)) {
                        return this;
                    }
                } else if (from.isObject()) {
                    ClassDesc anc = context.commonAncestor(this.sym, from.sym);
                    return anc == null ? this : Type.referenceType(anc);
                }
            } else if (this.isArray() && from.isArray()) {
                Type compThis = this.getComponent();
                Type compFrom = from.getComponent();
                if (compThis != TOP_TYPE && compFrom != TOP_TYPE) {
                    return compThis.mergeComponentFrom(compFrom, context).toArray();
                }
            }
            return OBJECT_TYPE;
        }

        Type toArray() {
            return switch (this.tag) {
                case 9 -> BOOLEAN_ARRAY_TYPE;
                case 10 -> BYTE_ARRAY_TYPE;
                case 12 -> CHAR_ARRAY_TYPE;
                case 11 -> SHORT_ARRAY_TYPE;
                case 1 -> INT_ARRAY_TYPE;
                case 4 -> LONG_ARRAY_TYPE;
                case 2 -> FLOAT_ARRAY_TYPE;
                case 3 -> DOUBLE_ARRAY_TYPE;
                case 7 -> Type.referenceType(this.sym.arrayType());
                default -> OBJECT_TYPE;
            };
        }

        Type getComponent() {
            if (this.sym.isArray()) {
                ClassDesc comp = this.sym.componentType();
                if (comp.isPrimitive()) {
                    return switch (comp.descriptorString().charAt(0)) {
                        case 'Z' -> BOOLEAN_TYPE;
                        case 'B' -> BYTE_TYPE;
                        case 'C' -> CHAR_TYPE;
                        case 'S' -> SHORT_TYPE;
                        case 'I' -> INTEGER_TYPE;
                        case 'J' -> LONG_TYPE;
                        case 'F' -> FLOAT_TYPE;
                        case 'D' -> DOUBLE_TYPE;
                        default -> TOP_TYPE;
                    };
                }
                return Type.referenceType(comp);
            }
            return TOP_TYPE;
        }

        void writeTo(BufWriter bw, ConstantPoolBuilder cp) {
            bw.writeU1(this.tag);
            switch (this.tag) {
                case 7: {
                    bw.writeU2(cp.classEntry(this.sym).index());
                    break;
                }
                case 8: {
                    bw.writeU2(this.bci);
                }
            }
        }
    }

    private final class Frame {
        int offset;
        int localsSize;
        int stackSize;
        int flags;
        int frameMaxStack = 0;
        int frameMaxLocals = 0;
        boolean dirty = false;
        private final ClassHierarchyImpl classHierarchy;
        private Type[] locals;
        private Type[] stack;

        Frame(ClassHierarchyImpl classHierarchy) {
            this(-1, 0, 0, 0, null, null, classHierarchy);
        }

        Frame(int offset, ClassHierarchyImpl classHierarchy) {
            this(offset, -1, 0, 0, null, null, classHierarchy);
        }

        Frame(int offset, int flags, int locals_size, int stack_size, Type[] locals, Type[] stack, ClassHierarchyImpl classHierarchy) {
            this.offset = offset;
            this.localsSize = locals_size;
            this.stackSize = stack_size;
            this.flags = flags;
            this.locals = locals;
            this.stack = stack;
            this.classHierarchy = classHierarchy;
        }

        public String toString() {
            return (this.dirty ? "frame* @" : "frame @") + this.offset + " with locals " + (this.locals == null ? "[]" : Arrays.asList(this.locals).subList(0, this.localsSize)) + " and stack " + (this.stack == null ? "[]" : Arrays.asList(this.stack).subList(0, this.stackSize));
        }

        Frame pushStack(ClassDesc desc) {
            return switch (desc.descriptorString()) {
                case "J" -> this.pushStack(Type.LONG_TYPE, Type.LONG2_TYPE);
                case "D" -> this.pushStack(Type.DOUBLE_TYPE, Type.DOUBLE2_TYPE);
                case "I", "Z", "B", "C", "S" -> this.pushStack(Type.INTEGER_TYPE);
                case "F" -> this.pushStack(Type.FLOAT_TYPE);
                case "V" -> this;
                default -> this.pushStack(Type.referenceType(desc));
            };
        }

        Frame pushStack(Type type) {
            this.checkStack(this.stackSize);
            this.stack[this.stackSize++] = type;
            return this;
        }

        Frame pushStack(Type type1, Type type2) {
            this.checkStack(this.stackSize + 1);
            this.stack[this.stackSize++] = type1;
            this.stack[this.stackSize++] = type2;
            return this;
        }

        Type popStack() {
            if (this.stackSize < 1) {
                StackMapGenerator.this.generatorError("Operand stack underflow");
            }
            return this.stack[--this.stackSize];
        }

        Frame decStack(int size) {
            this.stackSize -= size;
            if (this.stackSize < 0) {
                StackMapGenerator.this.generatorError("Operand stack underflow");
            }
            return this;
        }

        Frame frameInExceptionHandler(int flags) {
            return new Frame(this.offset, flags, this.localsSize, 0, this.locals, new Type[]{Type.TOP_TYPE}, this.classHierarchy);
        }

        void initializeObject(Type old_object, Type new_object) {
            int i;
            for (i = 0; i < this.localsSize; ++i) {
                if (!this.locals[i].equals(old_object)) continue;
                this.locals[i] = new_object;
            }
            for (i = 0; i < this.stackSize; ++i) {
                if (!this.stack[i].equals(old_object)) continue;
                this.stack[i] = new_object;
            }
            if (old_object == Type.UNITIALIZED_THIS_TYPE) {
                this.flags = 0;
            }
        }

        Frame checkLocal(int index) {
            if (index >= this.frameMaxLocals) {
                this.frameMaxLocals = index + 1;
            }
            if (this.locals == null) {
                this.locals = new Type[index + 10];
                Arrays.fill(this.locals, Type.TOP_TYPE);
            } else if (index >= this.locals.length) {
                int current = this.locals.length;
                this.locals = Arrays.copyOf(this.locals, index + 10);
                Arrays.fill(this.locals, current, this.locals.length, Type.TOP_TYPE);
            }
            return this;
        }

        private void checkStack(int index) {
            if (index >= this.frameMaxStack) {
                this.frameMaxStack = index + 1;
            }
            if (this.stack == null) {
                this.stack = new Type[index + 10];
                Arrays.fill(this.stack, Type.TOP_TYPE);
            } else if (index >= this.stack.length) {
                int current = this.stack.length;
                this.stack = Arrays.copyOf(this.stack, index + 10);
                Arrays.fill(this.stack, current, this.stack.length, Type.TOP_TYPE);
            }
        }

        private void setLocalRawInternal(int index, Type type) {
            this.checkLocal(index);
            this.locals[index] = type;
        }

        void setLocalsFromArg(String name, MethodTypeDesc methodDesc, boolean isStatic, Type thisKlass) {
            this.localsSize = 0;
            if (!isStatic) {
                ++this.localsSize;
                if (StackMapGenerator.OBJECT_INITIALIZER_NAME.equals(name) && !ConstantDescs.CD_Object.equals(thisKlass.sym)) {
                    this.setLocal(0, Type.UNITIALIZED_THIS_TYPE);
                    this.flags |= 1;
                } else {
                    this.setLocalRawInternal(0, thisKlass);
                }
            }
            block16: for (int i = 0; i < methodDesc.parameterCount(); ++i) {
                ClassDesc desc = methodDesc.parameterType(i);
                if (desc.isClassOrInterface() || desc.isArray()) {
                    this.setLocalRawInternal(this.localsSize++, Type.referenceType(desc));
                    continue;
                }
                switch (desc.descriptorString()) {
                    case "J": {
                        this.setLocalRawInternal(this.localsSize++, Type.LONG_TYPE);
                        this.setLocalRawInternal(this.localsSize++, Type.LONG2_TYPE);
                        continue block16;
                    }
                    case "D": {
                        this.setLocalRawInternal(this.localsSize++, Type.DOUBLE_TYPE);
                        this.setLocalRawInternal(this.localsSize++, Type.DOUBLE2_TYPE);
                        continue block16;
                    }
                    case "I": 
                    case "Z": 
                    case "B": 
                    case "C": 
                    case "S": {
                        this.setLocalRawInternal(this.localsSize++, Type.INTEGER_TYPE);
                        continue block16;
                    }
                    case "F": {
                        this.setLocalRawInternal(this.localsSize++, Type.FLOAT_TYPE);
                        continue block16;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not reach here");
                    }
                }
            }
        }

        void copyFrom(Frame src) {
            if (this.locals != null && src.localsSize < this.locals.length) {
                Arrays.fill(this.locals, src.localsSize, this.locals.length, Type.TOP_TYPE);
            }
            this.localsSize = src.localsSize;
            this.checkLocal(src.localsSize - 1);
            if (src.localsSize > 0) {
                System.arraycopy(src.locals, 0, this.locals, 0, src.localsSize);
            }
            if (this.stack != null && src.stackSize < this.stack.length) {
                Arrays.fill(this.stack, src.stackSize, this.stack.length, Type.TOP_TYPE);
            }
            this.stackSize = src.stackSize;
            this.checkStack(src.stackSize - 1);
            if (src.stackSize > 0) {
                System.arraycopy(src.stack, 0, this.stack, 0, src.stackSize);
            }
            this.flags = src.flags;
        }

        void checkAssignableTo(Frame target) {
            if (target.flags == -1) {
                target.locals = this.locals == null ? null : Arrays.copyOf(this.locals, this.localsSize);
                target.localsSize = this.localsSize;
                target.stack = this.stack == null ? null : Arrays.copyOf(this.stack, this.stackSize);
                target.stackSize = this.stackSize;
                target.flags = this.flags;
                target.dirty = true;
            } else {
                int i;
                if (target.localsSize > this.localsSize) {
                    target.localsSize = this.localsSize;
                    target.dirty = true;
                }
                for (i = 0; i < target.localsSize; ++i) {
                    this.merge(this.locals[i], target.locals, i, target);
                }
                for (i = 0; i < target.stackSize; ++i) {
                    this.merge(this.stack[i], target.stack, i, target);
                }
            }
        }

        private Type getLocalRawInternal(int index) {
            this.checkLocal(index);
            return this.locals[index];
        }

        Type getLocal(int index) {
            Type ret = this.getLocalRawInternal(index);
            if (index >= this.localsSize) {
                this.localsSize = index + 1;
            }
            return ret;
        }

        void setLocal(int index, Type type) {
            Type old = this.getLocalRawInternal(index);
            if (old == Type.DOUBLE_TYPE || old == Type.LONG_TYPE) {
                this.setLocalRawInternal(index + 1, Type.TOP_TYPE);
            }
            if (old == Type.DOUBLE2_TYPE || old == Type.LONG2_TYPE) {
                this.setLocalRawInternal(index - 1, Type.TOP_TYPE);
            }
            this.setLocalRawInternal(index, type);
            if (index >= this.localsSize) {
                this.localsSize = index + 1;
            }
        }

        void setLocal2(int index, Type type1, Type type2) {
            Type old = this.getLocalRawInternal(index + 1);
            if (old == Type.DOUBLE_TYPE || old == Type.LONG_TYPE) {
                this.setLocalRawInternal(index + 2, Type.TOP_TYPE);
            }
            if ((old = this.getLocalRawInternal(index)) == Type.DOUBLE2_TYPE || old == Type.LONG2_TYPE) {
                this.setLocalRawInternal(index - 1, Type.TOP_TYPE);
            }
            this.setLocalRawInternal(index, type1);
            this.setLocalRawInternal(index + 1, type2);
            if (index >= this.localsSize - 1) {
                this.localsSize = index + 2;
            }
        }

        private void merge(Type me, Type[] toTypes, int i, Frame target) {
            Type to = toTypes[i];
            Type newTo = to.mergeFrom(me, this.classHierarchy);
            if (to != newTo && !to.equals(newTo)) {
                toTypes[i] = newTo;
                target.dirty = true;
            }
        }

        private static int trimAndCompress(Type[] types, int count) {
            while (count > 0 && types[count - 1] == Type.TOP_TYPE) {
                --count;
            }
            int compressed = 0;
            for (int i = 0; i < count; ++i) {
                if (types[i].isCategory2_2nd()) continue;
                types[compressed++] = types[i];
            }
            return compressed;
        }

        void trimAndCompress() {
            this.localsSize = Frame.trimAndCompress(this.locals, this.localsSize);
            this.stackSize = Frame.trimAndCompress(this.stack, this.stackSize);
        }

        private static boolean equals(Type[] l1, Type[] l2, int commonSize) {
            if (l1 == null || l2 == null) {
                return commonSize == 0;
            }
            return Arrays.equals(l1, 0, commonSize, l2, 0, commonSize);
        }

        void writeTo(BufWriter out, Frame prevFrame, ConstantPoolBuilder cp) {
            int i;
            int offsetDelta = this.offset - prevFrame.offset - 1;
            if (this.stackSize == 0) {
                int commonLocalsSize = this.localsSize > prevFrame.localsSize ? prevFrame.localsSize : this.localsSize;
                int diffLocalsSize = this.localsSize - prevFrame.localsSize;
                if (-3 <= diffLocalsSize && diffLocalsSize <= 3 && Frame.equals(this.locals, prevFrame.locals, commonLocalsSize)) {
                    if (diffLocalsSize == 0 && offsetDelta < 64) {
                        out.writeU1(offsetDelta);
                    } else {
                        out.writeU1(251 + diffLocalsSize);
                        out.writeU2(offsetDelta);
                        for (int i2 = commonLocalsSize; i2 < this.localsSize; ++i2) {
                            this.locals[i2].writeTo(out, cp);
                        }
                    }
                    return;
                }
            } else if (this.stackSize == 1 && this.localsSize == prevFrame.localsSize && Frame.equals(this.locals, prevFrame.locals, this.localsSize)) {
                if (offsetDelta < 64) {
                    out.writeU1(64 + offsetDelta);
                } else {
                    out.writeU1(247);
                    out.writeU2(offsetDelta);
                }
                this.stack[0].writeTo(out, cp);
                return;
            }
            out.writeU1(255);
            out.writeU2(offsetDelta);
            out.writeU2(this.localsSize);
            for (i = 0; i < this.localsSize; ++i) {
                this.locals[i].writeTo(out, cp);
            }
            out.writeU2(this.stackSize);
            for (i = 0; i < this.stackSize; ++i) {
                this.stack[i].writeTo(out, cp);
            }
        }
    }
}

