/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import org.glavo.classfile.Instruction;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.BytecodeHelpers;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConvertInstruction
extends Instruction {
    public TypeKind fromType();

    public TypeKind toType();

    public static ConvertInstruction of(TypeKind fromType, TypeKind toType) {
        return ConvertInstruction.of(BytecodeHelpers.convertOpcode(fromType, toType));
    }

    public static ConvertInstruction of(Opcode op) {
        Util.checkKind(op, Opcode.Kind.CONVERT);
        return new AbstractInstruction.UnboundConvertInstruction(op);
    }
}

