/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.util.ArrayList;
import java.util.List;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.AnnotationConstantValueEntry;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AnnotationImpl;
import org.glavo.classfile.impl.TemporaryConstantPool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotationValue
extends WritableElement<AnnotationValue> {
    public char tag();

    public static OfEnum ofEnum(Utf8Entry className, Utf8Entry constantName) {
        return new AnnotationImpl.OfEnumImpl(className, constantName);
    }

    public static OfEnum ofEnum(ClassDesc className, String constantName) {
        return AnnotationValue.ofEnum(TemporaryConstantPool.INSTANCE.utf8Entry(className.descriptorString()), TemporaryConstantPool.INSTANCE.utf8Entry(constantName));
    }

    public static OfClass ofClass(Utf8Entry className) {
        return new AnnotationImpl.OfClassImpl(className);
    }

    public static OfClass ofClass(ClassDesc className) {
        return AnnotationValue.ofClass(TemporaryConstantPool.INSTANCE.utf8Entry(className.descriptorString()));
    }

    public static OfConstant ofString(Utf8Entry value) {
        return new AnnotationImpl.OfStringImpl(value);
    }

    public static OfConstant ofString(String value) {
        return AnnotationValue.ofString(TemporaryConstantPool.INSTANCE.utf8Entry(value));
    }

    public static OfConstant ofDouble(DoubleEntry value) {
        return new AnnotationImpl.OfDoubleImpl(value);
    }

    public static OfConstant ofDouble(double value) {
        return AnnotationValue.ofDouble(TemporaryConstantPool.INSTANCE.doubleEntry(value));
    }

    public static OfConstant ofFloat(FloatEntry value) {
        return new AnnotationImpl.OfFloatImpl(value);
    }

    public static OfConstant ofFloat(float value) {
        return AnnotationValue.ofFloat(TemporaryConstantPool.INSTANCE.floatEntry(value));
    }

    public static OfConstant ofLong(LongEntry value) {
        return new AnnotationImpl.OfLongImpl(value);
    }

    public static OfConstant ofLong(long value) {
        return AnnotationValue.ofLong(TemporaryConstantPool.INSTANCE.longEntry(value));
    }

    public static OfConstant ofInt(IntegerEntry value) {
        return new AnnotationImpl.OfIntegerImpl(value);
    }

    public static OfConstant ofInt(int value) {
        return AnnotationValue.ofInt(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfConstant ofShort(IntegerEntry value) {
        return new AnnotationImpl.OfShortImpl(value);
    }

    public static OfConstant ofShort(short value) {
        return AnnotationValue.ofShort(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfConstant ofChar(IntegerEntry value) {
        return new AnnotationImpl.OfCharacterImpl(value);
    }

    public static OfConstant ofChar(char value) {
        return AnnotationValue.ofChar(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfConstant ofByte(IntegerEntry value) {
        return new AnnotationImpl.OfByteImpl(value);
    }

    public static OfConstant ofByte(byte value) {
        return AnnotationValue.ofByte(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfConstant ofBoolean(IntegerEntry value) {
        return new AnnotationImpl.OfBooleanImpl(value);
    }

    public static OfConstant ofBoolean(boolean value) {
        int i = value ? 1 : 0;
        return AnnotationValue.ofBoolean(TemporaryConstantPool.INSTANCE.intEntry(i));
    }

    public static OfAnnotation ofAnnotation(Annotation value) {
        return new AnnotationImpl.OfAnnotationImpl(value);
    }

    public static OfArray ofArray(List<AnnotationValue> values) {
        return new AnnotationImpl.OfArrayImpl(values);
    }

    public static OfArray ofArray(AnnotationValue ... values) {
        return AnnotationValue.ofArray(List.of(values));
    }

    public static AnnotationValue of(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return AnnotationValue.ofString(s);
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return AnnotationValue.ofByte(b);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return AnnotationValue.ofBoolean(b);
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return AnnotationValue.ofShort(s);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return AnnotationValue.ofChar(c.charValue());
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return AnnotationValue.ofInt(i);
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return AnnotationValue.ofLong(l);
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return AnnotationValue.ofFloat(f.floatValue());
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return AnnotationValue.ofDouble(d);
        }
        if (value instanceof ClassDesc) {
            ClassDesc clsDesc = (ClassDesc)value;
            return AnnotationValue.ofClass(clsDesc);
        }
        if (value instanceof byte[]) {
            byte[] arr = (byte[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (byte el : arr) {
                els.add(AnnotationValue.ofByte(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof boolean[]) {
            boolean[] arr = (boolean[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (boolean el : arr) {
                els.add(AnnotationValue.ofBoolean(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof short[]) {
            short[] arr = (short[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (short el : arr) {
                els.add(AnnotationValue.ofShort(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof char[]) {
            char[] arr = (char[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (char el : arr) {
                els.add(AnnotationValue.ofChar(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof int[]) {
            int[] arr = (int[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (int el : arr) {
                els.add(AnnotationValue.ofInt(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof long[]) {
            long[] arr = (long[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (long el : arr) {
                els.add(AnnotationValue.ofLong(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof float[]) {
            float[] arr = (float[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (float el : arr) {
                els.add(AnnotationValue.ofFloat(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof double[]) {
            double[] arr = (double[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (double el : arr) {
                els.add(AnnotationValue.ofDouble(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (Object el : arr) {
                els.add(AnnotationValue.of(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            return AnnotationValue.ofEnum(ClassDesc.ofDescriptor(e.getDeclaringClass().descriptorString()), e.name());
        }
        throw new IllegalArgumentException("Illegal annotation constant value type " + (value == null ? null : value.getClass()));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfEnum
    extends AnnotationValue {
        public Utf8Entry className();

        default public ClassDesc classSymbol() {
            return ClassDesc.ofDescriptor(this.className().stringValue());
        }

        public Utf8Entry constantName();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfClass
    extends AnnotationValue {
        public Utf8Entry className();

        default public ClassDesc classSymbol() {
            return ClassDesc.ofDescriptor(this.className().stringValue());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfConstant
    extends AnnotationValue {
        public AnnotationConstantValueEntry constant();

        public ConstantDesc constantValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfArray
    extends AnnotationValue {
        public List<AnnotationValue> values();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfBoolean
    extends OfConstant {
        public boolean booleanValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfByte
    extends OfConstant {
        public byte byteValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfCharacter
    extends OfConstant {
        public char charValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfShort
    extends OfConstant {
        public short shortValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfInteger
    extends OfConstant {
        public int intValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfLong
    extends OfConstant {
        public long longValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfFloat
    extends OfConstant {
        public float floatValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfDouble
    extends OfConstant {
        public double doubleValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfString
    extends OfConstant {
        public String stringValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfAnnotation
    extends AnnotationValue {
        public Annotation annotation();
    }
}

